
var _FILE_NAME = "calendarLogo";

/////////////////////////////////
///// NOA へ問い合わせて得る値 /////

function currentDate(){
    return (parent() && parent().currentDate())
    ? parent().currentDate() : todayAndTime();
}

function editorElement(){
    // ReproductiveHistory を呼んだ NOA の CellEditor を返す
    // Group CELL が編集モードでない場合は null が返される
    return parent().editor_ElementForTag(parent().currentTag());
}

function subject(){
    // NOA の subject 欄のデータを返す
    var elm = editorElement();
    if (elm){
        // NOA の CellEditor が開いている場合
        // valueForTag() を使うと編集結果が反映されない
        return elm.innerHTML;
    } else {
        // NOA の CellEditor が閉じている場合
        var obj = parent().valueForTag("ProgressSection.subject");
        return (obj) ? obj.value : "";
    }
}

function setCalendar(){
    // NOA から起動されていれば妊娠歴を自動設定
    var year = 0;
    var month = 0;
    var day = 0;
    
    var buff = subject(); // subject 欄の内容を NOA から取得
    if (buff){
        var array = buff.split("lmp:");
        if (array.length > 1){
            var lmpSt = trim(array[1]);
            if (lmpSt.length >= 6){
                year = "20" + lmpSt.substr(0, 2);
                month = lmpSt.substr(2, 2);
                day = lmpSt.substr(4, 2);
            }
        }
    }
    
    setOriginalLmp(year, month, day); // カルテ本体の lmp を記憶
    
    // NOA から起動されたのでなければ何もせずに終了
    if (year * month * day == 0) return;
    
    // 最終月経のポップアップを設定
    var td = document.getElementById("lmpArea");
    td.innerHTML = "";
    newDatePopUp(td, "lmp", "", year*1, month*1, day*1, false, lmpChanged);
    
    // 予定日を計算
    calc();
    
    // 計算された予定日を NOA の編集フィールドへ書戻す
    var array = buff.split("lmp:");
    var leftSt = array[0];
    
    // "lmp:" から改行までの文字列を予定日変換文字列の対象とするので
    // 最終月経の後ろに文字があっても *** 予定日と置換 *** されてしまう
    var rightSt = array[1];
    rightSt = convertSTRING(rightSt, "<br>", "\n");
    var array2 = rightSt.split("\n");
    // lmp: の次から改行前までを termString() と置換
    array2[0] = termString(); // "lmp:150208 (4w5d) Term:2015-11-15" のような文字列
    rightSt = array2.join("\n");
    
    var value = leftSt + rightSt;
    value = convertSTRING(value, "\n", "<br>");
    var elm = editorElement(); // Group CELL のエディターが開いている場合
    if (elm){
        // elm が編集モードの場合
        elm.innerHTML = value;
    } else {
        // elm が表示モードの場合
        parent().putValueForTag(value, "ProgressSection.subject");
    }
}

///// NOA へ問い合わせて得る値 /////
/////////////////////////////////

/////////////////////////////////
///// Agent から得る値 ////////////

var _agent;
function startup(){
    // NOA から取得すべきパラメータすべてを一括取得
    _agent = agent();
    
    //console.log("startup", encodeObject(_agent)); //##
}

function hospitalName(){
    return _agent.hospitalName;
}

function owner(){
    return _agent.owner;
}

function patientId(){
    if (parent()){
        return parent().patientId();
    } else {
        return _agent.patientId;
    }
}

function patientKanjiName(){
    if (parent()){
        return parent().patientKanjiName();
    } else {
        return _agent.patientKanjiName;
    }
}

///// Agent から得る値 ////////////
/////////////////////////////////

function lmp(){
    var lmp = document.getElementById("lmp").value;
    var array = lmp.split("-");
    return new Date(array[0], array[1] - 1, array[2]);
}

function now(){
    var elm = document.getElementById("today");
    if (!elm) return null;
    
    var today = elm.value;
    var array = today.split("-");
    return new Date(array[0], array[1] - 1, array[2]);
}

var _originalLmp;
function setOriginalLmp(yyyy, mm, dd){
    // カルテ本体の lmp を記憶
    _debug("setOriginalLmp->"+yyyy+"/"+mm+"/"+dd); //##
    
    _originalLmp = yyyy + "-" + mm + "-" + dd;
}
function originalLmp(){
    // カルテ本体の lmp
    return _originalLmp;
}

var _calendarObject;
function setCalendarObject(obj){
    _calendarObject = obj;
}
function calendarObject(){
    return _calendarObject;
}

var _term;
function setTermDate(val){
    // 分娩予定日を記憶
    _term = val;
}
function termDate(){
    // 分娩予定日を "2011-08-28" 形式で返す
    return _term;
}

var _termString;
function setTermString(st){
    _termString = st;
}
function termString(){
    // "lmp:150130 (33w4d) Term:2015-11-06" 形式の文字列
    return _termString;
}

function term(lmp){
    var date = new Date();
    date.setTime(lmp.getTime() + (40 * 7 * 24 * 3600 * 1000));
    
    return date;
}

var _week;
function setWeek(wk){
    _week = wk;
}
function week(){
    // 妊娠週数を返す
    return _week;
}

function printCalendar(){
    // 妊娠歴を印刷
    var args = new Object();
    args['patientName'] = patientKanjiName();

    var lmp = document.getElementById("lmp").value;
    var array = termDate().split("-");
    args['term'] = array[0] + "年" + array[1] + "月" + array[2] * 1 + "日";

    // カレンダーの各行
    var buff = "";
    var records = calendarObject();
    for (row in records){
        var record = records[row];
        var ln = record.join(",");
        buff += ln + ";";
    }
    args['rows'] = buff;
    
    // 施設名を印字
    if (commentCalendar() > 0)
        args['commentMode'] = 1;
    
    // コメント表示モード
    if (printHospitalName() > 0)
        args['facilityName'] = hospitalName();
    
    // ロゴ
    if (logoPath())
        args['logo'] = logoPath(); // ロゴ画像の URL は相対パスの必要あり

    var st = encodeObject(args);

    //alert(buff); //##
    var url = "./printCalendar.php?value="+encodeSTRING(st);
    var win = window.open(url, "GC", "scrollbars=yes");
    win.document.title = "PRINT GC"; // window title に表示
    win.focus();
}

function calendar(lmpTime, nowTime){
    var records = new Array();
    
    // title
    var array = [" "," "];
    for (var d=0; d < 7; d++){
        array.push(d + "日");
    }
    records.push(array);
    var tm = lmpTime;
    
    // WEEK
    var lmpDay = document.getElementById("lmp").value;
    var weekNum = weekOfDate(lmpDay);
    var array = [" "," "];
    for (var d=0; d < 7; d++){
        var week = weekNum + d;
        if (week > 6) week -= 7;
        array.push("　" + weekAtIndex(week)); // 倍角空白をつけないと印刷行間が不整になる
    }
    records.push(array); 
    
    // calendar
    for (w=0; w < 43; w++){
        var array = new Array();
        if (w % 4 == 0)
            array.push("妊娠第" + (w / 4 + 1) + "月");
        else
            array.push("");
        array.push(w + "週");
        for (d=0; d < 7; d++){
            var mm = new Date(tm).getMonth() + 1;
            var dd = new Date(tm).getDate();
            if (dd == 1)
                array.push(mm + "/" + dd);
            else
                array.push(dd + "");
            tm += (24 * 3600 * 1000);
        }
        records.push(array);
    }
    
    // calendar オブジェクトを記憶
    setCalendarObject(records);
    
    // 作成した records をカレンダーとして表示
    var elm = document.getElementById("calendar");
    elm.innerHTML="";
    var tbl = newTABLE(elm, "calendarTable");
    
    for (row=0,rows=records.length; row < rows; row++){
        var tr = newTR(tbl, "", "");
        var record = records[row];
        for (col=0,cols=record.length; col < cols; col++){
            var td = newTD(tr, "cell", record[col]);
            if (col == 0){
                td.style.textAlign = "left";
                td.style.width = "80px";
            }
        }
        td.style.paddingRight = "10px";
    }
}

function gestateWeekDay(){
    // 妊娠週数・日数の配列を返す
    var lmpTime = lmp().getTime();
    var nowTime = now().getTime();
    var gw = parseInt((nowTime - lmpTime) / (7 * 24 * 3600 * 1000));
    var gd = parseInt((nowTime - lmpTime) % (7 * 24 * 3600 * 1000));
    gd /= parseInt((24 * 3600 * 1000));
    
    var array = new Array();
    array.push(gw);
    array.push(gd);
    return array;
}

function gestateWeekDay(){
    // 妊娠週数・日数の配列を返す
    var lmpTime = lmp().getTime();
    var nowTime = now().getTime();
    var gw = parseInt((nowTime - lmpTime) / (7 * 24 * 3600 * 1000));
    var gd = parseInt((nowTime - lmpTime) % (7 * 24 * 3600 * 1000));
    gd /= parseInt((24 * 3600 * 1000));
    
    var array = new Array();
    array.push(gw);
    array.push(gd);
    return array;
}

function showGW(gw, gd){
    // 妊娠週数・日数ポップアップを生成
    var span = document.getElementById("weekArea");
    if (!span) return; // まだイニシャライズ途中で weekArea が生成されていない場合
    span.innerHTML = "";
    
    var array = [""];
    for (num=0; num < 43; num++) array.push(num + "");
    var pu = newPopupMenu(span, "weekPop1", array, gw);
    pu.setAttribute("onchange", "gwChanged()");
    
    var sp = newSPAN(span, "");
    sp.innerHTML = "週";
    
    var pu = newPopupMenu(span, "weekPop2", ["", "0", "1","2", "3", "4", "5", "6"], gd);
    pu.setAttribute("onchange", "gwChanged()");
    
    var sp = newSPAN(span, "");
    sp.innerHTML = "日";
}

function calc(){
    if (!now()) // あり得ないがエラー回避のため
        return null;
    
    var array = gestateWeekDay();
    var gw = array[0];
    var gd = array[1];
    
    //console.log("calc", parent(), gw, gd); //##
    
    // 分娩予定日を計算
    var tm = term(lmp());
    var yy = tm.getYear();
    if (yy < 2000) { yy += 1900; }
    var mm = tm.getMonth() + 1;
    if (mm * 1 < 10) mm = "0" + mm;
    var dd = tm.getDate();
    if (dd * 1 < 10) dd = "0" + dd;
    var yymmdd =  yy + "-" + mm + "-" + dd;
    
    setTermDate(yymmdd); // 予定日を記憶
    
    // 予定日の文字列をドラッグ・アンド・ドロップできるようにする
    var td = document.getElementById("result");
    if (!td) return; // まだ result が生成されていない
    
    var menstrualCylce = 28;
    var days = 0; // 最終月経からの経過日数
    if (parent() && (parent().name == "noa")){
        // カルテから月経周期を取り出す
        var obj = parent().valueForTag("UniversalSection.menstrualCycle");
        var cycleSt = (obj) ? obj.value : "";
        if (cycleSt.length > 0){
            var ary = cycleSt.split("-"); // 月経周期 "28-35" 型式
            menstrualCylce = ary[0] * 1;
        }
        days = gw * 7 + gd; // 最終月経からの経過日数
    }
    
    var lmpDate = document.getElementById("lmp").value;
    if (days <= menstrualCylce){
        // 最終月経からの経過日数が月経周期を超えてなければ、経過日数・推定排卵日を表示
        var date = lmp();
        var sec = lmp().getTime();
        var d = menstrualCylce - 14; // 月経周期で排卵期タイミングを調整
        date.setTime(sec + 60 * 60 * 24 * d * 1000); // lmp から 14日後の日付
        var ovulationDay = stringWithDate(date, "noTime");
        if (countFromOne() * 1 > 0) days = days + 1;
        // NOA へ書き戻す文字列を設定
        setTermString("lmp:"+lmpString()+" ("+days+"d) 推定排卵日:"+ovulationDay);
        // 妊娠歴ツールへ表示する文字列を設定
        var str = "最終月経 " + seirekiDate(lmpDate);
        if (days) str += "<br>推定排卵日 "+seirekiDate(ovulationDay) + " (妊娠 " + days + "日目)";
        str += "<br>分娩予定日 " + seirekiDate(yymmdd) + " (妊娠 " + gw + "週 " + gd + "日)";
    } else {
        // 最終月経からの経過日数が月経周期を超えていれば通常表示
        // NOA へ書き戻す文字列を設定
        setTermString("lmp:"+lmpString()+" ("+gw+"w"+gd+"d) Term:"+yymmdd);
        // 妊娠歴ツールへ表示する文字列を設定
        var str = "最終月経 " + seirekiDate(lmpDate) ;
        str += "<br>分娩予定日 " + seirekiDate(yymmdd) + " (妊娠 " + gw + "週 " + gd + "日)";
    }
    td.innerHTML = "";
    
    var date = document.getElementById("lmp").value;
    var div = newDIV(td, "");
    div.innerHTML = str;
/*    div.innerHTML = "最終月経 " + seirekiDate(date) ;
    var array = date.split("-");
    var div = newDIV(td, "");
    div.innerHTML = "推定分娩予定日 " + seirekiDate(yymmdd) + " (妊娠" + gw + "週 " + gd + "日)";
 */

    // 妊娠週数ポップアップを更新
    showGW(gw, gd);
    
    // 予定日ポップアップを更新
    var span = document.getElementById("termArea");
    if (!span) return; // まだイニシャライズ途中で weekArea が生成されていない場合
    span.innerHTML = "";
    newDatePopUp(span, "term", "", yy, mm, dd, false, termChanged);
    
    // 妊娠暦を表示
    var lmpTime = lmp().getTime();
    var nowTime = now().getTime();
    calendar(lmpTime, nowTime);

    // 印刷のために logoPath() を取得しておく
    getImage();

    
    function lmpString(){
        var lmp = document.getElementById("lmp").value;
        var array = lmp.split("-");
        var yyyy = array[0];
        var mm = array[1] * 1;
        if (mm < 10) mm = "0" + mm;
        var dd = array[2] * 1;
        if (dd < 10) dd = "0" + dd;
        return yyyy.substr(2,2) + mm + dd;
    }
}

function changeLmpTo(lmp){
    // 最終月経ポップアップを修正：これに伴い週数・日数・予定日も修正される
    var elm = document.getElementById("lmpArea");
    elm.innerHTML = "";
    
    var ary = dateTimeArray(lmp); // lib.js
    
    // 最終月経を修正
    newDatePopUp(elm, "lmp", "", ary[0], ary[1], ary[2], false, lmpChanged);
}

function lmpChanged(){
    // 最終月経ポップアップが変更された
    calc(); // 最終月経から本日の妊娠週数・予定日を再計算
    showSendButton(true);
}
function dateChanged(){
    // 本日ポップアップが変更された
    calc(); // 最終月経から本日の妊娠週数・予定日を再計算
}

function gwChanged(){
    // 妊娠週数か日数ポップアップが変更された：最終月経と不整合あれば最終月経を修正
    var lmp = document.getElementById("lmp").value;
    var gw = document.getElementById("weekPop1").value * 1;
    var gd = document.getElementById("weekPop2").value * 1;
    
    // now(), gw, gd から 最終月経を "yyyy-mmm-dd" 型式で算出
    if (!now()){ // あり得ないがエラー回避のため
        alert("本日が未指定"); return null;
    }
    var nowTime = now().getTime();
    var lmpTime = parseInt(nowTime - ((gw * 7 + gd) * 24 * 3600 * 1000));
    var lmpDate = new Date();
    lmpDate.setTime(lmpTime);
    var lmp = stringWithDate(lmpDate); // lib.js
    
    // 変更された予定日に対し最終月経が不整合なら最終月経を修正
    var correctLmp = lmp.substr(0, 10); // "yyyy-mm-dd" 型式にする
    if (lmp != correctLmp){
        changeLmpTo(correctLmp);
        
        showSendButton(true);
    } else {
        showSendButton(false);
    }
}

function termChanged(){
    // 予定日ポップアップが変更された：最終月経と不整合あれば最終月経を修正
    //    var sp = document.getElementById("printButtonArea");
    //    if (sp) sp.innerHTML = "";
    //console.log("termChanged"); //##
    
    // lmp, term の関係に不整合あれば lmp, gw, gd を修正
    var lmp = document.getElementById("lmp").value;
    lmp = lmp.substr(0, 10); // "yyyy-mm-dd" 型式にする
    
    var term = document.getElementById("term").value;
    // term を "yyyy-mm-dd" 型式から Date() 型式に変換
    var array = term.split("-");
    var termDate = new Date(array[0], array[1] - 1, array[2]);
    // termDate から lmpDate を算出
    var lmpDate = new Date();
    lmpDate.setTime(termDate.getTime() - (40 * 7 * 24 * 3600 * 1000));
    // lmpDate を "yyyy-mm-dd hh:mm::ss" の文字列にする
    var newLmp = stringWithDate(lmpDate); // lib.js
    
    // 変更された予定日に対し最終月経が不整合なら最終月経を修正
    var correctLmp = newLmp.substr(0, 10); // "yyyy-mm-dd" 型式にする
    
    //console.log("lmp->",lmp,"correctLmp->",correctLmp); //##
    
    if (lmp != correctLmp){
        changeLmpTo(correctLmp);
        
        showSendButton(true);
    } else {
        showSendButton(false);
    }
}

function sendBack(){
    // カルテへ lmp gw term を書き戻す
    // NOA から起動されたのでなければ何もせずに終了
    if (!parent()){
        alert("親としての NOA がありません");
        return;
    }
    
    // subject 欄の内容を NOA から取得
    var buff = subject();
    
    // 計算された予定日を NOA の編集フィールドへ書戻す
    var array = buff.split("lmp:");
    var leftSt = array[0];
    
    // "lmp:" から改行までの文字列を予定日変換文字列の対象とするので
    // 最終月経の後ろに文字があっても *** 予定日と置換 *** されてしまう
    var rightSt = array[1];
    rightSt = convertSTRING(rightSt, "<br>", "\n");
    var array2 = rightSt.split("\n");
    array2[0] = termString(); // "lmp:150208 (4w5d) Term:2015-11-15" のような文字列
    rightSt = array2.join("\n");
    
    var value = leftSt + rightSt;
    value = convertSTRING(value, "\n", "<br>");
    var elm = editorElement(); // Group CELL のエディターが開いている場合
    
    if (elm){ // elm が編集モードの場合
        elm.innerHTML = value;
    } else { // elm が表示モードの場合
        parent().putValueForTag(value, "ProgressSection.subject");
    }
}
function showSendButton(status){
    // status が true なら書き戻しボタンを表示
    if (! originalLmp()) return; // NOA から起動したものではない
    
    var elm = document.getElementById("sendButtonArea");
    if (!elm) return;
    
    elm.innerHTML = "";
    if (status){
        var bt = newDIV(elm, "/yellowButton");
        bt.innerHTML = "カルテへ変更結果を書戻す";
        bt.setAttribute("onclick", "sendBack()");
        bt.style.marginLeft = "70px";
        bt.style.padding = "3px 10px";
    }
}

///////////////////////////////////////////////////
///// コメント編集 //////////////////////////////////

var _commentObj;
function addComment(){
    // コメントを _commentObj に追加
    if (!_commentObj) _commentObj = new Object();
    
    var week = elmFor("rowWeekPop").value;
    var comment = elmFor("commentF").value;
    _commentObj[week] = comment;
    
    // 編集したコメント・オブジェクトをサーバへ保存
    var args = new Object();
    args["week"] = week;
    args["comment"] = comment;
    NRCall("PUT_RH_COMMENT", args, getComments);
}
function setCommentObj(obj){
    _commentObj = obj;
}
function commentObj(){
    // コメントを記憶したオブジェクトを返す
    return _commentObj;
}

function gotComments(answer){
    var obj = JSON.parse(answer);
    //console.log("gotComments", answer); //##
    
    setCommentObj(obj);
    
    // コメント行を再表示
    showCommentRow();
}
function getComments(){
    // サーバにコメントをリクエスト
    //console.log("getComments"); //##
    NRCall("GET_RH_COMMENT", null, gotComments);
}

function removeComment(targetWeek){
    // week 行のコメントを削除
    if (confirm(targetWeek + "週のコメントを削除していいですか")) {
        // 指定した週数のコメントの削除をサーバへリクエスト
        var args = new Object();
        args["week"] = targetWeek;
        // args["comment"] が無ければ削除となる
        NRCall("PUT_RH_COMMENT", args, getComments);
    }
}

function showCommentRow(){
    // コメント行を表示
    var obj = commentObj();
    if (!obj) return;
    
    var elm = elmFor("commentRowsArea");
    if (!elm) return;
    
    elm.innerHTML = "";
    for (week in obj){
        var comment = obj[week];
        var div = newDIV(elm, "");
        // 削除アイコン
        var sp = newSPAN(div, "");
        var img = newIMAGE(sp, "", "./remove-field.png", "X");
        img.style.height = "12px";
        img.setAttribute("onclick", "removeComment('" + week + "')");
        img.setAttribute("class", "expandIcon");
        // 週数
        var dv = newDIV(div, "");
        if (week * 1 < 10) week = "0" + week;
        dv.innerHTML = week + "週";
        dv.style.marginLeft = "5px";
        dv.style.display = "inline";
        dv.style.width = "50px";
        // コメント
        var dv = newDIV(div, "");
        dv.innerHTML = comment;
        dv.style.marginLeft = "5px";
        dv.style.display = "inline";
    }
}

function openCommentEditor(){
    // コメント編集を開く
    var parentElm = elmFor("openCommentCB");
    setCommentCalendar(parentElm);
    
    var elm = elmFor("commentEditorArea");
    if (!elm) return;
    
    elm.innerHTML = "";
    if (parentElm.checked == false) return;
    
    var base = newDIV(elm, "");
    base.style.border = "thin solid #ccc";
    base.style.marginTop = "10pt";
    base.style.padding = "5px";
    base.style.fontSize = "10pt";
    
    // ヘッダー
    var div = newDIV(base, "/clearfix");
    div.style.backgroundColor = "#ec9";
    div.style.padding = "2px 0";
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "週数毎につけるコメントを編集";
    dv.style.paddingLeft = "10px";
    var dv = newDIV(div, "/right-side");
    var img = newIMAGE(dv, "", "help.png", "icon");
    img.style.height = "15px";
    img.style.position = "relative";
    img.style.top = "5px";
    img.setAttribute("onclick", "openHelp('./rhEditorHelp.html')");
    img.setAttribute("class", "expandIcon");
    
    var div = newDIV(base, "commentRowsArea");
    
    // コメント入力行を生成
    var inputDiv = newDIV(base, "");
    inputDiv.style.marginTop = "5px";
    // 妊娠週数ポップアップ
    var array = [""];
    for (num=0; num < 43; num++) array.push(num + "");
    var pu = newPopupMenu(inputDiv, "rowWeekPop", array, "");
    var sp = newSPAN(inputDiv, "");
    sp.innerHTML = "週";
    sp.style.margin = "0 5px 0 3px";
    // コメント
    var fd = newFIELD(inputDiv, "commentF", "", 38, "");
    fd.setAttribute("placeholder", "コメント"); // 入力ヒントを表示
    // 追加ボタン
    var bt = newDIV(inputDiv, "/whiteButton");
    bt.innerHTML = "追加";
    bt.setAttribute("onclick", "addComment()");
    
    getComments();
}

///// コメント編集 //////////////////////////////////
///////////////////////////////////////////////////

/////////////////////////////////////
///// LOGO //////////////////////////

var _logoPath;
var _logoElement;
function getLogoPath(imageElement){
    // imageElement：<"img src="path"> から path を取り出して記憶
    _logoElement = imageElement;
    _logoPath = null;
    var array = imageElement.split("src='");
    if (array.length > 1){
        var st = array[1];
        var ary = st.split("'");
        _logoPath = ary[0];
    }
    //console.log("getLogoPath", imageElement+" ("+_logoPath+")"); //##
}
function logoElement(){
    // "<img src='../Users/ohashi/LOGO/calendarLogo.png' width=50 height=50>" 形式
    return _logoElement;
}
function logoPath(){
    // "../Users/ohashi/LOGO/calendarLogo.png" 形式
    return _logoPath;
}

function gotImage(answer){
    //console.log("gotImage", answer); //##
    
    var value = answer;
    getLogoPath(value);
    
    var elm = document.getElementById("logoArea");
    if (!elm) return; // 初期化状態
    
    if (value.length > 0){
        // ロゴを表示
        elm.innerHTML = value;
    } else {
        // 登録ボタンを表示
        elm.innerHTML = "";
        var dummyLogo = newDIV(elm, "/dummyLogo");
        dummyLogo.innerHTML = "ロゴ登録";
    }
    
    closeFloatPanel();
}
function getImage(){
    // 画像ファイルをサーバへリクエスト
    //console.log("getImage");//##
    
    var args = new Object();
    args["owner"] = owner();
    args["filename"] = _FILE_NAME;
    
    _postServer("GET_IMAGE", "pictServer.php", args, gotImage);
}

function upload(){
    // form を submit
    var submitButton = document.getElementById("uploadForm");
    submitButton.submit();
    
    setTimeout(getImage, 3000);
}

function removedImage(answer){
    console.log("removedImage", answer);//##
    getImage();
    
    closeFloatPanel();
}
function removeImage(){
    // ロゴ画像をサーバから削除
    if (confirm("ロゴを削除していいですか")){
        var args = new Object();
        args["owner"] = owner();
        args["filename"] = _FILE_NAME;
        
        // ファイルを送らずに PUT_IMAGE をするとロゴ画像をサーバから削除
        _postServer("PUT_IMAGE", "pictServer.php", args, removedImage);
    }
}

function openLogoPanel(button){
    // ロゴ登録パネルを開く
    var pos = getPosition(button);
    var w = 300;
    var x = 15; // 表示するx座標
    var y = pos.y + 20; // 表示するy座標
    var elm = openSeeThroughPanel("_floatPanel", x, y, w, "ロゴ読込みパネル");
    var div = newDIV(elm, "logoPanelArea");
    div.style.padding = "5px 5px 0 5px";
    div.style.fontSize = "9pt";
    
    var dv = newDIV(div, "");
    
    // === FORM を生成 =============================
    var fm = newFORM(dv, "pictServer.php"); // submit で起動される URL
    fm.setAttribute("id", "uploadForm");
    // ### iframe を使うにはここがキモ ###
    fm.setAttribute("target", "iframeElement"); // iframe を指定
    
    // === ファイル選択ボタン ========================
    var dv = newDIV(fm, "file");
    var bt = newUploadBUTTON(dv, "imageFile", "files[]");
    
    // === 転送データのコンテナー =====================
    // key
    var fd = newFIELD(fm, "key", "", "", "PUT_IMAGE");
    fd.setAttribute("NAME", "command"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");
    // owner
    var fd = newFIELD(fm, "owner", "", "", owner());
    fd.setAttribute("NAME", "owner"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");
    // fileName
    var fd = newFIELD(fm, "filename", "", "", _FILE_NAME);
    fd.setAttribute("NAME", "filename"); // form で送られるパラメータ
    fd.setAttribute("type", "hidden");
    
    // === アップロード・ボタン =======================
    // ### iframe を使うにはここがキモ ###
    // form を見せない形で処理するため submit-button 機能を別に作成
    var dv = newDIV(div, "");
    dv.style.marginLeft = "3px";
    dv.style.marginBottom = "10px";
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "画像読込み";
    bt.setAttribute("onclick", "upload()");
    
    // === ロゴ削除ボタン ===========================
    var dv = newDIV(div, "");
    dv.style.marginLeft = "3px";
    dv.style.marginBottom = "10px";
    dv.setAttribute("onclick", "removeImage()");
    var spn = newSPAN(dv, "/removeLogoButton");
    var img = newIMAGE(spn, "", "remove-field.png", "remove");
    img.style.width = "12px";
    var sp = newSPAN(spn, "");
    sp.innerHTML = " ロゴを削除";
    
    // === データ戻り先として iframe を作成 ===========
    // ### iframe を使うにはここがキモ ###
    var dv = newDIV(div, "");
    dv.style.display = "none"; // 表示しない
    var fr = newIFRAME(dv, "iframeElement");
}

///// LOGO //////////////////////////
/////////////////////////////////////


function openPreference(){
    // 初期設定ペーンを開く
    var elm = document.getElementById("preferenceArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.fontSize = "9pt";
    div.style.padding = "10px";
    div.style.backgroundColor = "#ffc";
    
    var dv = newDIV(div, "");
    // 月経周期未満の場合の経過日数を１からカウント開始するか否か
    var cb = newCHECKBOX(dv, "", "月経周期未満の場合の経過日数を１からカウント", countFromOne());
    cb.setAttribute("onchange", "setCountFromOne(this)"); // localStorage.js
    // 施設名を印字
    var dv = newDIV(div, "");
    var cb = newCHECKBOX(dv, "", "施設名を印字", printHospitalName());
    cb.setAttribute("onchange", "setPrintHospitalName(this)"); // localStorage.js
    
    // ロゴ登録エリア
    var dv = newDIV(div, "logoArea");
    dv.setAttribute("onclick", "openLogoPanel(this)"); // ロゴ登録パネルを開く
    dv.style.marginTop = "10px";
    var dummyLogo = newDIV(dv, "/dummyLogo");
    dummyLogo.innerHTML = "ロゴ登録";
    // ロゴを表示
    if (logoElement()) elmFor("logoArea").innerHTML = logoElement();
    
    // コメント・エディター・エリア
    var dv = newDIV(div, "commentEditorArea");
    
    openCommentEditor();
}

function rhHelp(){
    window.open("./rhHelp.html","Help"
                ,"width=500,height=700,scrollbars=yes,resizable=yes");
}

function init(){
    // 妊娠歴ツール
    startup();
    
    var elm = document.getElementById("base");
    elm.style.fontSize = "10pt";
    
    // === HEADER ==================
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "妊娠歴 ( " + patientKanjiName() + ")";
    var dv = newDIV(div, "/right-side");
    var im = newIMAGE(dv, "", "./help.png", "?");
    im.setAttribute("onclick", "rhHelp()");
    im.style.height = "17px";
    im.style.position = "relative";
    im.style.top = "2px";
    
    // === 最終月経 =================
    var div = newDIV(elm, "");
    div.style.paddingTop = "10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "最終月経";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "lmpArea");
    var date = new Date();
    date.setTime(date.getTime() - (5 * 7 * 24 * 3600 * 1000));
    var yy = date.getYear();
    var mm = date.getMonth() + 1;
    var dd = date.getDate();
    if (yy < 2000) { yy += 1900; }
    newDatePopUp(sp, "lmp", "", yy, mm, dd, false, lmpChanged);
    
    // === 本日 ====================
    var div = newDIV(elm, "");
    div.style.paddingBottom = "10px";
    var sp = newSPAN(div, "");
    sp.innerHTML = "本日　　";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "");
    var dateTime = currentDate();
    var ary = dateTime.split(" ");
    var ary2 = ary[0].split("-");
    var yy = ary2[0];
    var mm = ary2[1];
    var dd = ary2[2];
    newDatePopUp(sp, "today", "", yy, mm, dd, false, dateChanged);
    
    // === 週数 ====================
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "週数　　";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "weekArea");
    
    // === 予定日 ====================
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "予定日　";
    sp.style.padding = "0 5px";
    var sp = newSPAN(div, "termArea");

    // === 書き戻しボタン ===============
    var div = newDIV(elm, "sendButtonArea");

    // === 週数：予定日 ===============
    var div = newDIV(elm, "/clearfix");
    div.style.margin = "5px 0 10px 0px";
    var sp = newSPAN(div, "result", "");

    // === FOOTER ====================
    var div = newDIV(elm, "/tool-footer");
    div.style.marginTop = "10px";
    // LEFT-SIDE ---------------------
    var dv = newDIV(div, "/left-side");
    dv.style.position = "relative";
    dv.style.top = "3px";
    dv.style.width = "100px";
    var sp = newSPAN(dv, "");
    var img = newIMAGE(sp, "", "./hammer.png", "X");
    img.style.height = "13px";
    img.setAttribute("onclick", "openPreference()");
    img.setAttribute("class", "expandIcon");
    var sp = newSPAN(dv, "");
    sp.innerHTML = version();
    sp.style.paddingLeft= "5px";
    // RIGHT-SIDE --------------------
    var dv = newDIV(div, "/right-side");
    // コメント付きカレンダー
    var sp = newSPAN(dv, "");
    var cb = newCHECKBOX(sp, "openCommentCB", "コメント付き", commentCalendar());
    cb.setAttribute("onchange", "openCommentEditor()"); // localStorage.js
    // 月経周期未満の場合の経過日数を１からカウント開始するか否か
    var sp = newSPAN(dv, "printButtonArea");
    var bt = newDIV(sp, "/whiteButton");
    bt.innerHTML = "印刷";
    bt.setAttribute("onclick", "printCalendar()");
    bt.style.padding = "5px 16px 2px 16px";
    bt.style.position = "relative";
    bt.style.top = "4px";
    bt.style.marginLeft = "10px";
    
    // === 初期設定エリア =========
    var dv = newDIV(elm, "preferenceArea");
    
    // === カレンダー表示エリア =========
    var dv = newDIV(elm, "calendar");
    
    // iFrame なら toggleButton にツール名を表示
    if (window.name == "iframe"){
        var toolsObj = parent().top.tools;
        var bt = toolsObj.elmFor("toggleButton");
        if (bt) bt.innerHTML = "妊娠歴ツール";
    }
    
    // NOA から起動されていれば妊娠歴を自動設定
    if (parent() && (parent().name == "noa")){
        // NOA から起動されていれば妊娠歴を自動設定
        setCalendar();
    } else {
        // 最終月経のポップアップを設定：週数日数や予定日ポップアップの設定で変更されてしまうため
        var elm = document.getElementById("lmpArea");
        elm.innerHTML = "";
        var dateTime = dateWthDiff(todayAndTime(), -6 * 7 * 60 * 24); // ６週前
        var ary = dateTime.split(" ");
        var ary2 = ary[0].split("-");
        var yy = ary2[0];
        var mm = ary2[1];
        var dd = ary2[2];
        newDatePopUp(elm, "lmp", "", yy, mm, dd, false, lmpChanged);
        
        // 予定日を計算
        calc();
    }
}

function version(){
    return "Ver.150418";
}
