
var _infoList; // タグ分けされたデータオブジェクト

//////////////////////////////////////////////////////////////////
///// 旧バージョン・データの読込処理 //////////////////////////////////
function set_infoList(answer){
    // ### 旧バージョンの読み込み ###
    // サーバから得たデータオブジェクトのリストを元に infoSack 構造を生成
    //_initDebug(true); //##
    var results = JSON.parse(answer);
    var _infoList = new Object();
    
    //_debug("results->"+encodeObject(results)); //##
    
    if (results.group){
        var array = JSON.parse(results.group);
        setGroupObj(array);
        //_debug("group->"+encodeObject(array)); //##
    }
    
    //alert("groupObj->"+groupObj()); //##
    
    _records = new Object();
    _infoList = new Object();
    var obj = results.list;
    for (fid in obj){
        var st = obj[fid]; // JSON が文字列のままで解凍されていない
        var rec = JSON.parse(st);
        _records[rec.id] = rec;
        
        //_debug("rec->"+encodeObject(rec)); //##
        
        // カテゴリーごとにデータを記憶
        var array = rec.group.split('^');
        for (num in array){
            var tag = array[num];
            if (trim(tag).length == 0) continue;
            
            if (! _infoList[tag]) _infoList[tag] = new Array();
            _infoList[tag].push(rec);
        }
    }
    _debug("_infoList->"+encodeObject(_infoList)); //##
    
    // 旧バージョン・データを読込んだ後、新バージョン・データとしてサーバへ保存
    setInfoList(_infoList); 
    
    
    // 旧バージョンのファイル類を新バージョンのディレクトリへ移動
    var args = new Object();
    args["owner"] = _owner(); // localStorage.js
    
    _postServer("COPY_OLD_FILES", "infoServer.php", args, versionUpped);
}
function versionUpped(answer){
    // 旧バージョンのファイル類を新バージョンのディレクトリへ移動
    elmFor("_debug").innerHTML = answer;
    
    // サーバに保存しデータを画面表示
    saveInfoList();
}
///// 旧バージョン・データの読込処理 //////////////////////////////////
//////////////////////////////////////////////////////////////////

function _owner(){
    return parent().owner();
}


function setInfoStructure(results){
    // サーバから得たデータオブジェクトのリストを元に infoSack 構造を生成
    //_initDebug(true); //##
    var infoObj = new Object();
    
    // カテゴリーのリスト
    if (results.group)
        var categories = JSON.parse(results.group);
    else
        var categories = [];
    _debug("categories->"+encodeObject(categories)); //##
    
    // メニュー構造
    var obj = results.list;
    _debug("obj->"+encodeObject(obj)); //##
    for (num in categories){
        var category = categories[num];
        for (fid in obj){
            var st = obj[fid]; // JSON が文字列のままで解凍されていない
            var rec = JSON.parse(st);
            
            // category を持つレコードを _infoList に収納
            if (hasCategory(rec, category)){
                if (!infoObj[category]) infoObj[category] = [];
                infoObj[category].push(rec);
            }
        }
    }
    
    setInfoList(infoObj);
    //_showStructure(infoObj); // ### debug 用に obj 構造を表示 ###
    
    function hasCategory(rec, category){
        // category を持つ rec なら true を返す
        var array = rec.group.split('^');
        for (num in array){
            if (array[num] == category) return true;
        }
        return false;
    }
}

function setInfoList(obj){
    _infoList = obj;
}
function infoList(){
    // データオブジェクトの塊を返す
    return _infoList;
}
function menusForCategory(category){
    // category に属するメニュー・オブジェクトの配列を返す
    return _infoList[category];
}
function replaceInfoList(category, menus){
    _infoList[category] = menus;
}
function changeInfoList(obj){
    // メニューオブジェクトが更新された
    for (category in _infoList){
        var newMenus = [];
        var menus = _infoList[category]; // category に属するメニュー・オブジェクトの配列
        var changed = false;
        for (num in menus){
            var rec = menus[num];  // メニュー・オブジェクトの配列
            if (rec.id == obj.id){
                newMenus.push(obj);
                changed = true;
            } else {
                newMenus.push(rec);
            }
        }
        if (!changed) newMenus.push(obj);
        _infoList[category] = newMenus;
    }
}
function removeInfo(id, label){
    // メニューを削除
    if (confirm(label + " を削除します")){
        for (category in _infoList){
            var newMenus = [];
            var menus = _infoList[category]; // category に属するメニュー・オブジェクトの配列
            for (num in menus){
                var rec = menus[num];  // メニュー・オブジェクトの配列
                if (rec.id == id) continue;
                newMenus.push(rec);
            }
            _infoList[category] = newMenus;
        }
        
        // サーバに保存する
        saveInfoList();
    }
}

function got_infoList(answer){
    // 取得したバックアップファイル名の配列から最新ファイルを取り出す
    //console.log("got_infoList->"+answer); //##
    
    var array = JSON.parse(answer);
    var files = new Array();
    for (num in array){
        // ".", ".." を削除
        if (array[num] == ".") continue;
        if (array[num] == "..") continue;
        files.push(array[num]);
    }
    
    if (files.length){
        // 新バージョンのデータが存在した
        files = files.reverse(); // 逆順にソート
        
        // 最新ファイルをサーバへリクエスト
        var args = new Object();
        args["owner"] = _owner(); // localStorage.js
        args["value"] = files[0];
        
        _postServer("GET_INFO_FILE", "infoServer.php", args, gotBackup);
    } else {
        // ### 旧バージョンのデータ読み込み ###
        _postServer("GET_INFO_LIST", "infoServer.php", null, set_infoList);
    }
}
function getInfoList(receiver){
    // データオブジェクトのリストをサーバへリクエスト
    var args = new Object();
    args["owner"] = _owner(); // localStorage.js

    _postServer("GET_INFO_DIR", "infoServer.php", args, receiver);
}

function savedInfoList(answer){
    // 画面を再表示
    getInfoList(got_infoList);
}
function saveInfoList(){
    // infoList 構造をサーバへ保存
    var args = new Object();
    args["owner"] = _owner(); // localStorage.js
    args["id"] = todayAndTimeId();
    args["value"] = encodeObject(infoList());
    
    //alert("infoList->"+args["value"]); //##
    
    _postServer("PUT_INFO_OBJECTS", "infoServer.php", args, savedInfoList);
}

function recordForId(fileId){
    // fileId に対応したデータオブジェクトを返す
    for (category in _infoList){
        var menus = _infoList[category]; // category に属するメニュー・オブジェクトの配列
        for (num in menus){
            var rec = menus[num];  // メニュー・オブジェクトの配列
            if (rec.id == fileId) return rec;
        }
    }
    return null;
}

function openWindow(answer){
    // answer で返された URL を別ウインドウで開く
    //alert("openWindow->"+answer); //##
    
    kick_window(answer, "_blank", kickedWindow);
}
function clickedLabel(filename){
    // データオブジェクトのラベルがクリックされた
    
    // filename から suffix を除去
    var pos = filename.lastIndexOf('.');
    var fileId = (pos > 0) ? filename.substr(0, pos) : filename; 
    var rec = recordForId(fileId);
    
    //alert(filename+"->"+encodeObject(rec)); //##
    
    if (editMode()){
        // 編集パネルを開く
        openEditor(fileId);
    } else {
        if (rec.url){
            // ファイル以外の URL で行頭に "http://" がない場合はそれを行頭に追加
            var url = rec.url;
            if (url.indexOf("http://") < 0) url = "http://" + url;
            
            kick_window(url, "_blank", kickedWindow);
        } else {
            var args = new Object();
            args.owner = _owner();
            args.value = filename;
            
            _postServer("GET_DATA_URL", "infoServer.php", args, openWindow);
        }
    }
}

function changeLayout(elm){
    // 編集モード / 閲覧モードで レイアウトを変更
    setCloseCategory(elm); // localStorage.js
    initInfoSack();
}

var _editMode;
function editMode(){
    // 編集モードなら true を返す
    return (_editMode) ? true : false;
}
function changeMode(){
    // 編集モード / 閲覧モードを切り替える
    _editMode = (_editMode) ? false : true;

    initInfoSack();
}

////////////////////////////////////////////////////////
///// メニューの DRAG and DROP ///////////////////////////

function m_dragstart(event){
    // ドラッグ開始時の処理
    // ドラッグするデータのid名をDataTransferオブジェクトにセット
    event.dataTransfer.setData("text", event.target.id);
}

function m_dragover(event){
    // ドラッグ要素がドロップ要素に重なっている間の処理
    //　dragoverイベントをキャンセルして、ドロップ先の要素がドロップを受け付けるようにする
    event.preventDefault();
}

function m_drop(event){
    // ドロップ時の処理
    // ドラッグされたデータのid名をDataTransferオブジェクトから取得
    var menuName = event.dataTransfer.getData("text");
    
    //id名からドラッグされた要素を取得
    var drag_elm = document.getElementById(menuName);
    
    //ドロップ先にドラッグされた要素を追加
    moveMenuTo(menuName, event.currentTarget);
    
    //エラー回避のため、ドロップ処理の最後にdropイベントをキャンセルしておく
    event.preventDefault();
}

function moveMenuTo(drop_id, target_node){
    // ドロップされたエレメントをドロップされたターゲット・エレメント位置へ移動
    var target_id = target_node.id;
    if (drop_id == target_id) return; // 自分自身は無視
    
    // ドラッグされたメニュー・オブジェクトをメニュー構造から削除し droppedMenuObj に記憶
    var droppedMenuObj; 
    var obj = infoList();
    for (categ in obj){ 
        if (categ == "filebox") continue;
        
        var newMenus = [];
        var menus = menusWithCategory(categ); // category に属するメニューの配列
        for (id in menus){ // 重複を避けるため id がキーとなった配列
            var rec = menus[id];  // メニュー・オブジェクトの配列

            if (rec.id == drop_id){
                droppedMenuObj = rec; // ドラッグされたメニューを droppedMenuObj に記憶
            } else {
                newMenus.push(rec);
            }
        }

        // infoList[category] を newMenus で更新
        replaceInfoList(categ, newMenus);
    }
    
    // ドラッグされたメニュー droppedMenuObj をドロップ位置に挿入
    var obj = infoList();
    for (category in obj){
        if (category == "filebox") continue;
                
        var newMenus = [];
        if (target_id == category + ".shelf"){ // カテゴリー・ラベルにドロップした
            droppedMenuObj.group = category;
            newMenus.push(droppedMenuObj);
        }

        var menus = menusWithCategory(category); // category に属するメニューの配列
        for (num in menus){
            var rec = menus[num];  // メニュー・オブジェクトの配列
            if (rec.group != category) continue;
                        
            newMenus.push(rec);
            if (rec.id == target_id){ // メニュー上にドロップした
                droppedMenuObj.group = category;
                newMenus.push(droppedMenuObj);
            }
        }
        
        // infoList[category] を newMenus で更新
        replaceInfoList(category, newMenus);
    }
    
    // サーバへ変更を保存しメニューを再表示
    saveInfoList();
}

///// メニューの DRAG and DROP ///////////////////////////
////////////////////////////////////////////////////////

function showInfoList(){
    // データオブジェクトをタグ形式で全面表示
    //_initDebug(true); //##
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var tbl = newTABLE(elm, "/base-table");
    
    // groupMenu() の順序で表示
    var obj = infoList();
    for (category in obj){
        if (category == "filebox") continue;
        var marked = (category == "お気に入り") ? true : false;
        
        var tr = newTR(tbl, "", "");
        tr.style.fontSize = "10pt";
                
        // カテゴリー
        var td = newTD(tr, category + ".shelf", category);
        td.style.paddingLeft = "5px";
        td.style.width = "60px";
        td.style.fontSize = "9pt";
        td.style.verticalAlign = "top";
        td.style.backgroundColor = "#a7e6d7"; // "#aec";
        td.style.borderBottom = "2px solid #fff";
        if (editMode()){
            td.setAttribute("ondragover", "m_dragover(event)");
            td.setAttribute("ondrop", "m_drop(event)");
        }
        
        // ファイル
        var td = newTD(tr, "", ""); // カテゴリーのメニュー欄
        td.style.paddingLeft = "5px";
        td.style.borderBottom = "thin solid #ccc";
        td.style.verticalAlign = "top";
        var menus = menusWithCategory(category); // category に属するメニューの配列
        for (id in menus){
            var rec = menus[id];  // メニュー・オブジェクトの配列
            // メニュー外枠を生成
            var item = newDIV(td, rec.id + "/menuItem");
            item.style.paddingLeft = "10px";
            if (marked) item.setAttribute("class", "menuItem-yellow");
            if (editMode()){
                item.setAttribute("draggable", "true"); // HTML5: ドラッグ可能にする
                item.setAttribute("ondragstart", "m_dragstart(event)");
                item.setAttribute("ondragover", "m_dragover(event)");
                item.setAttribute("ondrop", "m_drop(event)");
            }
            // メニューのラベル
            var sp = newSPAN(item, "");
            sp.innerHTML = rec.label; // FireFox では innerText を使うと表示されない
            var filename = rec.id + '.' + rec.suffix;
            sp.setAttribute("onclick", "clickedLabel('" + filename + "')");
            // 削除アイコン
            if (editMode()){
                var sp = newSPAN(item, "");
                sp.setAttribute("onclick", "removeInfo('" + rec.id+"','"+ rec.label + "')");
                sp.style.paddingLeft = "5px";
                var img = newIMAGE(sp, "", "remove-field.png", "remove");
                img.setAttribute("class", "expandIcon");
                img.style.height = "10px";
            }
        }
    }
}

function menusWithCategory(aCategory){
    // category にチェックの入ったメニュー・オブジェクトを返す
    var records = new Object();
    var obj = infoList();
    for (ctgr in obj){
        if (ctgr == "filebox") continue;
        var menus = obj[ctgr]; // category に属するメニュー・オブジェクトの配列
        for (num in menus){
            var rec = menus[num]; 
            
            // 重複を防ぐため rec.id をキーにしたオブジェクトとする
            if (rec.group.indexOf(aCategory) >= 0)
                records[rec.id] = rec;
        }
    }
    return records;
}

function changedFavorite(answer){
    // データを再読込み
    showFadeoutInfo("messageArea", "「お気に入り」を更新しました", 500);
    getInfoList(got_infoList);
}
function changeFavorite(elm, fileId){
    // お気に入りチェックボックスがクリックされた
    var addMode = elm.checked;
    
    //_initDebug(true); //##
    _debug("addMode->"+addMode); //##
    
    var pos = fileId.lastIndexOf('.');
    var fileId = (pos > 0) ? fileId.substr(0, pos) : fileId; 
    var rec = recordForId(fileId);
    if (addMode){ // 「お気に入り」を追加
        if (rec.group){
            var ary = rec.group.split("^");
            if (indexOfArray(ary, "お気に入り") < 0){
                ary.splice(0,0,"お気に入り");
                rec.group = ary.join("^");
            }
        } else {
            rec.group = "お気に入り";
        }
    } else { // 「お気に入り」を削除
        if (rec.group){
            var ary = rec.group.split("^");
            var ix = indexOfArray(ary, "お気に入り");
            if (ix >= 0){
                ary.splice(ix, 1);
                rec.group = ary.join("^");
            }
        }
    }
    _debug("rec.group->"+rec.group); //##
    
    // お気に入りに追加して保存
    changeInfoList(rec);
    saveInfoList();
}
function showChild(tag){
    // tag カテゴリーに属するファイル名をリストアップ
    var elm = elmFor("childArea");
    elm.innerHTML = "";
    
    var array = menusWithCategory(tag);
    for (id in array){
        var rec = array[id];
        if (rec.label.length == 0) continue;
        
        var filename = rec.id + '.' + rec.suffix;
        var ary = rec.group.split("^");
        var checked = (indexOfArray(ary, "お気に入り") >= 0) ? 1 : 0;
        var dv = newDIV(elm, "");
        // チェックボックス
        var cb = newCHECKBOX(dv, "", "", checked);
        cb.setAttribute("onchange", "changeFavorite(this,'" + filename + "')"); 
        // ファイル名
        var bt = newDIV(dv, "/listMember");
        bt.innerHTML = rec.label; // FireFox では innerText を使うと表示されない
        bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
        // 削除アイコン
        if (editMode()){
            var sp = newSPAN(dv, "");
            sp.setAttribute("onclick", "removeInfo('" + rec.id +"','"+ rec.label + "')");
            var img = newIMAGE(sp, "", "remove-field.png", "remove");
            img.style.height = "13px";
        }
    }
    
    // 選択タグを斑点させて再表示
    showCategory(tag);
}
function showCategory(currentTag){
    // カテゴリー・ラベルを表示
    var div = elmFor("labelArea");
    div.innerHTML = "";
    
    var obj = infoList();
    for (category in obj){
        if (category == "filebox") continue;
        
        var marked = (category == "お気に入り") ? true : false;
        
        // ラベル
        var dv = newDIV(div, category + ".tag/blueButton");
        dv.innerHTML = category; // FireFox では innerText を使うと category が表示されない
        dv.setAttribute("onclick", "showChild('" + category + "')");
        dv.style.marginRight = "5px";
        if (category == currentTag)
            dv.setAttribute("class", "selectedLabel");
        else if (marked)
            dv.setAttribute("class", "yellowButton");
        else if (category == "未分類")
            dv.setAttribute("class", "listMember");
    }
}
function showInfoLabel(){
    // データオブジェクトをラベル形式で表示
    var elm = elmFor("contentsArea");
    elm.innerHTML = "";
    var div = newDIV(elm, "labelArea");
    var div = newDIV(elm, "childArea");
    div.style.margin = "10px";
    
    // groupMenu() の順序で表示
    showCategory();
}

/////////////////////////////////////////////////////////////////
///// バックアップ ////////////////////////////////////////////////

function _showStructure(obj){
    // ### debug 用に obj 構造を表示 ###
    var elm = elmFor("_debug");
    elm.innerHTML = "";

    for (category in obj){
        if (category == "filebox") continue;

        var div = newDIV(elm, "/clearfix");
        div.style.borderBottom = "thin solid #aaa";
        // category
        var dv = newDIV(div, "");
        dv.style.width = "25%";
        dv.style.border = "thin solid #aaa";
        dv.style.backgroundColor = "#ff0";
        dv.innerHTML = category;
        
        // contents for category
        var rec = obj[category];
        for (num in rec){
            var dv = newDIV(div, "/clearfix");
            // number
            var ldv = newDIV(dv, "");
            ldv.style.width = "15px";
            ldv.style.float = "left";
            ldv.style.border = "thin solid #aaa";
            ldv.style.backgroundColor = "#f0f";
            ldv.innerHTML = num;
            // contents for category
            var vdv = newDIV(dv, "");
            vdv.style.float = "left";
            var recs = rec[num];
            vdv.innerHTML = encodeObject(recs);
        }
    }
}

function gotBackup(answer){
    // バックアップ・ファイルの内容をメニューにセット
    //alert("gotBackup->"+answer); //##
    
    var obj = decodeObject(answer);
    setInfoList(obj);    

    if (closeCategory() > 0)
        showInfoLabel(); // ラベル形式で表示
    else 
        showInfoList(); // リスト形式で表示
    
    var elm = elmFor("backupArea");
    if (elm) elm.innerHTML = "";
}
function backupSelected(){
    // バックアップ・ポップアップが選択された
    var args = new Object();
    args["owner"] = _owner(); // localStorage.js
    args["value"] = elmFor("backupPop").value;
    
    //_initDebug(true); //##
    _debug("backupSelected->"+elmFor("backupPop").value); //##
    
    _postServer("GET_INFO_FILE", "infoServer.php", args, gotBackup);
}
function showBackup(){
    // バックアップ・ペーンを表示
    var elm = elmFor("backupArea");
    if (elm.innerHTML.length){
        elm.innerHTML = "";
        return;
    }
    elm.innerHTML = "";
    var div = newDIV(elm, "");
    div.style.fontSize = "9pt";
    div.style.backgroundColor = "#ffe";
    div.style.margin = "0 10px 10px 10px";
    div.style.padding = "10px 10px";
    div.style.border = "thin solid #ccc";
    div.style.borderRadius = "8px";
    
    // バックアップ・ファイルのポップアップ・メニュー
    var dv = newDIV(div, "");
    var sp = newSPAN(dv, "backupPopArea");

    // バックアップ・ペーンが見えるようスクロール
    var pos = getPosition(div);
    window.scroll(0, pos.y + 500);
    
    getBackupList();
}

function removeBackup(){
    // 表示されているバックアップを削除
    var filename = elmFor("backupPop").value;
    if (confirm(filename + " を削除していいですか")){
        var args = new Object();
        args["owner"] = _owner(); // localStorage.js
        args["value"] = filename;
        
        _postServer("REMOVE_BACKUP", "infoServer.php", args, gotBackupList);
    }
}

function gotBackupList(answer){
    var array = JSON.parse(answer);
    //console.log("gotBackupList->"+encodeObject(array)); //##
    
    var files = new Array();
    for (num in array){
        // ".", ".." を削除
        if (array[num] == ".") continue;
        if (array[num] == "..") continue;
        files.push(array[num]);
    }
    files = files.reverse(); // 逆順にソート
    
    var elm = elmFor("backupPopArea");
    elm.innerHTML = "バックアップ";
    elm.style.fontSize = "9pt";
    // ポップアップ・メニュー
    var pu = newPopupMenu(elm, "backupPop", files, "");
    pu.style.marginLeft = "5px";
    var bt = newDIV(elm, "/whiteButton");
    bt.innerHTML = "から復元";
    bt.setAttribute("onclick", "backupSelected()");
    // 削除ボタン
    var sp = newSPAN(elm, "");
//    sp.style.paddingLeft = "5px";
    sp.setAttribute("onclick", "removeBackup()");
    var img = newIMAGE(sp, "", "remove-field.png", "remove");
    img.setAttribute("class", "expandIcon");
    img.style.height = "10px";
}
function getBackupList(){
    // バックアップ・ファイル名を取得
    var args = new Object();
    args["owner"] = _owner(); // localStorage.js
    
    _postServer("GET_INFO_DIR", "infoServer.php", args, gotBackupList);
}

///// バックアップ ////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////

function showAddIcon(elm){
    // 追加アイコンを表示
    var div = newDIV(elm, "");
    div.style.padding = "0 6px";
    var sp = newSPAN(div, "/listMember");
    sp.setAttribute("onclick", "openEditor()");
    var im = newIMAGE(sp, "", "./add-field.png", "+");
    im.setAttribute("onclick", "add()");
    im.style.height = "12px";
    im.setAttribute("class", "expandIcon");
    im.style.position = "relative";
    im.style.top = "1px";
    var sp = newSPAN(sp, "");
    sp.innerHTML = "ファイルを追加";
    sp.style.paddingLeft = "3px";
}
function showOptions(elm){
    // 設定オプションを表示
    var div = newDIV(elm, "");
    div.style.padding = "0px 10px 5px 10px";
    div.style.fontSize = "9pt";
    var sp = newSPAN(div, "");
    var cb = newCHECKBOX(sp, "", "カテゴリー表示型式", closeCategory());
    cb.setAttribute("onchange", "changeLayout(this)"); 
    var sp = newSPAN(div, "/listMember");
    sp.innerHTML = "バックアップ";
    sp.style.marginLeft = "10px";
    sp.setAttribute("onclick", "showBackup()");
    
    var div = newDIV(elm, "backupArea");
}

function search(elm){
    // 検索を実行
    var key = elm.value;
    var panel = new FloatPanel("_floatPanel", 10, 40, 300, "検索結果");
    var elm = panel.contents;
    panel.base.style.backgroundColor = "#fff";

    var obj = infoList();
    for (category in obj){
        if (category == "filebox") continue;
        
        var menus = menusWithCategory(category); // category に属するメニューの配列
        for (num in menus){
            var rec = menus[num];  // メニュー・オブジェクトの配列
            var label = rec.label;
            
            if (label.indexOf(key) >= 0){
                var div = newDIV(elm, "");
                div.style.paddingLeft = "5px";
                var bt = newDIV(div, "/yellowButton");
                bt.innerHTML = category + "： " + rec.label;
                var filename = rec.id + '.' + rec.suffix;
                bt.setAttribute("onclick", "clickedLabel('" + filename + "')");
            }
        }
    }
    var div = newDIV(elm, "");
    div.style.height = "10px";
}

function help(){
	// ヘルプパネルを表示
    window.open("./help.html","Help"
                ,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initInfoSack(){
	var elm = document.getElementById("base");
    elm.innerHTML = "";
    
    //_initDebug(true); //##
    _debug("initInfoSack->"+elm); //##
    
    // === HEADER ===============
    var div = newDIV(elm, "infoHeader");
    if (editMode()) 
        div.setAttribute("class", "yellow-header"); 
    else
        div.setAttribute("class", "tool-header"); 
    var dv = newDIV(div, "/left-side");
    dv.style.width = "80px";
    var sp = newSPAN(dv, "titleArea");
    sp.innerHTML = "InfoSack";
    var sp = newSPAN(dv, "controlArea");
    sp.style.paddingLeft = "30px";
    var dv = newDIV(div, "/right-side");
    // 検索フィールド
    if (!editMode()){
        var fd = newFIELD(dv, "searchF", "", 20, "");
        fd.setAttribute("onchange", "search(this)");
        fd.setAttribute("type", "search");
        fd.setAttribute("placeholder", "検索"); // 入力ヒントを表示
        fd.style.marginRight = "10px";
        fd.style.borderRadius = "10px";
        fd.style.position = "relative";
        fd.style.bottom = "3px";
    }
    // HELP アイコン
	var im = newIMAGE(dv, "", "./help.png", "?");
	im.setAttribute("onclick", "help()");
	im.style.height = "18px";
    im.setAttribute("class", "expandIcon");
    
    // === CONTENTS ===============
    var div = newDIV(elm, "contentsArea");
    div.style.margin = "5px 0 0 3px";
    
    if (editMode()){
        showAddIcon(elm); // ファイル追加アイコンを表示
        showOptions(elm); // 設定オプションを表示
    }

    // === FOOTER ===============
    var div = newDIV(elm, "infoFooter");
    if (editMode()) 
        div.setAttribute("class", "yellow-footer"); 
    else
        div.setAttribute("class", "tool-footer"); 
    var dv = newDIV(div, "/left-side");
    dv.style.width = "30%";
    var sp = newSPAN(dv, "");
    if (editMode()){
        var sp = newSPAN(dv, "/turn-over");
        sp.innerHTML = "<";
        sp.style.fontSize = "14pt";
        sp.setAttribute("onclick", "changeMode()");
    } else {
        var im = newIMAGE(dv, "", "./hammer.png", "?");
        im.setAttribute("onclick", "changeMode()");
    }
	im.style.height = "15px";
    im.setAttribute("class", "expandIcon");
    var dv = newDIV(div, "/right-side");
    dv.innerHTML = version();
    
    // iFrame なら toggleButton にツール名を表示
    var bt = tools().elmFor("toggleButton");
    if (bt) bt.innerHTML = "InfoSack ツール";
    
    getInfoList(got_infoList);
}

function version(){
    // Since 2013-11-18
    return "Ver.150613";
}