
/////////////////////////
///// カルテからの継承値 ///

function openChart(pid){
    if (!parent())
        alert("NOA からもう一度呼び出してください");
    else
        parent().openChart(pid);
}

///// カルテからの継承値 ///
/////////////////////////

var _records;
function setRecords(obj){
    _records = obj;
}
function records(){
    return _records;
}

/////////////////////////
///// Ajax //////////////

function searched(answer){
    //alert("searched->"+answer); //##
    var obj = JSON.parse(answer);

    //_initDebug(true); //##
    _debug("searched->"+encodeObject(obj)); //##
    
    setRecords(obj);
    showSortedList(_sortByPatientId);
}
function search(){
    // 検索を実行

    // ウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "pregFinderWindowSize");

    var elm = document.getElementById("contentsArea");
    elm.innerHTML = "検索中です...";
    
    var args = new Object();
    args['ProgressSection.subject'] = "Term:";
    args['ProgressSection.treatment'] = "産科";
    args.patientId = "";
    args.from = document.getElementById("fromDate").value;
    args.to = document.getElementById("toDate").value;
    args.unique = "unique"; // 同じ patientId の複数レコード回答を許可・不許可
    NRCall("FIND", args, searched);
}

///// Ajax //////////////
/////////////////////////

////////////////////////////////////////////
/// localStorage ///////////////////////////

function getWindowSize(){
	// Booking のウインドー位置とサイズをサーバへリクエスト
    var size = window.localStorage["pregFinderWindowSize"];
    
	// サーバから得られたサイズにウインドーを調整する
	if (size){
		var args = size.split(",");
		var x = args[0] * 1;
		var y = args[1];
		var w = args[2];
		var h = args[3];
		// resize を先にしておかないと元が大きいサイズだった場合 moveTo しよう
		// としてもウインドー境界の制限で移動できない場合がある
		window.resizeTo(w, h);
		window.moveTo(x, y);
	}
}

/// localStorage ///////////////////////////
////////////////////////////////////////////

var _sortByPatientId = 0;
var _sortByVisit = 1;
var _sortByTerm = 2;
function showSortedList(mode){
    // mode でソートしたものを表示
    var termLimit = document.getElementById("termLimit").value;
    var recs = new Array();
    obj = records();
    for (entryDate in obj){
        // rec = 'pid(04248600)name(大山　美紀)value(#3 無月経 lmp:130519 ...)'
        var rec = obj[entryDate];
        var array = rec.value.split("Term:");
        var st = (array.length > 1) ? array[1] : "";
        var term = (st.length >= 10) ? st.substr(0, 10) : "";
        if (term < termLimit) continue;
        
        rec.pid = rec.patientId;
        rec.date = entryDate.substr(0, 10);
        rec.term = term;
        
        recs.push(rec);
    }
    
    // pid でソート： ### recs が連想配列だと sort がうまく機能しない ###
    switch (mode * 1){
        case _sortByPatientId:
            recs = recs.sort(comparePid);
            showList(recs);
            break;
        case _sortByVisit:
            recs = recs.sort(compareVisit);
            showList(recs);
            break;
        case _sortByTerm:
            recs = recs.sort(compareTerm);
            showList(recs);
            break;
    }
    
    
    
    function comparePid(a, b){
        return (a['pid'] < b['pid']) ? -1 : 1;
    }
    function compareVisit(a, b){
        return (a['date'] < b['date']) ? -1 : 1;
    }
    function compareTerm(a, b){
        return (a['term'] < b['term']) ? -1 : 1;
    }
}

function checkAll(elm){
    // ヘッダーのチェックボックスがチェックされた
    var status = elm.checked;
    var tbl = elmFor("table");
    var rows = tbl.childNodes;
    for (num in rows){
        var td = elmFor(num + ".row");
        td.innerHTML = "";
        
        var cb = newCHECKBOX(td, num+".checkBox", "", (status) ? 1 : 0);
    }
}

function showList(recs){
    // obj をリスト表示する
    var elm = document.getElementById("contentsArea");
    elm.innerHTML = "";
    
    var tbl = newTABLE(elm, "table/base-table");
    tbl.style.fontSize = "9pt";
    
    // TITLE
    var tr = newTR(tbl, "", "");
    tr.style.backgroundColor = "#aec";
    var td = newTD(tr, "", "");
    td.style.verticalAlign = "top";
    var cb = newCHECKBOX(td, "", "", 0);
    cb.setAttribute("onchange", "checkAll(this)");
    td.style.width = "10px";
    var td = newTD(tr, "/activeCol", "ID");
    td.setAttribute("onclick", "showSortedList('" + _sortByPatientId + "')");
    
    var td = newTD(tr, "/col", "氏名");
    
    var td = newTD(tr, "/activeCol", "受診日");
    td.setAttribute("onclick", "showSortedList('" + _sortByVisit + "')");
    td.style.width = "80px";
    
    var td = newTD(tr, "/activeCol", "予定日");
    td.setAttribute("onclick", "showSortedList('" + _sortByTerm + "')");
    td.style.width = "80px";
    
    var td = newTD(tr, "/col", "主訴欄");

    var termLimit = document.getElementById("termLimit").value;
    var count = 0;
    for (num in recs){
        var rec = recs[num];
        
        var array = rec.value.split("Term:");
        var st = (array.length > 1) ? array[1] : "";
        var term = (st.length >= 10) ? st.substr(0, 10) : "";
        if (term < termLimit) continue;
        
        var tr = newTR(tbl, "/row", "");
        var action = "openChart('"+rec.pid+"')";
        var td = newTD(tr, num + ".row", "");
        td.style.verticalAlign = "top";
        var cb = newCHECKBOX(td, num+".checkBox", "", 0);
        var td = newTD(tr, "/patientId", rec.pid);
        td.setAttribute("onclick", action);
        var td = newTD(tr, "/col", rec.name);
        td.setAttribute("onclick", action);
        var td = newTD(tr, "/col", rec.date);
        td.setAttribute("onclick", action);
        var td = newTD(tr, "/col", rec.term);
        td.setAttribute("onclick", action);
        var td = newTD(tr, "/col", rec.value);
        td.setAttribute("onclick", action);
        count++;
    }
    var tr = newTR(tbl, "/record", "");
    var td = newTD(tr, "", "");
    td.setAttribute("colspan", "5");
    var td = newTD(tr, "/col", "( " + count + " 件ありました )");
}

function help(){
	window.open("./help.html","Help"
				,"width=450,height=700,scrollbars=yes,resizable=yes");
}

function initPregFinder(){
	var elm = document.getElementById("base");
	
	// header
    var div = newDIV(elm, "/tool-header");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = "妊婦検索";
    dv.fontSize = "10pt";
    var dv = newDIV(div, "/right-side");
    dv.style.width = "60%";
	var img = newIMAGE(dv, "helpIcon", "./help.png", "?");
	img.setAttribute("onclick", "help()");
	img.style.height = "18px";

	// ==== 検索エリア ====
    var now = todayAndTime();
    var diff = -60 * 24 * 30 * 2; // 2 ヶ月前
    var lastDate = dateWthDiff(now, diff); // now から diff 分前の日時を返す
    var ary = dateTimeArray(lastDate);
    var year0 = ary[0];
    var month0 = ary[1];
    var day0 = ary[2];
    
    var ary = dateTimeArray(now);
    var year = ary[0];
    var month = ary[1];
    var day = ary[2];
    
    var diff = 60 * 24 * 30 * 2; // 2 ヶ月後
    var lastDate = dateWthDiff(now, diff); // now から diff 分前の日時を返す
    var ary = dateTimeArray(lastDate);
    var year2 = ary[0];
    var month2 = ary[1];
    var day2 = ary[2];
    
    // --- 受診日の範囲
    var div = newDIV(elm, "searchArea");
    var dv = newDIV(div, "");
    var sp = newSPAN(dv, "/tip");
    var pm = newDatePopUp(sp, "fromDate", "", year0, month0, day0);
    var sp = newSPAN(dv, "");
    sp.innerHTML = "から";
    var sp = newSPAN(dv, "/tip");
    var pm = newDatePopUp(sp, "toDate", "", year, month, day);
    var sp = newSPAN(dv, "");
    sp.innerHTML = "までの受診者";
    // --- 分娩予定日の下限
    var dv = newDIV(div, "");
    var sp = newSPAN(dv, "/tip");
    var pm = newDatePopUp(sp, "termLimit", "", year2, month2, day2);
    var sp = newSPAN(dv, "");
    sp.innerHTML = "以後の分娩予定日のものを ";
    // --- 検索ボタン
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "search()");
	
	// データ表示エリア
    var div = newDIV(elm, "contentsArea");
	
	// footer
    var div = newDIV(elm, "/tool-footer");
    var dv = newDIV(div, "/left-side");
    dv.innerHTML = version();
    dv.style.position = "relative";
    dv.style.top = "2px";
    
    getWindowSize();
}

function version(){
    // ### Development started at 2013-02-28
    return "Ver.140715";
}