
var _oldEntryDate;
function oldEntryDate(){
    // 変更前の予約日を返す
    return _oldEntryDate;
}

function newEntryDate(){
    // 変更された予約日時を返す
    var date = getDatePopUpValue("ed_entryDate");
    var hour = document.getElementById("ed_hour").value;
    var min = document.getElementById("ed_min").value;
    
    return date+" "+hour+":"+min + ":00";
}

function openBookingEditor(patName, entryDate, isActive){
	// 分区画がクリックされた
    _oldEntryDate = entryDate;
    
	var isBlank = false;
	if (isActive == 0){
		if (!confirm("診療時間外ですが、ここに予約を入れますか？")) return;
	}
	
	var obj = new Object();
	if (entryDate.length > 10){ // entryDate = "2010-01-30 09:15:00"
		// 予約済みデータを編集
		// 記憶された records から患者オブジェクトを取り出す
		obj = patientForEntryDate(patName, entryDate);
		obj.anotherId = (obj.anotherId) ? obj.anotherId : "";
	} else { // entryDate = "09:15:00"
		// 空欄データを編集
		isBlank = true;
		var date = selectedDate().substr(0,11) + entryDate;
		obj.entryDate = date;
		if (patientId().length){
			// 予約ツールが NOA から起動された
			obj.patientId = patientId();
			obj.anotherId = anotherId();
			obj.name = patientName();
		} else {
			// 予約ツールが FRONT から起動された
			obj.patientId = "";
			obj.anotherId = "";
			obj.name = "";
		}
	}
    
    var panelW = 350;
    var panel = new FloatPanel("_floatPanel", 5, 10, panelW, "予約編集パネル", "editorHelp()");
    if (!panel) return;
    var elm = panel.contents;
    elm.style.fontSize = "9pt";
    
    // patientID 検索
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/labelCol");
    dv.innerHTML = "カルテID";
    var dv = newDIV(div, "/valCol");
    var fd = newFIELD(dv,"ed_pid","",10,obj.patientId);
    fd.setAttribute("onchange", "searchPatient()");
    fd.focus();
    var bt = newBUTTON(dv, "", "検索");
    bt.setAttribute("onclick", "searchPatient()");
    
    // anotherId
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/labelCol");
    dv.innerHTML = "anotherId";
    var dv = newDIV(div, "/valCol");
    var sp = newSPAN(dv, "ed_anotherId");
    sp.innerHTML = obj.anotherId;
    
    // 氏名
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/labelCol");
    dv.innerHTML = "氏名";
    var dv = newDIV(div, "/valCol");
    var sp = newSPAN(dv, "ed_patientName");
    sp.innerHTML = obj.name;
    
    // 予約年月日
    var yyyy = yearOfDateTime(obj.entryDate); // lib.js
    var mm = monthOfDateTime(obj.entryDate); // lib.js
    var dd = dayOfDateTime(obj.entryDate); // lib.js
    var hour = hourOfDateTime(obj.entryDate); // lib.js
    var min = minutesOfDateTime(obj.entryDate); // lib.js
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/labelCol");
    dv.innerHTML = "予約";
    sp.style.padding = "5px";
    newDatePopUp(div, "ed_entryDate", "平成", yyyy, mm, dd, false);
    var pu = newPopupMenu(div, "ed_hour", hours(), hour);
    pu.style.marginLeft = "8px";
    var pu = newPopupMenu(div, "ed_min", minutes(), min);

    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/labelCol");
    dv.innerHTML = "実施予定";
    var dv = newDIV(div, "/valCol");
    var sp = newSPAN(dv, "ed_memo_popupArea");
    showMemoPopup();
    var im = newIMAGE(dv, "", "./remove-field.png", "x");
    im.setAttribute("onclick", "removeMemo()");
    im.style.height = "14px";
    im.style.margin = "0 5px";
    im.style.position = "relative";
    im.style.top = "3px";
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "10px";
    var a = newA(dv, "空欄にする", "#", "");
    a.setAttribute("onclick", "clearMemo()");
    a.style.fontSize = "9pt";
    a.style.position = "relative";
    a.style.top = "4px";
    
    var div = newDIV(elm, "/clearfix");
    div.style.textAlign = "right";
    div.style.paddingRight = "5px";
    var memo = (obj.plan) ? obj.plan : "";
    var fd = newTEXTAREA(div, "ed_memo", 35, 5, memo);
    fd.style.fontSize = "9pt";

    var div = newDIV(elm, "/clearfix");
    div.style.padding = "5px";
    div.style.textAlign = "right";
    if (parent()){
        var bt = newBUTTON(div, "", "カルテを開く");
        bt.setAttribute("onclick", "openChart()");
    }
    if (!isBlank){
        var bt = newBUTTON(div, "", "削除");
        bt.setAttribute("onclick", "removeBooking()");
        var bt = newBUTTON(div, "", "予約票発行");
        bt.setAttribute("onclick", "printBooking()");
    }
    var sp = newSPAN(div, "ed_ok_button");
    if (obj.patientId.length){
        var bt = newBUTTON(sp, "", "確定");
        bt.setAttribute("onclick", "saveBooking()");
    }

    
    // 検索結果表示エリア
    var dv = newDIV(elm, "ed_patientListArea");
}

