

/////////////////////////
///// カルテからの継承値 ///

function owner(){
    return parent().owner();
}

///// カルテからの継承値 ///
/////////////////////////


var _fieldName;
function setTagetField(fieldName){
	// calendar ツールを呼ぶ前に対象フィールドを記憶しておく
	_fieldName = fieldName;
}
function fieldname(){
	return _fieldName;
}

var _labelTable;
function setLabelTable(array){
	_labelTable = array;
}
function labelTable(){
	// array[label] = tag 形式の配列を返す
	return _labelTable;
}
function tagForLabel(label){
	// label に対する tag を返す
	return _labelTable[label];
}




////////////////////////////////
/// neuron.js による処理 /////////

function found(answer){
	// 検索結果を表示
	var obj = JSON.parse(answer);
    // alert("found->"+encodeObject(obj)); //##
    
	showResults(obj);
}
function find(){
	// 検索を実行

    // ウインドー位置とサイズをサーバへ記憶
    put_windowSize(0, -22, "finderWindowSize");
    
    
	var from = document.getElementById("from").value;
	var to = document.getElementById("to").value;
    
    var conditions = new Object();
    var args = new Object();
    for (i=0; i < _keyNum; i++){
        var label = elmFor("labelName." + i).value; // ラベル名
        var tag = tagForLabel(label);
        args[tag] = elmFor("key." + i).value;
        conditions[label] = elmFor("key." + i).value; // 検索条件表示用
    }
    
    // listMaker へ渡す情報を localStorage に記憶
    var st = "条件検索（ ";
    st += from + " から " + to + " で ";
    st += encodeObject(conditions) + " の検索結果 ）";
    setListMakerHeader(st);
    
    args["patientId"] = "";
    args["from"] = from;
    args["to"] = to;
    args["unique"] = "on";
    //console.log("find: args", args); //##
    
    NRCall("FIND", args, found);
}

/// neuron.js による処理 /////////
////////////////////////////////

function patientIdClicked(patientId){
	// カルテを開く
    parent().openChart(patientId);
}

function showResults(obj){
	// JSON obj を元に結果を表示
	// $rec[entryDate] = { 'patientId' = $pid, 'value' = $value } 形式で返す
    //alert("showResults->"+encodeObject(obj)); //##
    
	var isMultiPatient = true;
	
	var elm = parent().elmFor("workArea");
	elm.innerHTML = "";
    
	var tbl = newTABLE(elm, "/base-table");
	tbl.style.fontSize = "9pt"; // Firefox では CSS に書いても反映されない
	tbl.style.margin = "2px";
	
	// header
	var tr = newTR(tbl, "resultHeader", "");
    tr.style.background = "#eee";
	var td = newTD(tr, "dateHeader", "");
    var im = newIMAGE(td, "icon", "./close.png", "?");
    im.style.height = "12px";
    im.setAttribute("onclick", "closeWorkArea()");
    im.setAttribute("class", "expandIcon");
    var sp = newSPAN(td, "");
    sp.innerHTML = "受診日";
    sp.style.paddingLeft = "5px";
	if (isMultiPatient){
		var td = newTD(tr, "", "カルテID");
		var td = newTD(tr, "", "氏名");
	}
    // 検索対象ラベル名：複数検索であっても最初のラベルのみ
    var td = newTD(tr, "", elmFor("labelName." + 0).value);
	
	// results
    var srcObj = new Object();
	var key = document.getElementById("key.0").value;
	var num=0;
	for (datetimeAndPid in obj){
		var rec = obj[datetimeAndPid];
		// datetimeAndPid には、同じ entryDate の患者を区別するため カルテID がついている
        //console.log("rec", encodeObject(obj)); //##
		// datetimeAndPid:"2009-03-10 10:44:00 03234200"
		// 時刻を削除し日付のみ取り出す
		var array = datetimeAndPid.split(" ");
		var date = array[0];
		var entryDate = array[0] + " " + array[1];

		var pid = rec['patientId'];
		var name = (rec['name']) ? rec['name'] : "";
        
        srcObj[pid] = entryDate; // listMaker で利用する受診日
				
		var tr = newTR(tbl, "/row", "");
        var action = "parent().openChartAsAnotherWindow('" + pid + "')";
        tr.setAttribute("onclick", action);
        
		// 受診日
		var td = newTD(tr, "date", date);
		
        // カルテID
        var td = newTD(tr, "patientId", pid);
        
        // 氏名
        var td = newTD(tr, "name", name);
        
		// 検索結果：検索キーに一致した欄を一定の長さで表示
		var val = rec['value'];
		val = val.substr(0, 30);
		val = transferToCR(val);
		var td = newTD(tr, "", val);
		num++;
	}
	
    // listMaker へ渡す情報を localStorage に記憶
    setListMakerSrc(srcObj); 
    
	// 検索件数表示
	var tr = newTR(tbl, "", "");
    tr.style.background = "#eee";
	var td = newTD(tr, "buttonArea", "");
	td.style.fontSize = "10pt"; // Firefox では CSS に書いても反映されない
	td.setAttribute("colspan", "4");
    // listMaker を立ち上げるボタンを生成
    var img = newIMAGE(td, "outArrow", "./outArrow.png", "?");
    img.style.height = "14px";
    img.style.marginLeft = "5px";
    img.setAttribute("onclick", "openListMaker()");
    img.setAttribute("class", "expandIcon");
    //setInfoTip("outArrow", "検索結果を別パネルで詳細表示"); // INFO
    var sp = newSPAN(td, "");
    sp.innerHTML = num + " 件 みつかりました";
    sp.style.padding = "0 5px";
}

var _keyNum;
function addSearchKey(){
    // 検索フィールドを追加
    var elm = elmFor("searchKeyArea");
    var div = newDIV(elm, "/clearfix");
    var tagItems = tagMenuItems();
    var pu = newPopupMenu(div, "labelName." + _keyNum, tagItems, "主訴");
    var sp = newSPAN(div, "");
    sp.innerHTML = "に";
    sp.style.padding = "0 5px";
    // 検索キー
    var fd = newFIELD(div, "key." + _keyNum++, "", 30, "");
    fd.setAttribute("type", "search");
    fd.focus();
    var sp = newSPAN(div, "");
    sp.innerHTML = "を含む";
    sp.style.paddingLeft = "5px";
}

function tagMenuItems(){
	// array[ラベル名]=タグ名 の配列を返す
	var menuItems = new Array();
	var labelTable = new Array();
    
    if (parent())
        var obj = parent().labelTagValue(); // NOA の全 CELL の tag
    else // login パネルから利用される場合
        var obj = labelTagValue(); // NOA の全 CELL の tag
    
	for (label in obj){
		if (label.length > 0){
			var tag = obj[label];
			menuItems.push(label);
			labelTable[label] = tag;
		}
	}
	setLabelTable(labelTable);
	return menuItems;
}

function makeChartFinder(){
    // 条件検索画面を生成
    var elm = elmFor("chartFinderArea");
    elm.innerHTML = "";
    elm.style.marginBottom = "10px";
    elm.style.fontSize = "9pt";
    
    // 検索範囲
    var date = today(); // lib.js
    var array = date.split("-");
    var yy = array[0] * 1;
    var mm = array[1] * 1;
    var dd = array[2] * 1;
    
    var div = newDIV(elm, "");
    var label = nengou(yy-1); // 西暦に相当する年号
    newDatePopUp(div, "from", label, yy, 1, 1, false);
    var tx = newTEXT(div, "から");
    
    var div = newDIV(elm, "");
    var label = nengou(yy); // 西暦に相当する年号
    newDatePopUp(div, "to", label, yy, mm, dd, false);
    var tx = newTEXT(div, "まで");

    // 検索フィールド
    var div = newDIV(elm, "searchKeyArea");
    _keyNum = 0;
    addSearchKey();
    
    // 検索ボタン
    var div = newDIV(elm, "/clearfix");
    var dv = newDIV(div, "/left-side");
    dv.style.paddingLeft = "0";
    var sp = newSPAN(dv, "/listMember");
    sp.innerHTML = "かつ";
    sp.style.position = "relative";
    sp.style.top = "2px";
    sp.setAttribute("onclick", "addSearchKey()");
    var dv = newDIV(div, "/right-side");
    var bt = newSPAN(dv, "/greenButton");
    bt.innerHTML = "検索";
    bt.setAttribute("onclick", "find()");
}

