<?php
    
    function rootDir(){
        // $rootDir = "../../" のような指定方法では認識されず "" になってしまう
        //return "../../"; // /X/NOA の場合
        return "../"; // /NOA の場合
    }

    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("'", $array);
        $array = explode("%xa;", $val); // DocMaker の Image 用
        $val = implode("\\'", $array);
        return $val;
    }
    
    function leftBrackets(){
        // $leftBrackets = "\^\[\^" では誤作動
        //	return "\^\[\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        return "^[^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function rightBrackets(){
        return "^]^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
        //	return "\^\]\^"; // encode 中で使う '(' -- クライアント側との約束 lib.js
    }
    function decodeObject($buff){
        // "key(value)" 形式の文字列を OBJECT に decode して返す
        $obj = array();
        //	echo "decodeObject ===\n$buff\n"; //##
        for ($p=$begin=$nest=0, $len=strlen($buff); $p < $len; $p++){
            $ch = substr($buff, $p, 1);
            if (strcmp($ch, "(") == 0){
                if ($nest == 0){
                    $key = trim(substr($buff, $begin, $p - $begin)); // key 終端
                    $begin = $p + 1; // value 開始位置
                }
                $nest++;
            } else if (strcmp($ch, ")") == 0){
                if (--$nest == 0){
                    if ($nest == 0){
                        // value 終端 ( trim しない )
                        $value = substr($buff,$begin,$p-$begin);
                        $begin = $p + 1; // key 開始位置
                    }
                    if (preg_match("/\)/", $value)){ // まだ入れ子になっているなら
                        $obj[$key] = decodeObject($value);
                    } else {
                        // 特定文字を "(", ")" へ戻す
                        $array = explode(leftBrackets(), $value);
                        $value = join("(", $array);
                        $array = explode(rightBrackets(), $value);
                        $value = join(")", $array);
                        
                        $obj[$key] = $value;
                    }
                    //echo "$key{".$obj[$key]."}\n"; //##
                }
            }
        }
        return $obj;
    }
    
    function timestamp(){
        // 現在のタイムスタンプを返す updateTime に使う
        date_default_timezone_set("Asia/Tokyo");
        return date("Y-m-d H:i:s",time());
    }
    
    function dirForOwnerAndFolder($owner, $folder, $subfolder){
        // $dir が無ければ作成
        $dir = rootDir()."Users";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        $dir = "$dir/$owner";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        $dir = "$dir/$folder";
        if (! file_exists($dir)){
            // $dir が無ければ作成
            echo "($dir) is not exist, so I'll make directory. \n"; //##
            mkdir($dir);
        }
        if (strlen($subfolder) > 0){
            $dir = "$dir/$subfolder";
            if (! file_exists($dir)){
                // $dir が無ければ作成
                echo "($dir) is not exist, so I'll make directory. \n"; //##
                mkdir($dir);
            }
        }
        
        return $dir;
    }
    
    function putArvhiveFile($owner, $folder, $subfolder, $array){
        $dir = dirForOwnerAndFolder($owner, $folder, $subfolder);
        date_default_timezone_set("Asia/Tokyo");
        $timestamp = date("YmdHi",time()); // 201305040805 型式
        $filename = "$dir/$timestamp.txt";
        $json = json_encode($array); // JSON に変換
        
        echo "<SEPARATOR>";
        if (!$handle = fopen($filename, 'w')) {
            // $filenameを書き出しモードでオープン
            echo "ERROR: Cannot open file ($filename)";
        } else {
            if (fwrite($handle, $json) === FALSE) {
                // オープンしたファイルに$buffを書き込む
                echo "ERROR: Cannot write to file ($filename)";
            } else {
                echo "メニュー構造を ($filename) に保存しました";
                fclose($handle);
            }
        }
    }
    
    function getDir($dir){
        // $dir 内のファイルをリストアップ
        echo "getDir($dir)\n"; //##
        
        $results = array();
        $array = array();
        $files = scandir($dir);
        $count=count($files);
        echo "files($files) count($count)\n"; //##
        
        for ($i=0; $i < $count; $i++){
            $filename = $files[$i];
            echo "$i ($filename)\n"; //##

            // "." で始まるファイル名はスキップ
            if (strpos($filename, ".") == 0) continue;
            
            // folder は除外する
            $path = "$dir/$filename";
            if (scandir($path)) continue;
            
            $array[] = $filename;
        }
        rsort($array); // 逆順にソート
        $results['path'] = $dir;
		$results['files'] = $array;
        
        return $results;
    }
	
 
    
    /* ########################################
     ### 以下でも $_POST['key'] と同じに機能する ###
     if (isset($_REQUEST['key'])) {
         $key = $_REQUEST['key'];
     }
     ########################################## */
    
    $command = $_POST['command'];
    $owner = $_POST['owner'];
    $patientId = $_POST['patientId'];
    $folder = $_POST['folder'];
    $folder = decodeSTRING($folder);
    $subfolder = $_POST['subfolder'];
    $filename = $_POST['filename'];
    $filename = decodeSTRING($filename);
    $value = $_POST['value'];
    $value = decodeSTRING($value);
    
    // DB を開いて該当レコードを読み込む
    // ### セキュリティーを保つには、以下のファイルを外からアクセスできない
    // ### directory に置き、以下の cfg.php の pass をそこへ変更
    require_once('cfg.php');
    
    $link = mysqli_connect($db['host'], $db['user'], $db['pwd'], $db['dbname']);
    // 接続状況をチェック
    if (mysqli_connect_errno()) {
        echo("Connect failed: ".mysqli_connect_error()." <br>");
        exit();
    }
    $db_select = mysqli_select_db($link, $db['dbname']);
    mysqli_query($link, "set names utf8");

    // 以下は Web サーバ経由でなく Draw から dir を辿るので絶対パスでなく相対パス
    // $homeDir = "../../NOA_ARCHIVE"; // ## /X/NOA ##########
    $homeDir = "../NOA_ARCHIVE";
    
    if (! file_exists($homeDir)) mkdir($homeDir);
    $dir = "$homeDir/$folder";
    if (! file_exists($dir)) mkdir($dir);
    $path = ($filename && (strlen($filename) > 0)) ? "$dir/$filename" : $dir;
    
    
    if (strcmp($command,"PUT_ARCHIVE_FILE") == 0){
        $array = decodeObject($value);
        putArvhiveFile($owner, $folder, $subfolder, $array);
    } else if (strcmp($command,"PUT_TOOL_MENU") == 0){
        // TOOL_MENU の配列を POST 型式で受け取りサーバへ保存
        $tag = "TOOL_MENU";
        $menuArray = decodeObject($value);
        
		foreach($menuArray as $num=>$rec){
            $id = $rec['id'];
            $menuType = $rec['menuType']; // _progress, _basic, _insurance
            $label = $rec['label'];
            $url = $rec['url']; $url = decodeSTRING($url);
            $win = $rec['window'];
            $fix = $rec['fix'];
            $sub = $rec['subTitle'];
            $dis = $rec['disabled'];
            $icon = $rec['icon'];
            $editor = $rec['editor']; // infoTip
            $number = $rec['number'];
            
            $sql = "SELECT * FROM `FieldTable` WHERE `tag`='$tag' AND `label`='$label' AND `owner`='$owner'";
            //echo "----- $sql \n"; //##
            $result=mysqli_query($link, $sql);
            
            if (mysqli_num_rows ($result) > 0){ // 同じ日付・更新時のデータが存在した
                $isMatched = FALSE;
                while ($row=mysqli_fetch_array($result)){
                    $rowid = $row['rowid'];
                    if ($isMatched == FALSE) {
                        // backup から復元した場合、一致する id が存在しないこともある：データ更新
                        $sql = "UPDATE `FieldTable` SET `buttonType`='$win',`menuType`='$menuType',`menuAction`='$fix',`fieldType`='$sub',`disabled`='$dis',`editor`='$editor',`script`='$url',`label`='$label',`id`='$id',`numbering`='$number',`fontFamily`='$icon' WHERE `rowid`='$rowid'";
                        if (strcmp($row['script'], '*** SAME ***') != 0) //## とりあえず
                            $isMatched = TRUE;
                    } else {
                        // 重複したレコードがあれば削除
                        //$sql = "DELETE FROM `FieldTable` WHERE `rowid`='$rowid'";
                        $sql = "UPDATE `FieldTable` SET `buttonType`='$win',`menuType`='$menuType',`menuAction`='$fix',`fieldType`='$sub',`disabled`='$dis',`editor`='$editor',`script`='*** SAME ***',`label`='$label',`id`='$id',`numbering`='$number',`fontFamily`='$icon' WHERE `rowid`='$rowid'";
                    }
                }
            } else {
                // numbering はメニューの表示順を決めるので重複しないこと
                // 通常はクラインと側で numbering を調整して送ってくる
                $sql = "INSERT INTO `FieldTable` (`owner`,`tag`,`buttonType`,`menuType`,`menuAction`,`fieldType`,`disabled`,`editor`,`id`,`script`,`label`,`numbering`,`fontFamily`) VALUES ('$owner','$tag','$win','$menuType','$fix','$sub','$dis','$editor','$id','$url','$label','$number','$icon')";
            }
            echo "----- $sql \n"; //##
            $result=mysqli_query($link, $sql);
		}
        
        // ====== バックアップ・ファイルを保存 ========
        putArvhiveFile($owner, "TOOL_MENU", "", $menuArray);
        
        echo "<SEPARATOR>";
        echo "メニュー構造を保存しました";
    } else if (strcmp($command,"PUT_LAYOUT") == 0){
        // LAYOUT 属性を FieldTable へ保存
        $recs = decodeObject($value);
        $direction = "CELL";
        $freq = 0; // 自動 numbering する
        $timestamp = timestamp();
        
		foreach($recs as $num=>$rec){
            // $owner は $recs に含まれず $_POST['owner'] から取得
            $tag = $rec['tag'];
            $buttonType = $rec['buttonType'];
            $menuType = $rec['menuType'];
            $menuAction = $rec['menuAction'];
            $hitAndRun = $rec['hitAndRun'];
            $fieldType = $rec['fieldType'];
            $direction = 'CELL'; // 第８世代 NOA 用識別子
            $disabled = $rec['disabled'];
            $editor = $rec['editor'];
            $id = $rec['id']; // 数値だと、第７世代 NOA の CELL_ID とカブる
            $script = $rec['script'];
            $bgcolor = $rec['bgcolor'];
            $label = $rec['label'];
            // numbering = $freq++;
            $study = $rec['study'];
            $fontSize = $rec['fontSize'];
            $fontFamily = $rec['fontFamily'];
            $color = $rec['color'];
            $installMode = $rec['installMode'];

            $sql = "SELECT * FROM `FieldTable` WHERE `owner`='$owner' AND `direction`='CELL' AND `tag`='$tag'";

            echo "=== $num $label === \n"; //##

            $result=mysqli_query($link, $sql);
            if ($row=mysqli_fetch_array($result)){
                if (!$installMode){
                    $rowid = $row['rowid'];
                    $sql = "UPDATE `FieldTable` SET `buttonType`='$buttonType',`menuType`='$menuType',`menuAction`='$menuAction',`hitAndRun`='$hitAndRun',`fieldType`='$fieldType',`disabled`='$disabled',`editor`='$editor',`id`='$id',`script`='$script',`bgcolor`='$bgcolor',`label`='$label',`numbering`='$freq',`study`='$study',`fontSize`='$fontSize',`fontFamily`='$fontFamily',`color`='$color',`updateTime`='$timestamp' WHERE `rowid`='$rowid'";
                }
            } else {
                $sql = "INSERT INTO `FieldTable` (`owner`,`tag`,`buttonType`,`menuType`,`menuAction`,`hitAndRun`,`fieldType`,`direction`,`disabled`,`editor`,`id`,`script`,`bgcolor`,`label`,`numbering`,`study`,`fontSize`,`fontFamily`,`color`,`updateTime`) VALUES ('$owner','$tag','$buttonType','$menuType','$menuAction','$hitAndRun','$fieldType','$direction','$disabled','$editor','$id','$script','$bgcolor','$label','$freq','$study','$fontSize','$fontFamily','$color','$timestamp')";
            }
            echo "----- $sql \n"; //##
            $result=mysqli_query($link, $sql);
            $freq += 1;
		}
        
        echo "<SEPARATOR>";
        echo "ラベル順序を保存しました";
    } else if ($command == "PUT_INS_IMAGE"){
        if ($value){
            $dir = rootDir()."NOA_ARCHIVE";
            
            echo "filename($filename) \n";

            if (! file_exists($dir)) mkdir($dir);
            $dir = "$dir/$patientId";
            if (! file_exists($dir)) mkdir($dir);
            $dir = "$dir/Insurance";
            if (! file_exists($dir)) mkdir($dir);
            
            $path = "$dir/$filename";
            
            echo "path: $path \n";
            
            // もし同一名のファイルがあればファイル名を変更しバックアップとして保存
            if (is_readable($path)){
                $newPath = "$dir/_$filename";
                // ファイル名の頭に削除マーク "_" を付ける
                rename($path, $newPath);
            }
            
            echo "renamed: $newPath \n";

            if (!$fp = fopen($path, 'w')) {
                // $filenameを書き出しモードでオープン
                echo "ERROR: Cannot open file ($path)";
            } else {
                // ### 画像の場合 base64 で変換する必要がある
                $value = base64_decode($value, FALSE);
                
                $size = fwrite($fp, $value);
                if ($size === FALSE) {
                    // オープンしたファイルに$buffを書き込む
                    echo "ERROR: Cannot write to file ($path)";
                } else {
                    echo "<SEPARATOR> Saved size( $size )\n Path( $path )";
                    fclose($fp);
                }
            }
        } else {
            echo "<SEPARATOR>Has no base64 \nval($value)";
        }
    } else if ($command == "PUT_IMAGE"){
        // 画像を保存
        if ($value){
            $dir = rootDir()."NOA_ARCHIVE";
            
            echo "filename($filename) \n";
            
            if (! file_exists($dir)) mkdir($dir);
            $dir = "$dir/$patientId";
            if (! file_exists($dir)) mkdir($dir);
            
            if (strlen($folder) > 0){ // $folder PATH を追加
                $dir = "$dir/$folder";
                if (! file_exists($dir)) mkdir($dir);
            }
            
            $path = "$dir/$filename";
            
            echo "path: $path \n";
            
            // もし同一名のファイルがあればファイル名を変更しバックアップとして保存
            if (is_readable($path)){
                $newPath = "$dir/_$filename";
                // ファイル名の頭に削除マーク "_" を付ける
                rename($path, $newPath);
            }
            
            echo "renamed: $newPath \n";
            
            if (!$fp = fopen($path, 'w')) {
                // $filenameを書き出しモードでオープン
                echo "ERROR: Cannot open file ($path)";
            } else {
                // ### 画像の場合 base64 で変換する必要がある
                $value = base64_decode($value, FALSE);
                
                $size = fwrite($fp, $value);
                if ($size === FALSE) {
                    // オープンしたファイルに$buffを書き込む
                    echo "ERROR: Cannot write to file ($path)";
                } else {
                    echo "<SEPARATOR> Saved size( $size )\n Path( $path )";
                    fclose($fp);
                }
            }
        } else {
            echo "<SEPARATOR>Has no base64 \nval($value)";
        }
    } else if ($command == "GET_DIRECTORY"){
        $results = getDir($path);
		echo "<SEPARATOR>";
		echo json_encode($results);
    } else {
        echo "<p>( $command ) is wrong command *****</p>";
    }
    
?>