<?php
    
    function decodeSTRING($val){
        // #, &, +  < > などが URI 送信で化けるため encode して送られたものを decode
        $array = explode("%x0;", $val);
        $val = implode("#", $array);
        $array = explode("%x1;", $val);
        $val = implode("&", $array);
        $array = explode("%x2;", $val);
        $val = implode("+", $array);
        $array = explode("%x3;", $val);
        $val = implode("<", $array);
        $array = explode("%x4;", $val);
        $val = implode(">", $array);
        $array = explode("%x5;", $val);
        $val = implode(" ", $array);
        $array = explode("%x6;", $val);
        $val = implode("\\n", $array);
        $array = explode("%x7;", $val);
        $val = implode("\"", $array);
        $array = explode("\&quot;", $val);
        $val = implode("\"", $array);
        $array = explode("%x8;", $val);
        $val = implode("$", $array);
        $array = explode("%x9;", $val);
        $val = implode("'", $array);
        return $val;
    }
    
    function wareki($currentDate){
        if (strlen(trim($currentDate)) == 0) return "";
        
        $ary = explode(" ", $currentDate);
        $array = explode("-", $ary[0]);
        $yy = $array[0] * 1;
        $mm = $array[1] * 1;
        $dd = $array[2] * 1;
        if ($yy == 0) return "";
        
        if ($yy > 1988){
            $yy -= 1988;
            $nengou = "平成".$yy;
        }
        else if ($yy > 1925) {
            $yy -= 1925;
            $nengou = "昭和".$yy;
        }
        else if ($yy > 1911) {
            $yy -= 1911;
            $nengou = "大正".$yy;
        }
        else {
            $yy -= 1867;
            $nengou = "明治".$yy;
        }
        return "$nengou年 $mm月 $dd日";
    }
    
    function age($bdate, $currentDate){
        $yyyy = substr($bdate, 0, 4);
        $mm = substr($bdate, 5, 2);
        $dd = substr($bdate, 8, 2);
        $bday = "$yyyy$mm$dd" - 0;
        
        $yyyy1 = substr($currentDate, 0, 4);
        $mm1 = substr($currentDate, 5, 2);
        $dd1 = substr($currentDate, 8, 2);
        $now = "$yyyy1$mm1$dd1" - 0;
        
        return floor(($now - $bday) / 10000);
    }
    
    function ageOf($link, $pid, $dateTime){
        // $patientId の $dateTime における年令を返す
        $query = "SELECT * FROM `PatientTable` WHERE `patientId`='$pid'";
        $result=mysqli_query($link, $query);
        if ($row=mysqli_fetch_array($result)){
            $birthDate = $row['birthDate'];
            return age($birthDate, $dateTime);
        }
        return "";
    }
    
    function showDayTitle($date){
        $yy1 = substr($date, 0, 4);
        $mm1 = substr($date, 5, 2);
        $dd1 = substr($date, 8, 2);
        $hour = substr($date, 11, 2);
        $min = substr($date, 14, 2);
        $sec = substr($date, 17, 2);
        $time = mktime($hour, $min, $sec, $mm1, $dd1, $yy1);
        $w = date("w", $time);
        $weeks = array("日","月","火","水","木","金","土");
        $week = $weeks[$w];
        return date("Y-m-d", $time)." ($week) ".date("H:i:s", $time);
    }
    
    function foldCount($buff){
        // 改行された行数を返す
        $array = explode("\n", $buff);
        return count($array);
    }
    
    /////////////////////////////
    // DB アクセス ///////////////
    
    // DB を開いて該当レコードを読み込む
    function openDB(){
        $link = mysqli_connect("localhost","root","root","NOA");
        $db_select = mysqli_select_db($link, "NOA");
        mysqli_query($link, "set names utf8");
    }
    
    function isFirstVisit($link, $patientId, $entryDate){
        // 今月初めての受診なら TRUE を返す
        $yearAndMonth = substr($entryDate, 0, 7);
        $query = "SELECT * FROM `ProgressSection` WHERE `patientId`='$patientId' AND `entryDate`<='$entryDate' AND (`freq` IS NULL OR `freq`<1) ORDER BY `entryDate` DESC";
        $result=mysqli_query($link, $query);
        $count = 0;
        $buff = ""; //######
        while ($row=mysqli_fetch_array($result)){
            $date = $row['entryDate'];
            $yymm = substr($date, 0, 7);
            if (strcmp($yymm, $yearAndMonth) != 0) break;
            // $entryDate と同じ年月ならカウントをインクリメント
            $count++;
        }
        return ($count == 1) ? TRUE : FALSE;
    }
    
    function getValue($link, $patientId, $entryDate, $tag, $isFirst){
        // $patientId, $entryDate, $tag に該当するレコードを DB から探し、$tag 対応値を返す
        $array = explode(".", $tag);
        $table = $array[0];
        $field = $array[1];
        $dateCondition = "`entryDate`<='$entryDate' AND (`freq` IS NULL OR `freq`<1)"; // 過去履歴も印刷
        
        // 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
        if (strcmp($table, "UniversalSection") == 0){
            $query = "SELECT * FROM `UniversalSection` WHERE `patientId`='$patientId' AND $dateCondition AND `field`='$field' ORDER BY `entryDate` DESC";
            $field = "dataString"; // field を UniversalSection 用に置換
        } else if (strcmp($table, "PatientTable") == 0){
            $query = "SELECT * FROM `PatientTable` WHERE `patientId`='$patientId'";
        } else {
            $query = "SELECT * FROM `$table` WHERE `patientId`='$patientId' AND $dateCondition ORDER BY `entryDate` DESC";
        }
        
        $result=mysqli_query($link, $query);
        while ($row=mysqli_fetch_array($result)){
            if (strlen($row[$field]) > 0){
                // 参照履歴用レコードはスキップ
                if (strcmp($row["drinking"], "ACCESS_LOG") == 0) return "";

                if ($isFirst){
                    // 今月初めての受診なら無条件に表示
                    return $row[$field];
                } else if (strcmp($table, 'NameSection') == 0){
                    // NameSection は無条件に表示
                    return $row[$field];
                } else if (strcmp($table, 'ProgressSection') == 0){
                    // ProgressSection は無条件に表示
                    return $row[$field];
                } else if (strcmp($entryDate, $row['entryDate']) == 0){
                    // 本日更新されたデータのみ表示
                    return $row[$field];
                }
            }
        }
        return "";
    }
    
    function getUserInfo($link, $loginName, $tag){
        $array = explode(".", $tag);
        $table = $array[0];
        $field = $array[1];
        
        // 該当する診療行為（薬剤、処置名、など）を DB から取り出して返す
        $query = "SELECT * FROM `$table` WHERE `loginName`='$loginName'";
        $result=mysqli_query($link, $query);
        if (mysqli_num_rows ($result) > 0){
            while ($row=mysqli_fetch_array($result)){
                if ($row[$field])
                    return $row[$field];
                //				return mb_convert_encoding($row[$field], "SJIS", "UTF-8");
            }
        }
        return "*** $tag ***";
    }
    
    function codeName($link, $code){
        $key = "/$code";
        $query = "SELECT `name` FROM `PriceList` WHERE `alias`='$key'";
        $result=mysqli_query($link, $query);
        if (mysqli_num_rows ($result) > 0){
            $row=mysqli_fetch_array($result);
            $codeAndName = $row['name'];
            if ($codeAndName){ // "11 初診" 形式から "初診" のみ取り出す
                $array = explode(" ", $codeAndName);
                return $array[1];
            }
        }
        return $code;
    }
    
    function shohouFormat($value){
        // code^alias^name^point^unitName^min^standard^max^width^effect^memo|...
        // のような形式を処方フィールド形式にして返す
        $records = explode('|', $value);
        $count = count($records);
        $results = array();
        for ($i=0; $i < $count; $i++){
            $ln = trim($records[$i]);
            if (strlen($ln) == 0) continue;
            
            $array = explode('^', $ln);
            if (count($array) > 6){
                $code = $array[0];
                $name = $array[2];
                if ($code < 120){
                    $unit = $array[6];
                    $unitName = $array[4];
                    $results[$i] = "$name ( $unit $unitName )";
                }
                else {
                    $freq = $array[5];
                    $unitName = $array[3];
                    $results[$i] = "---------- $name ( $freq $unitName )";
                }
            }
            else
                return $value; // 処方フォーマットではないので、そのまま表示
        }
        return join("\n", $results);
    }
    
    function treatmentFormat($link, $value){
        // 1_|_12_|_shosin_|_初診_|__|__|_273
        // isOenFee_|_code_|_alias_|_name_|_dose_|_unitName_|_point
        // のような形式を診療フィールド形式にして返す
        
        $records = explode("\n", $value);
        $count = count($records);
        for ($i=0; $i < $count; $i++){
            $ln = $records[$i];
            $array = explode("_|_", $ln);
            if (count($array) > 6){
                $isOwnFee = ($array[0]) ? " 自費" : "";
                $code = $array[1] * 1;
                $name = $array[3];
                $dose = $array[4];
                $unitName = trim($array[5]);
                $point = $array[6];
                $unit = ($unitName) ? "($dose $unitName)" : "";
                if ($code == 99){
                    // "_|_99_|__|_合計[健保(686 x 3 = 2050)自費(5400)] 7450_|__|__|_"
                    $records[$i] = $array[3];
                }
                else {
                    $cd = codeName($link, $code);
                    $records[$i] = "$cd [".$name." ".$unit."] ".$point." ".$isOwnFee;
                }
            }
            else
                return $value; // 診療フォーマットではないので、そのまま表示
        }
        return join("\n", $records);
    }
    
    function get($link, $patientId, $entryDate, $label, $tag, $option, $isFirst){
        $value = getValue($link, $patientId, $entryDate, $tag, $isFirst);
        
        if (strcmp($tag, "ProgressSection.treatment") == 0)
            $value = treatmentFormat($link, $value);
        else if (strcmp($tag, "ProgressSection.prescription") == 0)
            $value = shohouFormat($value);
        else if (strcmp($value, "0000-00-00") == 0)
            $value = "";
        
        if (strcmp($option, "wareki") == 0) $value = wareki($value);
        
        return (strlen($label)) ? $label."($value) " : $value;
    }
    
    // DB アクセス 　　　　　　　　//
    /////////////////////////////
    
    
    /////////////////////////
    //Print all pages ///////
    
    function modifiedString($st){
        // 文字列の事前処理
        $st = str_replace("<br/>", "\n", $st); // "<br>" を改行に変換
        return str_replace("<br>", "\n", $st); // "<br/>" を改行に変換
    }
    
    // Print all pages //////
    /////////////////////////
    
    
?>
