
var _attributes = ["fixed","unit","range","menu","type","value","dateFormat","charType"];

function field_id(slipName, label){
    // 入力欄の ID を生成して返す
    return slipName + "^" + label;
}

/////////////////////////////////////////////
///// NOA からの継承値 ////////////////////////

function cellLabel(){ // formTemplate.js から利用される
    return currentTag();
}

///// NOA からの継承値 /////////////////////////
/////////////////////////////////////////////

///////////////////////////////////////////////////////////
///// 各伝票の構造とデータを記憶するオブジェクト
///// 伝票ツールの最初に起動される getFormItems() で読み込まれる
///// _menuObj には 「NOA の記憶する全ての伝票の構造」 が読み込まれる
///// _currentForms には 「現在表示されている伝票の構造」が保持される

var _originalLabel;
function setOriginalLabel(label){
    _originalLabel = label;
}
function originalLabel(){
    // 伝票を開いた CELL の ラベル名
    return _originalLabel;
}

var _isNewForm; // 新規伝票なら true
function setIsNewForm(status){
    _isNewForm = status;
}
function isNewForm(){
    return _isNewForm;
}

var _menuObj; // 各伝票の構造とデータを記憶するオブジェクト
function initItemRecords(){
    _menuObj = new Object();
}
function menuObj(){
    // 各伝票の構造とデータを記憶したオブジェクトを返す
    return _menuObj;
}
function addItemRecord(name, rec){
    // name は伝票名：(ex.特定健診 など)
    // rec = {name:{owner,tag,value,public,freq,menu,template},,} 形式
    // value = "fixed|unit|range|menu|type|value|dateFormat|charType"; 形式
    // 他人が owner のものも記憶
    if (!rec.template){
        _menuObj[name] = rec;
    }
}

// _currentForms には 「現在表示されている伝票の構造」が保持される
var _currentForms;
function initCurrentForm(){
    _currentForms = new Object();
}
function currentForms(){
    // 伝票のオブジェクト群を入れたオブジェクト
    return _currentForms;
}
function currentForm(name){
    // 対象となっている伝票のオブジェクト
    return _currentForms[name];
}
function addCurrentForm(name, obj){
    // 表示された各伝票を記憶：その後変更されたデータは反映されていない
    if (!_currentForms) _currentForms = new Object();
    
    _currentForms[name] = obj;
}
function removeCurrentForm(name){
//function removeCurrentSlips(slipName){
    // 表示された各伝票リストから name の伝票を削除
    
    delete _currentForms[name];
}

var _menuObj; // 各伝票の構造とデータを記憶するオブジェクト
function initItemRecords(){
    _menuObj = new Object();
}
function menuObj(){
    // 各伝票の構造とデータを記憶したオブジェクトを返す
    return _menuObj;
}
function addItemRecord(formName, rec){
    // formName は伝票名：(ex.特定健診 など)
    // rec = {formName:{owner,tag,value,public,freq,menu,template},,} 形式
    // value = "fixed|unit|range|menu|type|value|dateFormat|charType"; 形式
    // 他人が owner のものも記憶
    if (!rec.template){
        _menuObj[formName] = rec;
    }
}
function menuObjFor(formName){
    // 伝票名 formName のオブジェクトを返す
    return _menuObj[formName];
}
function formForSlipName(formName){
    // 伝票名に対応する伝票構造オブジェクトを返す
    // "fixed|unit|range|menu|type|value|dateFormat|charType"; 形式を返す
    //_debug("== formForSlipName->"+formName); //##
    
    var rec = _menuObj[formName];
    
    if (rec && rec.value){
        // "label(|||),," 型式を "label(fixed()unit(),,),," 型式に変換して返す
        var recs = decodeObject(rec.value);
        return slitToObj(recs);
    }
    return null;
}
function valueForItem(formName){
    // 伝票名に対応するレコード文字列を返す：decodeObject() するとレコードオブジェクトになる
    var rec = _menuObj[formName];
    return (rec) ? rec.value : "";
}
function addNewLabelTo(formName, newLabel){
    // formName 伝票に新規ラベル newLabel を挿入
    var rec = _menuObj[formName];
    if (rec && rec.value && rec.value.length){
        var obj = decodeObject(rec.value);
        obj[newLabel] = "|||||||"; // 新規ラベルを挿入
    } else {
        if (! _menuObj[formName]) _menuObj[formName] = new Object();
        if (! _menuObj[formName].value) _menuObj[formName].value = new Object();
        var obj = new Object();
        obj[newLabel] = "|||||||"; // 新規ラベルを挿入
    }
    _menuObj[formName].value = encodeObject(obj); // _menuObj へ書き戻す
}

var _formStructures;
function setFormStructures(obj){
    // カルテから読み込んだ伝票類の構造を記憶
    _formStructures = obj;
}
function formStructures(){
    return _formStructures;
}

///// 各伝票の構造とデータを記憶するオブジェクト
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////
///// showFORM() showEditor() 共通に使われる関数 /////

function valueOfRecord(rec){
    // レコード "50|mg|10..20" の中の値 "50" だけを返す
    // レコード "50 MG|mg|10..20" の場合は "50" を返す
    if (rec && (rec.length > 0)){
        var array = rec.split("|");
        
        var value = array[0];
        var ary = value.split(" ");
        if (ary.length > 1)
            var value = ary[0];
        return value;
    } else {
        return "";
    }
}
function unitOfRecord(rec){
    // レコード "50|mg|10..20" の中の値 "mg" だけを返す
    // レコード "50 MG|mg|10..20" の場合は "MG" を返す
    if (rec && (rec.length > 0)){
        var array = rec.split("|");
        
        var value = array[0];
        var ary = value.split(" ");
        if (ary.length > 1)
            var unit = ary[1];
        else
            var unit = (array.length > 1) ? array[1] : "";
        return unit;
    } else {
        return "";
    }
}
function rangeOfRecord(rec){
    // レコード "50|mg|10..20" の中の値 "10..20" だけを返す
    /*
     if (rec && (rec.length > 0)){
     var array = rec.split("|");
     var range = (array.length > 2) ? array[2] : "";
     return range;
     } else {
     return "";
     }
     */
    return ""; // 旧バージョンとの互換のため
}
function menuOfRecord(rec){
    // レコード "50|mg|10..20|1,2,3" の中の値 "1,2,3" だけを返す
    if (rec && (rec.length > 0)){
        var array = rec.split("|");
        var menu = (array.length > 3) ? array[3] : null;
        return menu; // ### menu ない場合は "" ではなく null を返す
    } else {
        return null;
    }
}
function typeOfRecord(rec){
    // レコード "50|mg|10..20||dateType" の中の値 "dateType" だけを返す
    if (rec && (rec.length > 0)){
        var array = rec.split("|");
        var type = (array.length > 4) ? array[4] : null;
        return type; // ### menu ない場合は "" ではなく null を返す
    } else {
        return "";
    }
}

function addTemplate(){
    // 選択ポップアップ名：item を元にテンプレート取得し伝票ツール画面に追加
    var slipName = elmFor("itemPopUp").value;
    var obj = formForSlipName(slipName);
    console.log("", slipName, obj); //##
    if (obj){
        setIsNewForm(true); // 新規伝票であることを記憶
        addCurrentForm(slipName, obj); // 伝票を画面に追加
        showOrderForm(slipName, obj); // 追加された伝票を表示
        
        // 新規伝票が追加された場合はテンプレート・メニューを開く
        // この後、サーバで slipName の頻度が更新される
        getTemplateMenu(slipName);
    }
}

///// showFORM() showEditor() 共通に使われる関数 /////
///////////////////////////////////////////////////

////////////////////////////////
/// neuron.js による処理 /////////

function showFormFor(value){
    // カルテから送られた内容を表示
    // ### value には HTML コントロール文字が入っているが、このままでよい ###
    // HTML コントロール文字を削除すると [a<=b] のような文字列が壊れてしまう
    //console.log("----- value("+value+")"); //##
    elmFor("sl_editorArea").innerHTML = ""; // 画面をクリアー
    initCurrentForm();
    
    if (trim(value).length > 0){
        // 伝票の元となる CELL 記述内容があった
        var obj = decodeObject(value);
        setFormStructures(obj);
  
        // CELL に記述された伝票文字列を解析
        for (formName in obj){
            var rec = obj[formName]; // CELL 記述の伝票オブジェクト
            var cellObj = slitToObj(rec);
            
            // formName のテンプレート・オブジェクトを取り出す
            var tempObj = formForSlipName(formName);
            
            // _menuObj に CELL からの rec を merge する
            for (label in cellObj){
                // フィールド・ラベル毎に CELL 内容をテンプレート構造へマージ
                var labelObj = cellObj[label]; // ラベル毎のフィールド・オブジェクト
                var tLabelObj = (tempObj) ? tempObj[label] : null; // テンプレートのフィールド
                if (tLabelObj){
                    // テンプレート属性へ CELL 属性をマージ
                    for (name in tLabelObj){
                        var attribute = tLabelObj[name]; // テンプレートの属性データ
                        var cellAtr = labelObj[name]; // CELL 記述から抽出した属性データ
                        if (cellAtr){
                            // unit が指定されているなら value データから単位名を削除
                            if (name == 'value'){
                                var unit = tLabelObj['unit'];
                                var pos = cellAtr.indexOf(unit);
                                // 単位名の前の空白を含めて削除
                                if (pos > 0) cellAtr = cellAtr.substr(0, pos - 1);
                            }
                           // cellAtr を _menuObj へ上書きする
                            changeValue(formName, label, name, cellAtr);
                        }
                    }
                } else { // label はテンプレートに存在しない属性だった
                    // _menuObj へ label を追加し tempObj を再読込
                    addNewLabelTo(formName, label);
                    
                    for (num in _attributes){ // fixed など全ての属性をスキャン
                        var name = _attributes[num]; // テンプレートの属性名
                        var cellAtr = labelObj[name]; // CELL 記述から抽出した属性データ
                        if (cellAtr){
                            // cellAtr を _menuObj へ上書きする
                            changeValue(formName, label, name, cellAtr);
                        }
                    }
                }
            }
            // changeValue() で　_menuObj が更新されたので tempObj を再度読み出す
            var tempObj = formForSlipName(formName);
            
            // 伝票リスト（現在表示するもののみ）に追加しておく
            addCurrentForm(formName, tempObj); // <==### tempObj フォーマットが違う？
            
            // 追加された伝票を表示
            showOrderForm(formName, tempObj);
        }
        // 「全ての伝票を折畳む」チェックボックスに応じた動作を実行
        var cb = elmFor("foldAllCheck");
        checkFoldSlips(cb);
    }
    // 最上部に開いた伝票が見えないことがあるので最上部へスクロールしておく
    // window.scroll(0, 0);
}

function selectForm(elm){
    // 受診日ポップアップから選択された伝票を表示
    var dateTime = elm.value;
    var tag = parent().currentTag();
    var obj = parent().valueForTag(tag, dateTime);
    
    // CELL 内容 obj.value を伝票形式で表示
    showFormFor(obj.value);
    
    // カルテと同じ年月日の伝票ならポップアップを消し年月日を表示
    if (dateTime == parent().currentDate()) showExamDate();
}

function addNewOrderSlip(slipName){
    // 伝票名：slipName の伝票オブジェクトを追加
    // 伝票リストに追加しておく
    addCurrentForm(slipName, menuObjFor(slipName));
}

function showExamDate(elm){
    // 検査日を表示
    // 検査の行われた受診日の配列を生成
    var currentDate = parent().currentDate();
    var tag = parent().currentTag();
    if (tag){
        var array = [];
        var history = parent().history();
        for (num in history){
            var dateTime = history[num];
            
            if (dateTime == currentDate){
                array.push(dateTime);
            } else {
                var obj = parent().valueForTag(tag, dateTime);
                var buff = (obj.value) ? trim(obj.value) : "";
                if (buff.length && ((buff.indexOf("(") > 0) && (buff.indexOf(")") > 0)))
                    array.push(dateTime);
            }
        }
    }
    
    if (array){
        elm.innerHTML = "";
        // CELL が編集モードでなければ currentTag() が取得できない
        var pp = newPopupMenu(elm, "historyPop", array, "");
        pp.setAttribute("onchange", "selectForm(this)");
        pp.style.marginBottom = "3px";
    }
}

function popUpClicked(elm){
    // 伝票名ポップアップ・メニューがクリックされた
    var item = elm.value;
    //console.log("popUpClicked tag(", currentTag(), ") item(", item, ")"); //##
    
    // 選択されたメニュー・アイテムが　"...その他" なら新規登録
    if (item == "...その他"){
        var slipName = prompt("新規伝票名");
        if (slipName.length > 0){
            addNewOrderSlip(slipName); // _menuObj[slipName] を生成
            openSlipEditor(slipName);
            return;
        }
    }
    var cell = cellForTag(currentTag());
    if (cell.study * 1 > 0){ // 頻度学習が on なら頻度学習を行う
        // freq = "" なら、使用されたメニュー項目の頻度を increment
        // ### doNothing の代わりに null や "" を指定すると正常終了しない
        put_group_menu(owner(), item, "", [], doNothing);
    }
}

/*function closeFormPanel(){
    // フォーム編集・パネルを閉じる
    var elm = elmFor("cellEditorArea");
    elm.style.display = "none";
}*/
function showItemPopUp(answer){
    // 検査フォーム名のリストをサーバから読込み
    var array = JSON.parse(answer);

    // テンプレート選択用ポップアップを更新
    initItemRecords();
    var menuItems = new Array();
    for (num in array){
        // rec = "owner(ohashi)tag(検査)value(class^[^||I|I,II,IIIa,IIIb,IV,V^]^内膜^[^|||-,+,判定不能^]^採取器具^[^綿棒|||スクレーパ,綿棒,頚管ブラシ^]^メモ^[^|||炎症性変化,sq.metaplastic cell,軽度核腫大細胞,follow up,atrophic change,扁平上皮化生,酵母様真菌,mild dysplasia,moderate dysplasia,内膜細胞みとめず判定不能,トリコモナス,出血あり内膜も採取,細菌^]^)public(0)freq(711)menu(smear)template()" 形式
        var rec = array[num];
        
        // template 値を持つものはテンプレート・メニュー用なのでスキップ
        if (rec.template && rec.template.length) continue;
        
        // value（伝票構造）を持たないものはスキップ：過去のバグ・データ除去のため
        if (!rec.value || (rec.value.length == 0)) continue;
        
        addItemRecord(rec.menu, rec);
        
        if (rec.template) continue; // テンプレート用はメニュー・アイテムに入れない
        
        menuItems.push(rec.menu);
    }
    menuItems.push("...その他");
    
    // 伝票名ポップアップ
    var elm = document.getElementById("popUpArea");
    elm.innerHTML = "";
    var pu = newPopupMenu(elm, "itemPopUp", menuItems, "");
    pu.setAttribute("onchange", "popUpClicked(this)");
    pu.style.position = "relative";
    pu.style.top = "2px";
    
    // 追加ボタン
    var bt = newDIV(elm, "/whiteButton");
    bt.innerHTML = "追加";
    bt.setAttribute("onclick", "addTemplate()");
    bt.style.marginLeft = "3px";
    bt.style.position = "relative";
    bt.style.top = "1px";

    // =====================================================
    // === カルテから送られた内容を表示 =========================
    // =====================================================
    var obj = parent().valueForTag(currentTag(), currentDate());
    var value = (obj && obj.value) ? obj.value : "";

   // ### value には HTML コントロール文字が入っているが、このままでよい ###
    // HTML コントロール文字を削除すると [a<=b] のような文字列が壊れてしまう
    showFormFor(value);
}
function getFormItems(){
    // サーバから 検査伝票フォーム のリストを取り寄せ _menuObj として保存
    /* --- MenuTable の内容 ---
     tag: 検査 --- 検査欄であることを示す（ここを tag にすると検査欄メニューになる）
     menu: 尿一般 --- 伝票名
     template: null --- テンプレート・メニュー用では「初期値」など
     value: 伝票構造が入っている
     */
    get_menu(owner(), currentTag(), showItemPopUp);
}

function updateSlipMenuFreq(slipName){
    // サーバのメニュー項目を更新
    //    // 伝票では第２引数が cell.tag テンプレートでは第２引数が cell.label
    // var value = valueForItem(slipName);
    // ### value があると予期せぬ値がテンプレートに書き込まれるバグを発生することあり
//    console.log("updateSlipMenuFreq", owner(), cellLabel(), slipName); //##
    put_menu(owner(), cellLabel(), slipName, "", "", null, true);
}

/// neuron.js による処理 /////////
////////////////////////////////

function slitToObj(slipObj){
    // "label(|||),," 型式を "label(fixed()unit(),,),," 型式に変換
    //_debug("== slitToObj->"+encodeObject(slipObj)); //##
    
    var resultObj = new Object();
    for (label in slipObj){
        var val = slipObj[label];
        var array = val.split('|');
        
        var obj = new Object();
        obj.fixed = "";
        obj.unit = "";
        obj.range = ""; // 旧バージョンとの互換性のため dummy を入れておく
        obj.menu = "";
        obj.type = "";
        obj.value = "";
        obj.dateFormat = "";
        obj.charType = "";
        
        if (array.length == 1){
            // 文字列に '|' が含まれない場合は value と判断
            obj.value = val;
        } else {
            if (array.length > 0) obj.fixed = array[0]; // 必要
            if (array.length > 1) obj.unit = array[1];
            // 4: range はスキップ
            if (array.length > 3) obj.menu = array[3];
            if (array.length > 4) obj.type = array[4];
            if (array.length > 5) obj.value = array[5];
            if (array.length > 6) obj.dateFormat = array[6];
            if (array.length > 7) obj.charType = array[7];
        }
        
        resultObj[label] = obj;
    }
    return resultObj;
}

function isAnotherData(){
    // 表示されている伝票が表示されているカルテのでなければ true を返す
    var pop = elmFor("historyPop"); // 伝票の日付
    if (!pop) return false;
    
    // 伝票の日付がカルテの日付と異なるなら true を返す
    return (pop.value == currentDate()) ? false : true;
}

function changeValue(formName, label, attribute, value){
    // 属性の設定値が変更された
    //console.log("== changeValue name:", formName, "label:", label, "attribute:", attribute); //##
    //console.log("-- _menuObj:", _menuObj, "for name:", encodeObject(_menuObj[formName])); //##
    
    // _menuObj[formName]['value'] に入っている文字列をオブジェクトに解凍
    var st = _menuObj[formName]['value'];
    if (st && st.length){
        var rec = decodeObject(st);
        var val = rec[label];
        var array = val.split('|');
    } else {
        var rec = new Object();
        rec[label] = new Object();
        var array = ["","","","","","","",""];
    }
    
    // オブジェクト中の該当属性の値をセット
    if (attribute == 'fixed')
        array[0] = value;
    else if (attribute == 'unit')
        array[1] = value;
    //else if (attribute == 'range')
    //    array[2] = value;
    else if (attribute == 'menu')
        array[3] = value;
    else if (attribute == 'type')
        array[4] = value;
    else if (attribute == 'value')
        array[5] = value;
    else if (attribute == 'dateFormat')
        array[6] = value;
    else if (attribute == 'charType')
        array[7] = value;
    
    // 属性列を | で区切った文字列にエンコードしオブジェクトに格納
    rec[label] = array.join('|');
    
    // 属性値を更新したオブジェクトをエンコードし再び _menuObj[formName]['value'] に収納
    _menuObj[formName]['value'] = encodeObject(rec);
}
function changeLabel(elm, slipName, label){
    // ラベル（フィールド名）が変更された
    //var newLabel = inner_text(elmFor(label+".label"));
    var newLabel = document.getElementById(label+".label").innerText;
    //_initDebug(true); //##
    _debug("=== changeLabel->"+label+"->"+newLabel); //##
    
    var st = _menuObj[slipName]['value'];
    if (st && st.length){
        var rec = decodeObject(st);
        var val = rec[label];
        
        // 新規フィールドを挿入
        rec[newLabel] = val;
        
        // 変更されたフィールドを削除
        delete rec[label];
        
        // 属性値を更新したオブジェクトをエンコードし再び _menuObj[slipName]['value'] に収納
        _menuObj[slipName]['value'] = encodeObject(rec);
        
        _debug("=== changeLabel->"+encodeObject(_menuObj[slipName])); //##
    }
}
function changeFixed(elm, slipName, label){
    // 規定値が変更された
    changeValue(slipName, label, 'fixed', elm.value);
}
function changeUnit(elm, slipName, label){
    // 単位が変更された
    changeValue(slipName, label, 'unit', elm.value);
}
function changeCharType(elm, slipName, label){
    // 数値形式チェックボックスが変更された
    var status = (elm.checked) ? "1" : "";
    changeValue(slipName, label, 'charType', status);
}
function changeMenu(elm, slipName, label){
    // メニューが変更された
    var ary = elm.value.split('\n');
    var value = ary.join(',');
    
    changeValue(slipName, label, 'menu', value);
}
function changeType(slipName, label, val){
    // タイプが変更された
    changeValue(slipName, label, 'type', val);
}
function changeDateType(elm, slipName, label){
    // 日付の型式が変更された ### 日付の表示形式は dateFormat として記憶 ###
    // _menuObj[slipName]['value'] に入っている文字列をオブジェクトに解凍
    var st = _menuObj[slipName]['value'];
    if (st && st.length){
        var rec = decodeObject(st);
        var val = rec[label];
        var array = val.split('|');
    } else {
        var rec = new Object();
        rec[label] = new Object();
        var array = ["","","","","","",""];
    }
    
    // オブジェクト中の日付属性の値をセット
    array[6] = elm.value; // dateFormat
    
    // 属性列を | で区切った文字列にエンコードしオブジェクトに格納
    rec[label] = array.join('|');
    
    // 属性値を更新したオブジェクトをエンコードし再び _menuObj[slipName]['value'] に収納
    _menuObj[slipName]['value'] = encodeObject(rec);
}

function BMI_with(slipName, height, weight){
    // ### BMI 計算のための特殊埋め込み関数 ###
    // height, weight ラベルの値から BMI を計算して返す
    // cell.value はリアルタイムな値ではないので、リアルな値を取る
    var fid = field_id(slipName, height);
    var elm = document.getElementById(fid);
    if (!elm) return "";
    
    var ht = trim(elm.value) / 100;
    
    var fid = field_id(slipName, weight);
    var elm = document.getElementById(fid);
    if (!elm) return "";
    
    var wt = trim(elm.value) * 1;
    if (ht * wt == 0) return "";
    
    var bmi = wt / (ht * ht);
    bmi = Math.round(bmi * 10);
    bmi = Math.floor(bmi) / 10;
    return bmi;
}
function EFW_with(slipName, bpdF, aptdF, ttdF, flF){
    // ### EFW:胎児推定体重 計算のための特殊埋め込み関数 ###
    var bpd = 0;
    var aptd = 0;
    var ttd = 0;
    var fl = 0;
    
    var fid = field_id(slipName, bpdF);
    var elm = document.getElementById(fid);
    if (elm) bpd = trim(elm.value); // フィールド値
    var fid = field_id(slipName, aptdF);
    var elm = document.getElementById(fid);
    if (elm) aptd = trim(elm.value); // フィールド値
    var fid = field_id(slipName, ttdF);
    var elm = document.getElementById(fid);
    if (elm) ttd = trim(elm.value); // フィールド値
    var fid = field_id(slipName, flF);
    var elm = document.getElementById(fid);
    if (elm) fl = trim(elm.value); // フィールド値
    
    var efw = Math.floor((1.07 * bpd*bpd*bpd + 3.42 * aptd * ttd * fl)/1000);
    if (bpd * aptd * ttd * fl == 0) efw = 0;
    
    if (efw > 0){
        return efw;
    } else {
        return "";
    }
}
function TSAT_with(slipName, ironF, tibcF){
    // ### TSAT 計算のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
    // iron, tibc ラベルの値から TSAT を計算して返す
    // cell.value はリアルタイムな値ではないので、リアルな値を取る
    var fid = field_id(slipName, ironF);
    var elm = document.getElementById(fid);
    if (elm) iron = trim(elm.value); // フィールド値
    
    var fid = field_id(slipName, tibcF);
    var elm = document.getElementById(fid);
    if (elm) tibc = trim(elm.value); // フィールド値
    if (iron * tibc == 0) return "";
    
    var tsat = iron / tibc *100;
    tsat = Math.round(tsat * 10);
    tsat = Math.floor(tsat) / 10;
    return tsat;
}
function MCV_with(slipName, hematoF, rbcF){
    // ### MCV 計算のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
    // hemato, rbc ラベルの値から MCV を計算して返す
    // BMIの関数を参考にして作成
    var fid = field_id(slipName, hematoF);
    var elm = document.getElementById(fid);
    if (!elm) return ""
        
        var hemato = trim(elm.value)
        
        var fid = field_id(slipName, rbcF);
    var elm = document.getElementById(fid);
    if (!elm) return ""
        
        var rbc = trim(elm.value)
        if (hemato * rbc == 0) return "";
    
    var mcv = hemato / rbc *1000;
    mcv = Math.round(mcv * 10);
    mcv = Math.floor(mcv) / 10;
    return mcv;
}
function MCH_with(slipName, hgbF, rbcF){
    // ### MCH 計算のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
    // hgb, rbc ラベルの値から MCH を計算して返す
    // BMIの関数を参考にして作成
    var fid = field_id(slipName, hgbF);
    var elm = document.getElementById(fid);
    if (!elm) return ""
        
        var hgb = trim(elm.value)
        
        var fid = field_id(slipName, rbcF);
    var elm = document.getElementById(fid);
    if (!elm) return ""
        
        var rbc = trim(elm.value)
        if (hgb * rbc == 0) return "";
    
    var mch = hgb / rbc *1000;
    mch = Math.round(mch * 10);
    mch = Math.floor(mch) / 10;
    return mch;
}
function MCHC_with(slipName, hematoF, hgbF){
    // ### MCHC 計算のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
    // hemato, hgb ラベルの値から MCHC を計算して返す
    // BMIの関数を参考にして作成
    var fid = field_id(slipName, hematoF);
    var elm = document.getElementById(fid);
    if (!elm) return ""
        
        var hemato = trim(elm.value)
        var fid = field_id(slipName, hgbF);
    var elm = document.getElementById(fid);
    if (!elm) return ""
        
        var hgb = trim(elm.value)
        if (hemato * hgb == 0) return "";
    
    var mchc = hgb / hemato *100;
    mchc = Math.round(mchc * 10);
    mchc = Math.floor(mchc) / 10;
    return mchc;
}
function checkValue(fid){
    // 入力された値のチェックを行う
    var textField = document.getElementById(fid); // dynamically
    
    var ary = fid.split("^"); // fid は "slipName^label" 型式
    var slipName = ary[0]; // 伝票名
    var label = ary[1]; // フィールド・ラベル
    
    if (label == "BMI"){
        // ### BMI 計算のための特殊埋め込み関数 ###
        var val = BMI_with(slipName, "身長", "体重");
        setBuiltinFrame(textField, val);
    } else if (label == "EFW"){
        // ### EFW:胎児推定体重 計算のための特殊埋め込み関数 ###
        var val = EFW_with(slipName, "BPD", "APTD", "TTD", "FL");
        setBuiltinFrame(textField, val);
    } else if (label == "TSAT"){
        // ### TSAT:トランスフェリン飽和度 計算のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
        var val = TSAT_with(slipName, "血清鉄", "TIBC");
        setBuiltinFrame(textField, val);
    } else if (label == "MCV"){
        // ### MCV:平均赤血球容積のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
        var val = MCV_with(slipName, "ヘマトクリット", "赤血球数");
        setBuiltinFrame(textField, val);
    } else if (label == "MCH"){
        // ### MCH:平均赤血球容積のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
        var val = MCH_with(slipName, "ヘモグロビン", "赤血球数");
        setBuiltinFrame(textField, val);
    } else if (label == "MCHC"){
        // ### MCHC:平均赤血球血色素濃度のための特殊埋め込み関数 ### by Dr.K.YAMASAKI
        var val = MCHC_with(slipName, "ヘマトクリット", "ヘモグロビン");
        setBuiltinFrame(textField, val);
    }
    var value = textField.value; // dynamically
    if (!value || value.length == 0) return;
    
    // 基準値に一致しているかどうか判定
    if (textField.value){
        if (hasStandard(textField) == false){ // textField が HL7 形式でない場合
            checkStandard(textField, label, value); // 基準値からはずれていれば警告色
        }
    }
    
    
    function setBuiltinFrame(elm, value){
        // 埋め込み関数の設定された入力フィールドに value を表示し、枠の色を薄くする
        elm.value = value;
        elm.style.border = "1px solid #eee";
    }
    
    function hasStandard(textField){
        // textField の値が textField 埋込基準値にはずれていれば警告色
        // HL7 型式のデータの場合にこの型式がとられる
        
        // textField 文字列の [ と ] で挟まれた部分を抽出
        var results = extractSTRING(textField.value, '[', ']');
        if (!results){
            // textField 値に基準値が埋め込まれていなかった：HL７ 形式ではなかった
            return false;
        }
        
        var val = results[0]; // [ より左の文字列：検査値
        var ary = val.split(' ');
        val = ary[0]; // '20 mg' 文字列を '20' にする
        
        var standard = results[1]; // [ と ] で挟まれた文字列：基準値
        var right = results[2]; // ] より右の文字列：通常は文字列なし
        
        if ((standard.length > 1) && (standard.indexOf('-') >= 0)){ // [min-max] 型式
            var ary = standard.split("-");
            var min = ary[0] * 1; // 最小基準値
            var max = ary[1] * 1; // 最大基準値
            val = val * 1; // "val" 文字列：検査値
            //console.log("min-max", val, min, max); //##
            
            if (val < min)
                textField.style.backgroundColor = "#eef";
            else if (val > max)
                textField.style.backgroundColor = "#fee";
        } else if (standard.indexOf('<') >= 0) {
            // 血清： [<=30] [<1.0] [陰性<8] 形式
            //console.log(" hasStandard <", val, ln); //##
            var ary = standard.split("<=");
            if (ary.length > 1){
                var max = ary[1] * 1; // 最大基準値
                if (val * 1 > max)
                    textField.style.backgroundColor = "#fee";
            } else {
                var ary = standard.split("<");
                if (ary.length > 1){
                    var max = ary[1] * 1; // 最大基準値
                    if (val * 1 >= max)
                        textField.style.backgroundColor = "#fee";
                }
            }
        } else if (standard.indexOf('>') >= 0) {
            // 血清： [<=30] [<1.0] [陰性<8] 形式
            var ary = standard.split(">=");
            if (ary.length > 1){
                var min = ary[1] * 1; // 最大基準値
                if (val * 1 < min)
                    textField.style.backgroundColor = "#eef";
            } else {
                var ary = standard.split(">");
                if (ary.length > 1){
                    var min = ary[1] * 1; // 最大基準値
                    if (val * 1 <= min)
                        textField.style.backgroundColor = "#eef";
                }
            }
        } else {
            // 部分尿： [+-] [-] 形式
            // 血清： [陰性] 形式
            // 部分尿の場合 "（-）" 形式の場合があるので両カッコを削除
            var array = extractSTRING(val, '（', '）');
            if (array) val = array[1];
            //console.log(" [stardard]", val, standard); //##
            
            if (val != standard) textField.style.backgroundColor = "#fee";
        }
    }
    
    return false;
}

function changedMenu(elm, fid){
    // 伝票フィールドのメニューが選択された
    var menuItem = elm.value;
    var fd = elmFor(fid);
    if (fd){
        fd.value = menuItem;
        checkValue(fid);
    } else {
        alert(fid + " に相当する入力欄がありません");
    }
}

function moveOrderSlip(label1, label2){
    // label1 を label2 の位置へ移動：その他のレコードは順送りになる
    //_initDebug(true); //##
    _debug("== moveOrderSlip "+label1+"->"+label2); //##
    
    var obj = menuObjFor(_slipName); // 既存の伝票オブジェクト
    //_debug("obj-> "+encodeObject(obj)); //##
    
    var st = obj.value; // "日付(||||)身長(||||)体重(||||)" 形式
    var recs = decodeObject(st); // 既存の伝票オブジェクト
    
    // label1 のフィールドを移動
    var targetRec = recs[label1]; // 移動させるフィールド
    _debug("----- targetRec->"+targetRec); //##
    var newRecs = new Object(); // 並べ替えた伝票オブジェクト
    for (name in recs){
        var rec = recs[name];
        //_debug(name+"->"+rec); //##
        
        if (name == label1){
            continue;
        } else if (name == label2){
            //_debug("-- put 1->"+label1+"->"+targetRec); //##
            newRecs[label1] = targetRec;
            //_debug("-- put 2->"+name+"->"+rec); //##
            newRecs[name] = rec;
        } else {
            //_debug("-- put->"+name+"->"+rec); //##
            newRecs[name] = rec;
        }
    }
    _debug("moved->"+encodeObject(newRecs)); //##
    
    // 並べ替えの済んだ伝票オブジェクトを記憶
    obj.value = encodeObject(newRecs);
    
    _debug("obj.value->"+obj.value); //##
    _debug("=========="); //##
    
    // 伝票エディターを再表示
    openSlipEditor(_slipName);
}

function removeOrderSlip(slipName){
    // slipName の伝票を画面から削除
    //if (confirm(slipName + " を削除していいですか") == false) return;
    
    // 伝票リストから削除しておく
    removeCurrentForm(slipName);
    
    // テンプレート・メニューを閉じる
    closeFloatPanel();
    
    // 伝票を再表示
    document.getElementById("sl_editorArea").innerHTML = "";
    var slips = currentForms(); // 表示されている伝票を入れたオブジェクト
    for (slipName in slips){
        var slip = slips[slipName]; // 最初に表示時点での伝票構造とデータのオブジェクト
        showOrderForm(slipName, slip);
    }
}

function checkFoldSlips(elm){
    // 全ての伝票を折畳/拡大
    setFoldAllSlips(elm); // チェックボックスの状態を localStorage に記憶
    var isFold = elm.checked;
    var obj = formStructures(); // 表示された全ての伝票の構造フォーマット
    for (slipName in obj){
        var icons = elmFor(slipName+"iconArea");
        var div = elmFor(slipName+"contentsArea");
        if (isFold){
            icons.style.display = "none";
            div.style.display = "none";
        } else {
            icons.style.display = "block";
            div.style.display = "block";
        }
    }
}

function foldSlip(slipName){
    // slipName の伝票を折畳/拡大
    var icons = elmFor(slipName+"iconArea");
    var div = elmFor(slipName+"contentsArea");
    if ((div.style.display != "none")){
        icons.style.display = "none";
        div.style.display = "none";
    } else {
        icons.style.display = "block";
        div.style.display = "block";
    }
    closeInfoTip();
}

function _hours(){
    var array = [""];
    for (i=0; i < 24; i++) array.push(i);
    return array;
}
function _minitues(){
    var array = [""];
    for (i=0; i < 60; i++) array.push(i);
    return array;
}

function form_setNow(cid, type){
    // 年月日ポップアップに現在の日時をセット
    var ary = arrayWithDateTime(todayAndTime());
    
    var elm = elmFor(cid+".dateArea");
    elm.innerHTML = "";
    if (type == "年月日"){
        newDatePopUp(elm, cid, "平成", ary[0], ary[1], ary[2], false, null);
    } else if (type == "年月"){
        newDatePopUp(elm, cid, "平成", ary[0], ary[1], ary[2], true, null);
    } else {
        newDatePopUp(elm, cid, "平成", ary[0], ary[1], ary[2], false, null);
        // 時
        var pp = newPopupMenu(elm, cid+".hour", _hours(), ary[3]);
        pp.style.marginLeft = "2px";
        var sp = newSPAN(elm, "");
        sp.innerHTML = "時";
        // 分
        var pp = newPopupMenu(elm, cid+".min", _minitues(), ary[4]);
        var sp = newSPAN(elm, "");
        sp.innerHTML = "分";
    }
    // infoTip が残ることがあるので明示的に閉じる
    closeInfoTip();
}
function showDatePopup(elm, fid, type, dateArray){
    if (type == "") type = "年月日"; // 省略されていることがある旧データへの対応
    //console.log("showDatePopup fid(", fid, ") type(", type, ")"); //##
    // 表示形式に従って日付ポップアップを表示
    var sp = newSPAN(elm, "");
    sp.innerHTML = "";
    sp.style.paddingRight = "5px";
    sp.style.position = "relative";
    sp.style.top = "2px";
    var img = newIMAGE(sp, fid + "timerIcon/expandIcon", "./timer-set.png", "time");
    img.style.height = "14px";
    img.setAttribute("onclick", "form_setNow('" + fid +"','" + type + "')");
    setInfoTip(fid + "timerIcon", "現時刻をセット"); // INFO
    var dv = newSPAN(elm, fid+".dateArea");
    dv.style.fontSize = "9pt";
    var yy = dateArray[0];
    var mm = dateArray[1];
    var dd = dateArray[2];
    // type は rec.menu として記憶されている
    if (type == "年月"){
        var dp = newDatePopUp(dv, fid, "平成", yy, mm, dd, true, null);
    } else if (type == "年月日時分"){
        // ## 時分を表示できるポップアップ・メニューを設定
        var h = dateArray[3];
        var m = dateArray[4];
        var s = dateArray[5];
        var dp = newDatePopUp(dv, fid, "平成", yy, mm, dd, false, null);
        // 時
        var pp = newPopupMenu(dv, fid+".hour", _hours(), h);
        pp.style.marginLeft = "2px";
        var sp = newSPAN(dv, "");
        sp.innerHTML = "時";
        // 分
        var pp = newPopupMenu(dv, fid+".min", _minitues(), m);
        var sp = newSPAN(dv, "");
        sp.innerHTML = "分";
    } else { // 年月日タイプ or dateType
        var dp = newDatePopUp(dv, fid, "平成", yy, mm, dd, false, null);
    }
}

function showPictureInTool(){
    // 画像読込伝票を ToolArea 上端に開く
    openTool("../Picture");
}

function savedOrder(answer){
    // 過去データを上書きした場合は画面を再表示
    window.top.location.reload();
}
function saveOrder(){
    // 確定ボタンが押された：伝票のデータを NOA 本体へ転送
    var withUnit = valueWithUnit(); // データに単位を添えて書き戻すかのステータス
    var slipArray = new Array(); // 伝票群の構造・データを記憶する配列
    var slips = currentForms(); // 表示されている伝票を入れたオブジェクト
    closeFloatPanel(); // テンプレート・パネルを閉じる

    for (slipName in slips){
        var slip = slips[slipName]; // 最初に表示時点での伝票構造とデータのオブジェクト
        
        var slipObj = new Object(); // 伝票の各フィールドを記憶するオブジェクト
        for (label in slip){
            var labelObj = slip[label];
            // 通常の値は fid から取得できる
            var fid = field_id(slipName, label);
            var val = document.getElementById(fid).value;
            
            // 空データの項目は省略
            if ((val.length == 0) && (ignoreBlankForm())) continue;
            
            // 単位表示チェックが入っていれば単位を添えて書き戻す
            if (withUnit && (labelObj.unit.length)){
                if ((labelObj.type != "dateType") && (labelObj.type != "yearMonthType"))
                    val += " " + labelObj.unit;
            }
            
            slipObj[label] = val;
 
            // 時分のある場合は時分を取得
            var helm = document.getElementById(fid+".hour");
            if (helm){
                var dateTime = val; // "2013-09-19" のような型式：時刻はない場合あり
                var times = arrayWithDateTime(dateTime); // 日時の配列：時分秒も
                
                // 配列の時の部分を置換
                times[3] = (helm.value.length > 0) ? helm.value : "00";
                
                var melm = document.getElementById(fid+".min");
                if (melm)
                    times[4] = (melm.value.length > 0) ? melm.value : "00"; // 配列の分の部分を置換
                
                var st = dateTimeWithArray(times);
                if (times[0] * times[1] * times[2] == 0)
                    slipObj[label] = " ";
                else
                    slipObj[label] = st;
            }
        }
        var recObj = new Object(); // 一伝票の構造・データを含むオブジェクト
        recObj[slipName] = slipObj;
        var rec = encodeObject(recObj); // １伝票の構造・データを含む文字列
        
        slipArray.push(rec); // １伝票の文字列を配列に入れる
    }
    
    if (parent().currentLabel() != originalLabel()){
        alert("「 " + originalLabel() + " 」欄を開き「確定」しなおしてください");
        return;
    }
    
    if (isAnotherData()){
        var value = slipArray.join(""); // 伝票文字列の区切りには既に改行が入っているはず
        // 本日以外のページから開かれた場合 DB へ直書き
        var dateTime = elmFor("historyPop").value; // 伝票の日付
        var hid = parent().hospitalId();
        var limit = parent().timeLimit();
        var container = new Object();
        var tag = parent().currentTag();
        container[tag] = value;
        
        put_page(owner(),hid,patientId(),dateTime,limit,container,savedOrder);
    } else {
        var value = slipArray.join("<br>"); // 伝票文字列の区切りに改行を入れる
        gotValueFromTool(value, true);
    }
}

function showOrderForm(formName, records){
    // 伝票を開く
    addCurrentForm(formName, records); // 表示された各伝票を記憶
    
    var elm = document.getElementById("sl_editorArea");
    var div = newDIV(elm, "");
    var pframe = new PictureFrame(div, "60%", "70%");

    // HEADER ============================================
    pframe.header.setAttribute("class", "slip-header");
    if (isAnotherData()) pframe.header.setAttribute("class", "gray-header");
    pframe.header.style.marginTop = "2px"; // pframe.header の default 値を調整
    
    // LEFT SIDE ---------------------------------
    var dv = pframe.headerLeft;
    // 伝票名
    var sp = newSPAN(dv, formName+"title/responseButton");
    sp.innerHTML = formName;
    sp.style.marginLeft = "10px";
    sp.setAttribute("onclick", "foldSlip('"+formName+"')");
    setInfoTip(formName+"title", "この伝票を縮小・拡大"); // INFO
    
    // RIGHT SIDE ---------------------------------
    var dv = pframe.headerRight;
    dv.setAttribute("id", formName + "iconArea");
    dv.style.marginRight = "5px";
    // テンプレート・アイコン
    var sp = newSPAN(dv, formName + ".templateArea");
    sp.style.marginRight = "5px";
    var img = newIMAGE(sp, formName+"template/expandIcon", "./menu3.png", "+");
    var action = "getTemplateMenu('"+formName+"')";
    img.setAttribute("onclick", action);
    img.style.height = "10px";
    img.style.marginTop = "3px";
    setInfoTip(formName+"template", "操作メニュー"); // INFO
    // ハンマー・アイコン
    var sp = newSPAN(dv, "");
    var img = newIMAGE(sp, formName+"hummer/expandIcon", "./hammer.png", "X");
    img.setAttribute("onclick", "openSlipEditor('" + formName + "')");
    img.style.height = "12px";
    img.style.marginTop = "3px";
    setInfoTip(formName+"hummer", "伝票を編集"); // INFO
    // 削除アイコン
    var sp = newSPAN(dv, "");
    sp.style.marginLeft = "10px";
    var im = newIMAGE(sp, formName+"remove/expandIcon", "./remove-field.png", "X");
    im.setAttribute("onclick", "removeOrderSlip('"+formName+"')");
    im.style.height = "12px";
    setInfoTip(formName+"remove", "この伝票を削除"); // INFO

    // CONTENTS ============================================
    var pane = pframe.body;
    var div = newDIV(pane, formName+"contentsArea");
    div.style.padding = "3px 20px";
    // 伝票内容を生成
    listFormat(div, formName, records);

    // FOOTER：表示しない =====================================
    pframe.footer.style.display = "none";
    
    
    function listFormat(pane, formName, records){
        // 伝票の各項目をリスト表示
        pane.style.backgroundColor = "#ffe"; // 各伝票の背景色
        pane.style.paddingBottom = "0px";
        var formObj = formForSlipName(formName); // 伝票構造フォーマット
        var tbl = newTABLE(pane, "/base-table");
        for (label in records){
            var rec = records[label];
            var fid = field_id(formName, label);
            var tr = newTR(tbl, "", "");
            tr.style.borderBottom = "thin solid #ccc"; // 各伝票の罫線
            tr.style.fontSize = "10pt";
            tr.style.paddingBottom = "0px";

            // LABEL ==========================================
            var td = newTD(tr, "", "");
            td.style.width = "150px";
            td.style.paddingLeft = "15px";
            td.style.verticalAlign = "middle";
            var sp = newSPAN(td, "");
            sp.innerHTML = label;
            
            // VALUE ==========================================
            var td = newTD(tr, "", "");
            td.style.paddingLeft = "5px";
            //  VALUE OR DATE POPUP
            if (formObj){
                var fObj = formObj[label];
            }
            if (fObj && (fObj.type == "dateType")){
                var dv = newDIV(td, fid+".dateArea");
                dv.style.padding= "3px 0";
                var dateArray = ["","","","","",""];
                if (rec.value) // メモリーに記憶されていた場合
                    dateArray = arrayWithDateTime(rec.value);

                // 日付の表示形式で年月日ポップアップを表示：表示形式は dateFormat として記憶
                showDatePopup(dv, fid, fObj.dateFormat, dateArray);
            } else {
                var val = ""; // NOA データがなければ valueOfRecord(rec)
                if (isNewForm()){
                    // 新規伝票では初期設定値のみを表示
                    if (rec.fixed && (rec.fixed.length > 0))
                        val = rec.fixed; // 新規伝票かつ default 値があった場合
                } else if (rec.value && (rec.value.length > 0)){
                    // 検査欄から読込んだ伝票では検査欄から読込んだ値のみを表示
                    val = rec.value; // メモリーに記憶されていた場合
                }
                
                //  POPUP MENU
                if (rec.menu && (rec.menu.length > 0)){
                    var array = rec.menu.split(',');
                    array.splice(0,0,"");
                    var pp = newPopupMenu(td, label+".menu", array, val);
                    pp.setAttribute("onchange", "changedMenu(this,'"+fid+"')");
                }
                // VALUE：数値タイプか文字タイプかで入力タイプを選択
                var charType = (rec.charType && (rec.charType.length > 0)) ? "number" : null;
                var fd = newFIELD(td, fid, "", 20, val, charType);
                // onkeydownn だと iOS の場合 checkValue() 値に入力文字が追加されてしまう
                fd.setAttribute("onkeyup", "checkValue('" + fid + "')");
                checkValue(fid);
                
                // UNIT
                if (rec.unit){
                    var sp = newSPAN(td, "");
                    sp.innerHTML = rec.unit;
                    sp.style.paddingLeft = "5px";
                }
            }
        }
    }
}

function checkDisplayStatusForFormText(elm){
    // 「入力欄を表示しない」チェックボックスの状態により入力テキストの表示・非表示を切替える
    var div = elmFor(currentTag() + ".value");
    if (elm.checked)
        div.style.display = "none"; // 入力テキストを非表示にする
    else
        div.style.display = "block"; // 入力テキストを表示する
    setIgnoreFormText(elm); // チェックボックスの状態を localStorage に記憶s
}

function cleardSlipValue(answer){
    var obj = JSON.parse(answer);
    _setDateTime(null);
    setCurrentTag(null); // EDITOR が閉じたことを記憶しスタンバイ状態にする
    
    // カルテを再表示
    openChart(patientId());
}
function clearSlipValue(){
    // 編集内容を削除し前回受診時の記述が透けて見えるようにする
    var elm = document.getElementById(currentTag() + ".editorArea");
    elm.innerHTML = "";

    var sp = newSPAN(elm, "alertArea");
    sp.innerHTML = "... 本日のデータを空にしつつあります";
    
    var hid = hospitalId();
    var container = new Object();
    container[currentTag()] = "";
    
    put_page(owner(),hid,patientId(),currentDate(),timeLimit(),container,cleardSlipValue);
}
function removeAllSlips(){
    // 伝票すべてを削除
    var slips = currentForms(); // 表示されている伝票を入れたオブジェクト
    for (formName in slips){
        removeOrderSlip(formName);
    }
    // 入力欄を空にする
    var div = elmFor(currentTag() + ".value");
    div.innerHTML = " ";
}
function initForm(base){
    // base エリアに伝票ツールを生成
    // ===== 伝票内容エリア ==================================
    var cont = newDIV(base, "slipContnets");
    cont.style.marginBottom = "5px";

    // 検査パネル・ヘッダー ========================
    var header = newDIV(cont, "/clearfix");
    header.style.height = "22px";
    header.style.paddingTop = "5px";
    
    // LEFT SIDE ---------------------------------
    var headerLeft = newDIV(header, "/left-side");
    headerLeft.style.width = "85%";
    headerLeft.style.fontSize = "9pt";

    // 検査歴
    var sp = newSPAN(headerLeft, "");
    sp.innerHTML = "検査日";
    sp.style.marginRight = "5px";
    var sp = newSPAN(headerLeft, "examHistoryArea");
    showExamDate(sp); // 検査日ポップアップを表示

    // 伝票名ポップアップ・エリア
    var sp = newSPAN(headerLeft, "popUpArea");
    sp.style.marginLeft = "5px";

    // 検査伝票の拡大・縮小チェックボックス
    var sp = newSPAN(headerLeft, "");
    sp.style.positon = "relative";
    sp.style.top = "5px";
    var cb = newCHECKBOX(sp, "foldAllCheck", "全ての伝票を折畳む", foldAllSlips());
    cb.setAttribute("onchange", "checkFoldSlips(this)");

    // RIGHT SIDE ---------------------------------
    var dv = newDIV(header, "/right-side");
    dv.style.paddingRight = "5px";
    // カメラ・アイコン
    var sp = newSPAN(dv, "cameraIconArea");
    setInfoTip("cameraIconArea", "画像読込"); // INFO
    sp.style.marginRight = "5px";
    var img = newIMAGE(sp, "/expandIcon", "./camera.png", "image");
    img.style.height = "20px";
    img.setAttribute("onclick", "showPictureInTool()");
    img.style.verticalAlign = "top";
    // HELP ICON
    var sp = newSPAN(dv, "helpTip");
    setInfoTip("helpTip", "HELP"); // HELP
    sp.style.paddingRight = "10px";
    var img = newIMAGE(sp, "", "./help.png", "?");
    img.style.height = "17px";
    img.setAttribute("onclick", "openHelp('formHelp.html')");
    img.setAttribute("class", "expandIcon");

   // ===== 編集エリア ===================
    var div = newDIV(cont, "sl_editorArea");
    
    // === FOOTER =======================
    var footer = newDIV(cont, "");
    footer.style.fontSize = "9pt";
    // footer.style.marginTop = "10px";
    var div = newDIV(footer, "/clearfix");
    /*
   // --- LEFT SIDE ---
    var dv = newDIV(div, "/left-side");
    dv.style.width = "120px";
    // 伝票をすべて削除
    var im = newIMAGE(dv, "emptyAllValue/expandIcon", "./remove-field.png", "X");
    im.setAttribute("onclick", "removeAllSlips()");
    im.style.height = "12px";
    im.style.paddingRight = "10px";
    setInfoTip("emptyAllValue", "伝票をすべて削除"); // INFO
    // 透過アイコン
    var sp = newSPAN(dv, "clearFieldTip");
    sp.style.paddingRight = "10px";
    setInfoTip("clearFieldTip", "前回記述が透けて見えるようにする"); // HELP
    var img = newIMAGE(sp, "", "./selection.png", "");
    img.style.height = "12px";
    img.setAttribute("onclick", "clearSlipValue()");
    img.setAttribute("class", "expandIcon");
 */
    // --- RIGHT SIDE ---
    var dv = newDIV(div, "/right-side");
    dv.style.paddingRight = "10px";

    // 単位表示
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    var cb = newCHECKBOX(sp, "withUnitCheck", "単位表示", valueWithUnit());
    cb.setAttribute("onchange", "setValueWithUnit(this)");
    // 「空欄を書き戻さない」チェックボックスを表示
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    var cb = newCHECKBOX(sp, "", "空欄無視", ignoreBlankForm());
    cb.setAttribute("onclick", "setIgnoreBlankForm(this)"); // localStorage.js
    // 「入力欄を表示しない」チェックボックスを表示
    var sp = newSPAN(dv, "");
    sp.style.paddingRight = "5px";
    var cb = newCHECKBOX(sp, "", "入力欄を表示しない", ignoreFormText());
    cb.setAttribute("onclick", "checkDisplayStatusForFormText(this)");
    checkDisplayStatusForFormText(cb); // チェック状態によりテキストの表示・非表示を設定

 /*   // とりやめボタン
    var bt = newDIV(dv, "/whiteButton");
    bt.innerHTML = "とりやめ";
    bt.style.marginLeft = "10px";
    bt.setAttribute("onclick", "closeFormPanel()");*/
    
    /*
    var bt = newDIV(dv, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "saveOrder()");
*/
    setIsNewForm(false); // 新規伝票ではないことを記憶
    var label = parent().currentLabel();
    setOriginalLabel(label); // 伝票を開いた CELL の ラベル名 を記憶

    // ポップアップメニューを読み込み、カルテデータをセット
    getFormItems();
}

