
function PictureFrame(elm, headerLeftWidth, footerLeftWidth, rectangle){
    // 額縁 コンストラクタを生成
    // rectangle が指定されていれば header, footer の角が丸くならない
    elm.innerHTML = "";
    
    // === HEADER =============================
    var css = (rectangle) ? "/title-bar" : "/tool-header";
    this.header = newDIV(elm, css); //$$$$$
    // --- LEFT SIDE ---------------
    this.headerLeft = newDIV(this.header, "/left-side"); //$$$$$
    this.headerLeft.style.width = headerLeftWidth;
    // --- RIGHT SIDE ---------------
    this.headerRight = newDIV(this.header, "/right-side"); //$$$$$
    this.headerRight.style.paddingRight = "10px";
    //this.headerRight.style.marginLeft = "auto"; // 効果が現れない？？
    
    // === BODY ==============================
    this.body = newDIV(elm, ""); //$$$$$
    
    // === FOOTER ============================
    var css = (rectangle) ? "/title-bar" : "/tool-footer";
    this.footer = newDIV(elm, css); //$$$$$
    // LEFT-SIDE
    this.footerLeft = newDIV(this.footer, "/left-side"); //$$$$$
    this.footerLeft.style.width = footerLeftWidth;
    // RIGHT-SIDE
    this.footerRight = newDIV(this.footer, "/right-side"); //$$$$$
}

function Page(parentElement, patient, dateTime){
    // Page コンストラクタを生成
    var elm = newDIV(parentElement, "");
    
    // 付箋エリア ====================================
    this.postItArea = newDIV(elm, "");

    // PAGE HEADER =================================
    var header = newDIV(elm, "/clearfix");
    
    var div = newDIV(header, "");
    this.header = div;
    div.style.fontSize = "10pt";
    div.style.display = "inline";
    div.style.float = "left";
    // 受診日
    var sp = newSPAN(div, "");
    var num = weekOfDate(dateTime);
    sp.innerHTML = dateTime + " " + _weeks[num];
    sp.style.paddingLeft = "2px";
    sp.style.paddingRight = "20px";
    sp.style.color = "#00c";
    // 漢字氏名
    var sp = newSPAN(div, "");
    sp.innerHTML = patient.kanjiName;
    sp.style.fontSize = "12pt";
    sp.style.fontWeight = "bold";
    sp.style.paddingRight = "10px";
    // ふりがな氏名
    var sp = newSPAN(div, "");
    sp.innerHTML = patient.kanaName;
    sp.style.paddingRight = "10px";
    // 年齢
    var sp = newSPAN(div, "");
    sp.innerHTML = ageAtDate(patient.birthDate, dateTime) + " 才"
    sp.style.paddingRight = "5px";
    
    // 入院・入院外
    this.inPatientArea = newDIV(header, "/outPatient");
    this.inPatientArea.style.marginLeft = "10px";
    this.inPatientArea.style.display = "inline";
    this.inPatientArea.style.float = "right";
    
    // ページ・ヘッダーのアイコン・ギャラリー表示行 =======
    this.toolArea = newDIV(elm, "/clearfix");
    this.toolArea.style.paddingRight = "10px";
    this.toolArea.style.paddingBottom = "5px";

    // PAGE BODY ===================================
    this.body = newDIV(elm, "");
}

function FloatPanel(id, x, y, w, title, helpAction, titleAction){
    // フロート・パネルのコンストラクタを生成
    var elm = document.getElementById(id);
    if (!elm){
        alert(id + " がないのでパネルを表示できません");
        return null;
    }
    window.onmousemove = getMouseXY;
    setFloatPanel(elm);
    
    this.base = elm; // 外部からコントロールできる
    elm.style.padding = "5px";
    elm.style.borderRadius = "10px";
    elm.style.left = x; // 表示するx座標
    elm.style.top = y; // 表示するy座標
    elm.style.width = w;
    elm.style.backgroundColor = "#eee";
    elm.style.boxShadow = "2px 2px 10px 2px #555";
    elm.style.visibility = "visible";
    elm.style.opacity = "1.0"; // 何故か必要なことがある
    elm.innerHTML = "";

    // === HEADER =============
    var div = newDIV(elm, "/clearfix");
    div.setAttribute("onmousedown", "cursorLock(this)"); // マウスで掴み可動にする
    div.setAttribute("onmouseup", "cursorUnlock()"); // マウスで掴み可動にする
    var rightWidth = 20; // RIGHT SIDE WIDTH
    // --- LEFT SIDE
    // CLOSE BUTTON
    var dv = newDIV(div, "/left-side");
    var ary = elm.style.width.split("px"); // elm.style.width は "200px" 形式
    var width = ary[0] * 1;
    dv.style.width = (width - 25) + "px";
    dv.style.padding = "0"; // CSS を上書き
    var bt = newDIV(dv, "/closeButton");
    bt.style.fontSize = "10pt";
    bt.style.fontWeight = "bold";
    bt.innerHTML = "x";
    bt.setAttribute("onclick", "closeFloatPanel('" + id + "')");
    // TITLE
    this.title = newSPAN(dv, ""); // 外部から取得するための ID
    this.title.style.fontSize = "9pt";
    if (title){
        //var sp = newSPAN(dv, "seeThroughPanelTitle"); // 外部から取得するための ID
        this.title.innerHTML = title;
    }
    // タイトルをクリックすると action を実行
    if (titleAction){
        this.title.setAttribute("onclick", titleAction);
        this.title.setAttribute("class", "record");
        this.title.style.padding = "0 10px";
        this.title.style.borderRadius = "10px";
    }
    // --- RIGHT SIDE
    var dv = newDIV(div, "/right-side");
    dv.style.width = rightWidth + "px";
    dv.style.padding = "0"; // CSS を上書き
    dv.style.position = "relative";
    dv.style.top = "3px";
    dv.style.padding = "0"; // CSS を上書き
    // HELP
    if (helpAction){
        var img = newIMAGE(dv, "", "help.png", "help");
        img.style.height = "15px";
        img.setAttribute("onclick", helpAction);
        img.setAttribute("class", "expandIcon");
    }
    
    // === CONTENTS ===============
    this.contents = newDIV(elm, "");
    this.contents.style.marginTop = "5px";
}

function ClearPanel(id, x, y, w, title, helpAction, titleAction){
    // クリア・パネルのコンストラクタを生成
    var elm = elmFor(id);
    if (!elm){
        alert(id + " がないのでパネルを表示できません");
        return null;
    }
    setFloatPanel(elm);
    
    this.base = elm; // 外部からコントロールできる
    elm.style.padding = "5px";
    elm.style.left = x; // 表示するx座標
    elm.style.top = y; // 表示するy座標
    elm.style.width = w;
    elm.style.backgroundColor = "#fff";
    elm.style.visibility = "visible";
    elm.style.border = "thin solid #888";
    elm.style.opacity = "0.7"; // 1.0:不透明
    elm.innerHTML = "";
    
    // === HEADER =============
    var div = newDIV(elm, "/clearfix");
    var rightWidth = 20; // RIGHT SIDE WIDTH
    
    // --- LEFT SIDE
    // CLOSE BUTTON
    var dv = newDIV(div, "/left-side");
    var ary = elm.style.width.split("px"); // elm.style.width は "200px" 形式
    var width = ary[0] * 1;
    dv.style.width = (width - 25) + "px";
    dv.style.padding = "0"; // CSS を上書き
    var bt = newDIV(dv, "/closeButton");
    bt.innerHTML = "x";
    bt.setAttribute("onclick", "closeFloatPanel('" + id + "')");
    bt.style.fontSize = "12pt";
    bt.style.fontWeight = "bold";
    // TITLE
    this.title = newSPAN(dv, ""); // 外部から取得するための ID
    this.title.style.fontSize = "9pt";
    if (title){
        //var sp = newSPAN(dv, "seeThroughPanelTitle"); // 外部から取得するための ID
        this.title.innerHTML = title;
    }
    
    // --- RIGHT SIDE
    var dv = newDIV(div, "/right-side");
    dv.style.width = rightWidth + "px";
    dv.style.padding = "0"; // CSS を上書き
    dv.style.padding = "0"; // CSS を上書き
    // HELP
    if (helpAction){
        var img = newIMAGE(dv, "", "help.png", "help");
        img.style.height = "16px";
        img.style.marginTop = "1px";
        img.setAttribute("onclick", helpAction);
        img.setAttribute("class", "expandIcon");
    }
    
    // === CONTENTS ===============
    this.contents = newDIV(elm, "");
    this.contents.style.marginTop = "5px";
}

