
var _PATH = "/NOA/"; 
//var _PATH = "/X/NOA/";

// neuron.js は NOAシステム ３層構造の中間であるロジック層を形成
// dataCenter.js は色々なパラメータを記憶しておくクラス
// 基本的にすべて DB への依頼は neuron.js を通じて行われる
// 他から呼ばれ neuron.js で処理されるメソッドは他と区別するため頭に NR がつく

/*
function createXMLHttpRequest(func){
	var xmlHttpObject = null;
	
	if (window.XMLHttpRequest){ // Safari, Firefox
		xmlHttpObject = new XMLHttpRequest();
	} else if (window.ActieXObject){ // IE
		try{
			xmlHttpObject = new ActiveXObject("Msxml2.XMLHTTP"); // IE6
		} catch(e){
			try{
				xmlHttpObject = new ActiveXObject("Microsoft.XMLHTTP"); // IE5
			} catch(e){
				return null;
			}
		}
	}
	
	// xmlHttpObject が生成できたら、状態が変わった時に func が実行される
	if (xmlHttpObject) xmlHttpObject.onreadystatechange = func;
	return xmlHttpObject;
}

var _receiver;
function NRSendBack(){
	// サーバから返された処理を実行
    if (!_receiver){
		hideMessage("_message");
    }
    
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
            // ##### _receiver の処理でコケると _message が消えない #####
            //console.log("NRSendBack", _receiver); //##
			if (_receiver) _receiver(array[1]); // JSON
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ... ");
}
function NRDebug(){
	// サーバから返された処理を実行
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		//alert("=== NRDebug ===\n"+value); //## 返されたメッセージを debug 用に表示
		console.log("=== NRDebug ===<br>\n"+value); //## 返されたメッセージを debug 用に表示
		var array = value.split("<SEPARATOR>");
		if (_receiver && (array.length > 1)){
			_receiver(array[1]); // JSON
		}
		hideMessage("_message");
	} else
		showMessage("_message", "サーバで処理中です ...");
}
function NRNoAction(answer){
	// receiver として何も返す必要がないときに使う
}

function _callServer(command, server, args, receiver, isDebugMode){
	// Ajax を使って server に command を送る
    //console.log("_callServer",command, server, args); //##
    if (isDebugMode)
        xmlHttpObject = createXMLHttpRequest(NRDebug);
    else if (!receiver)
        xmlHttpObject = createXMLHttpRequest(NRNoAction);
    else
        xmlHttpObject = createXMLHttpRequest(NRSendBack);

	if (xmlHttpObject){ // GETパラメータ付きでリクエスト送信
        // FRONT など外部から使うには絶対パスの必要あり
        var st = server;
        if (command) st += "?command=" + command;
        if (args) st += "&value=" + encodeSTRING(encodeObject(args));
        
		_receiver = receiver; // 結果を受け付けるメソッドを記憶
                
        console.log("_callServer", st); //##

        xmlHttpObject.open("GET", encodeURI(st), true);
		xmlHttpObject.send(null);
	}
}

function _postServer(command, server, args, receiver, isDebugMode){
    //alert("=== _postServer server: "+server); //##
    if (isDebugMode)
        xmlHttpObject = createXMLHttpRequest(NRDebug);
    else if (!receiver)
        xmlHttpObject = createXMLHttpRequest(NRNoAction);
    else
        xmlHttpObject = createXMLHttpRequest(NRSendBack);
    
    if (xmlHttpObject){
        // FRONT など外部から使うには絶対パスの必要あり
        _receiver = receiver; // 結果を受け付けるメソッドを記憶
        var st = "command=" + command;
        
        if (args){
            // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
            // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
            for (key in args){
                st += "&" + key + "=" + encodeURI(encodeSTRING(args[key]));
            }
        }
        //alert("_postServer ===>"+st); //##
        
        xmlHttpObject.open("POST", server, true);
        xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
        xmlHttpObject.send(st);
    }
}*/

function _callServer(command, server, args, receiver, isDebugMode){
    // Ajax を使って server に command を送る
    xmlHttpObject = new XMLHttpRequest();
    xmlHttpObject.onreadystatechange = function() {
        if (xmlHttpObject.readyState == 4) {
            if (xmlHttpObject.status == 200) {
                if (isDebugMode) console.log("for DEBUG:", xmlHttpObject.responseText); // debug 用出力
                var array = xmlHttpObject.responseText.split("<SEPARATOR>");
                if (array.length > 1){
                    if (receiver) receiver(array[1]);
                }
            } else {
                console.log("_callServer ERROR: status = " + xmlHttpObject.status);
            }
        }
    }
    // FRONT など外部から使うには絶対パスの必要あり
    var st = server;
    if (command) st += "?command=" + command;
    if (args) st += "&value=" + encodeSTRING(encodeObject(args));
    console.log("_callServer", st); //###

    xmlHttpObject.open("GET", encodeURI(st));
    xmlHttpObject.send();
}
function NRCall(command, args, receiver, isDebugMode){
	// server に command を送る
    _callServer(command, _PATH + "server.php", args, receiver, isDebugMode);
}
function NRCallVin(command, args, receiver, isDebugMode){
	// vinServer に command を送る
    _callServer(command, _PATH + "vinServer.php", args, receiver, isDebugMode);
}

function _postServer(command, server, args, receiver, isDebugMode){
    // postServer にデータを POST
    xmlHttpObject = new XMLHttpRequest();
    xmlHttpObject.onreadystatechange = function() {
        if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
            // レスポンスの表示
            var array = xmlHttpObject.responseText.split("<SEPARATOR>");
            if (array.length > 1){
                if (receiver) receiver(array[1]);
            }
        } else { // debug 用出力
            console.log("_postServer ERROR: status = " + xmlHttpObject.status);
            if (isDebugMode) console.log("for DEBUG:", xmlHttpObject.responseText); // debug 用出力
        }
    }
    
    var st = "command=" + command;
    if (args){
        // encodeURI は '&' をエンコードしてくれないのでこちら側でエンコード
        // ### send() に与える文字列:st 全体をエンコードしては駄目 ###
        for (key in args){ st += "&" + key + "=" + encodeURI(encodeSTRING(args[key])); }
    }
    console.log("== NR_POST", command, st); //###
    
    xmlHttpObject.open("POST", server);
    xmlHttpObject.setRequestHeader('Content-Type','application/x-www-form-urlencoded; charset=UTF-8');
    xmlHttpObject.send(st);
}
function NRPost(command, args, receiver, isDebugMode){
    _postServer(command, _PATH + "postServer.php", args, receiver, isDebugMode);
}

