
var _modeObj = {"以下とは共存できない":"remove","以下もあってよい":"add","算定しない":"ignore"};
var _freqObj = {"が":"1","が 2回/月以上":"2","が 3回/月以上":"3"};
var _byoumei = 1;
var _answer; // Ajax の戻りを待つために使う変数

function freqForLabel(label){
    // label に対応する回数を返す
    var array = label.split("存在したなら");
    if (array.length > 1)
        return _freqObj[array[0]] * 1;
    else
        return 0;
}
function labelForFreq(freq){
    // 回数に対応する label を返す
    if (freq * 1 == 0)
        return "";
    
    for (label in _freqObj){
        if (_freqObj[label] * 1 == freq * 1){
            return label + "存在したなら";
        }
    }
}

/*
var _filterObj = {"60:子宮内膜組織採取":{"mode":"remove","children":["60:子宮頸管粘液採取"]},"60:コルポスコピー":{"mode":"remove","children":["41:腟洗浄"]},"60:ＡＢＯ":{"mode":"add","children":["60:アルカリホスファターゼ","60:ＣＡ１２５"]}};
 */
var _filterObj;
function setFilterObj(obj){
    /* サーバから読み込んだフィルター構造を以下の形式で _filterObj に記憶
    _filterObj = {"60:子宮内膜組織採取":{"mode":"remove","children":["60:子宮頸管粘液採取"]},"60:コルポスコピー":{"mode":"add","children":["41:腟洗浄"]}}; */
    _filterObj = new Object();
    for (keyAndName in obj){
        var rec = JSON.parse(obj[keyAndName]);
        
        _filterObj[keyAndName] = rec;
    }
}
function filterObj(){
    // フィルター機能を実現するオブジェクト
    return _filterObj;
}
function hasFilter(){
    // filter() を機能させるには true を返す
    var status = vinFilterEnabled(); // localStorage
    return (status) ? true : false;
}
function filterKeys(){
    // フィルター・キーの配列を返す
    var array = allKeys(_filterObj);
    array.splice(0,0,"");
    array.push("...その他");
    
    return array;
}
function filterForKey(key){
    // key に対応するフィルター・オブジェクトを返す
    return _filterObj[key];
}

var _treatmentHistory;
function setTreatmentHistory(obj){
    // 今月の診療日ごとの診療欄履歴を記憶
    _treatmentHistory = obj;
}
function setTreatmentHistoryForDateTime(val, dateTime){
    // dateTime の内容を val に置換
    _treatmentHistory[dateTime] = val;
}
function treatmentHistory(){
    return _treatmentHistory;
}
function countOfTreatment(treatment, targetDateTime){
    // 今月中の targetDateTime 以前までの treatmen の出現数を返す
    // treatment = "検査[超音波検査]" のような形式
    var count = 0;
    for (dateTime in _treatmentHistory){
        if (dateTime > targetDateTime) continue;
        
        var treatments = _treatmentHistory[dateTime]; // dateTime の診療欄の内容
        var array = (treatments) ? treatments.split(treatment) : [];
        if (array.length > 1) count++;
    }
    return count;
}

var _conditions;
var _conditionRow;
function initCondition(){
    // 条件を初期化：フィルター
    _conditions = new Array();
    _conditionRow = 0;
}
function setConditionRow(row){
    _conditionRow = row;
}
function conditionRow(){
    // 条件要素の行番号を返す
    // ０番は親要素
    return _conditionRow;
}

var _currentDiseases;
function setCurrentDiseases(array){
    // カルテの当日の病名の配列を記憶
    _currentDiseases = array;
}
function hasDisease(disease){
    // カルテの当日の病名に disease があれば true を返す
    for (num in _currentDiseases){
        var name = _currentDiseases[num];
        if (disease == name) return true;
    }
    return false;
}


function makeFilterObj(){
    // 編集されたフィルターをオブジェクトにして返す
    var rec = new Object();
    var key;
    
    for (row in _conditions){
        var obj = _conditions[row];
        if (obj.code * 1 == 0) continue; // 空行はスキップ
        
        if (row == 0){ // 親条件
            var comment = (obj.comment) ? obj.comment : "";
            var freq = freqForLabel(document.getElementById("freqPop").value);
            key = obj.code+":"+obj.name+":"+comment+":"+freq;
            
            rec[key] = new Object();
            rec[key].children = new Array();
        } else { // 子条件
            rec[key].children.push(obj.code+":"+obj.name);
        }
    }
    //console.log("makeFilterObj key:", key); //##
    
    // モード
    var label = document.getElementById("modePop").value;
    rec[key].mode = (_modeObj[label]) ? _modeObj[label] : "";
    
    if (_modeObj[label] == "ignore"){
        var anobj = new Object();
        anobj.children = "";
        anobj.mode = "ignore";
        rec[key] = anobj;
    }
    //console.log("label", label, "rec[key]", encodeObject(rec[key])); //##
    
    var result = new Object();
    result.key = key;
    result.value = JSON.stringify(rec[key]);
    
    return result;
}

//////////////////////////////////////////////////////
// Ajax //////////////////////////////////////////////

var _currentRow;
function gotNameList(answer){
	// アイテムリストを表示する
	if ((xmlHttpObject.readyState == 4) && (xmlHttpObject.status == 200)){
		var value = xmlHttpObject.responseText;
		var array = value.split("<SEPARATOR>");
		if (array.length > 1){
			var elm = document.getElementById("nameArea" + _currentRow);
			elm.innerHTML = "";
            
			var obj = JSON.parse(array[1]);
			// obj は {"再診料":"saishin",,} のようなオブジェクトの配列
			var items = new Array();
			for (title in obj){
				var value = obj[title];
                if (title.length ==0) continue;
                
				items.push(title);  // title:"再診料"
			}
			items.splice(0, 0, "");
			items.push("...その他");
            
			// item 選択ポップアップを表示
            var fobj = _conditions[_currentRow];
            var item = (fobj) ? fobj.name : "";
			var pu = newPopupMenu(elm, "namePop" + _currentRow, items, item);
            pu.setAttribute("onchange", "changedName(this,'" + _currentRow + "')");
            pu.style.marginLeft = "5px";
		}
	}
}
function getNameList(row, code){
	// 診療行為マトリックスの選択で起動され、該当アイテムリストをリクエスト
    var args = new Object();
    args.code = code;
    _currentRow = row;
    
    NRCallVin("GET_CHILD_SELECTOR", args, gotNameList);
}

function savedConditions(answer){
    // フィルター編集パネルを再表示
    
    // フィルター条件画面を消す
    var elm = elmFor("filterContentsArea");
    elm.innerHTML = "";

    // フィルター・ポップアップメニューを生成
    getFiter();
}
function saveConditions(){
    // 設定した条件をフィルターとして保存
    // rec={"60:頸管粘液:comment:1":{"children":["41:腟洗","60:血型"],"mode":"remove"}} 型式
    var rec = makeFilterObj();

    var args = new Object();
    args["key"] = rec.key;
    args["value"] = rec.value;
    NRCall("PUT_VIN_FILTER", args, savedConditions, true);
}

function getDiseases(){
    // 本日カルテの傷病名をサーバへリクエスト
    var tags = "ProgressSection.disease"; // "item1,item2" のようなカンマ区切り形式
    var obj = valueForTag("ProgressSection.disease", parent().currentDate());
    var val = (obj && obj.value) ? obj.value : "";
    
    var diseases = new Array();
    var array = val.split("<br>");
    for (row in array){
        var ln = array[row]; // "年月日 病名" 形式
        var ary = ln.split(" ");
        var name = ary[1];
        diseases.push(name);
    }
    setCurrentDiseases(diseases);
}

function gotTreatments(answer){
    // 診療欄の検索結果をサーバから得る
    var obj = JSON.parse(answer);
    
    // 今月の診療日ごとの診療欄履歴を記憶
    setTreatmentHistory(obj);
    //console.log("診療欄の検索結果==="); //##
    
    // 接頭語・接尾語をサーバへリクエスト
    getSuffix();
}
function getTreatments(){
    // 診療欄の今月分の履歴を取得：ignore で使う
    var args = new Object();
    args["patientId"] = parent().patientId();
    args["yearMonth"] = parent().currentDate().substr(0, 7);
    NRCall("GET_TREATMENTS", args, gotTreatments);
}

function gotFiter(answer){
    var obj = JSON.parse(answer);
    //console.log("gotFilter：フィルター =====", encodeObject(obj)); //##
    
    setFilterObj(obj);
    getDiseases();
    
    var elm = elmFor("filterListArea");
    if (elm){ // getFiter() が vin.js から呼ばれた場合はここをパス
        elm.innerHTML = "";
        // LABEL
        var sp = newSPAN(elm, "");
        sp.innerHTML = "FILTER";
        sp.style.paddingRight = "5px";
        sp.setAttribute("onclick", "_showInfo()"); //##
        
        // KEY ポップアップ
        var pu = newPopupMenu(elm, "listPop", filterKeys(), "");
        pu.setAttribute("onchange", "listSelected(this)");
    }
    
    // 診療欄の今月分の履歴を取得
    getTreatments();
}
function getFiter(){
    // フィルターをサーバへリクエスト
    var args = new Object();
    NRCall("GET_VIN_FILTER", args, gotFiter);
}


// Ajax //////////////////////////////////////////////
//////////////////////////////////////////////////////


///////////////////////////////////////////////////////
///// filtering ///////////////////////////////////////

function filter(records){
    // buff にフィルターを掛ける
    // 診療行為と行数の対応配列を生成
    var obj = new Object();
    for (row in records){
        var rec = records[row];
        
        // 自費には適用しないなら rec.isOwn でコントロール
        var cname = rec.code + ":" + rec.name;
        obj[cname] = row;
    }
    
    _answer = new Object();
    var filtObj = filterObj();
    for (key in filtObj){
        // key = "code:name:comment:freq" 型式
        var fobj = filtObj[key];
        var ary = key.split(":");
        var code = ary[0] * 1;
        var name = ary[1];
        var comment = ary[2];
        var freq = ary[3];
        var codeAndName = code + ":" + name;

        if (code == 1){
            // フィルター・ラベルが病名だった
            if (hasDisease(name)){
                console.log(name + " がヒット->"+encodeObject(fobj)); //##
                var array = fobj.children;
                for (num in array){ // フィルターの子条件をスキャン
                    var target = array[num]; // フィルターの子条件
                    if (fobj.mode == "remove"){
                        removeTarget(codeAndName, target, comment);
                    } else if (fobj.mode == "add"){
                        // records 中に rec が見つからなければ追加
                        var rec = recordForTarget(target);
                        addTarget(codeAndName, target, rec, comment);
                    }
                }
            }
        } else {
            if (obj[codeAndName] || (sourceHasSameCode(obj, code, name))){
                // フィルター・ラベルに対応する診療行為があった
                if (fobj.mode == "ignore"){
                    // codeAndName の当月の算定回数を算出し freq を超えていないかチェック
                    var st = codeName(code) + "[" + name + "]";
                    var count = countOfTreatment(st, parent().currentDate());
                    
                    // ### 回数ポップアップは ignore の場合だけ表示するよう修正のこと ###
                    if ((count >= freq) && confirm(codeAndName +" が算定限度 "+ freq +" 回/月 に達し " + count + " 回なので削除します")){
                        // 診療内容から該当行を削除
                        var row = obj[codeAndName];
                        delete records[row];
                    }
                } else {
                    var array = fobj.children;
                    for (num in array){ // フィルターの子条件をスキャン
                        var target = array[num]; // フィルターの子条件
                        if (fobj.mode == "remove"){
                            removeTarget(codeAndName, target);
                        } else if (fobj.mode == "add"){
                            // records 中に rec が見つからなければ追加
                            var rec = recordForTarget(target);
                            addTarget(codeAndName, target, rec);
                        }
                    }
                }
            }
        }
    }
    
    return records;
    
    function sourceHasSameCode(obj, code, name){
        // code だけで name の指定されていない時に作用
        // すなわちソースに同じ code が存在するかどうかを検証
        if (name.length)
            return false;
        
        // obj の中に code と一致するコードがあれば true を返す
        for (key in obj){
            var ary = key.split(":");
            var cd = ary[0] * 1;
            
            if (cd == code) return true;
        }
        return false;
    }
    
    function addTarget(key, target, record, comment){
        // records へ record をひとつのみ追加
        var hasTarget = false;
        for (row in records){
            var rec = records[row];
            var codeAndName = rec.code + ":" + rec.name;
            
            if (codeAndName == target) hasTarget = true;
        }
        
        if (!hasTarget){
            if (comment){
                if (confirm("「"+key + "」があるので " + comment + "「" + target + "」を追加します")){
                    records.push(record);
                }
            } else if (confirm("「"+key + "」があるので「" + target + "」を追加します")){
                records.push(record);
            }
            _debug("addTarget->"+encodeObject(record));
        }
    }
    
    function removeTarget(key, target){
        // records から target を削除：複数あってもすべて削除
        var hasTarget = false;
        var array = new Array();
        for (row in records){
            var rec = records[row];
            var aKey = rec.code + ":" + rec.name;
            
            // target 以外を array へ収納
            if (aKey == target)
                hasTarget = true;
            else
                array.push(rec);
        }
        if (comment){
            if (confirm("「"+key + "」があるので " + comment + "「" + target + "」を削除します")){
                records = array;
            }
        } else if (hasTarget && confirm("「"+key + "」があるので「" + target + "」を削除します")){
            records = array;
        }
    }
    
    function recordForTarget(target){
        // "60:ＡＢＯ" 型式の target から Vin で扱う型式へ変換
        var ary = target.split(":");
        var code = ary[0];
        var name = ary[1];
        // isOwnFee_|_code_|_alias_|_name_|_dose_|_unitName_|_freq_|_point_|_isMix
        var origin = "_|_"+code+"_|__|_"+name+"_|_1_|__|__|__|_";
        
        /* rec は以下の形式
         origin(isOwnFee_|_code_|_alias_|_name_|_dose_|_unitName_|_freq_|_point_|_isMix)
         number(1)
         subItems()
         isOwn(0)
         code(48)
         alias(kuromai)
         name(クロマイ腟錠１００ｍｇ)
         dose(1)
         standard(1)
         unitName(錠)
         freq(1)
         point(7)
         isMix(0)
         editable(0)
         */
        var rec = new Object();
        rec.origin = origin;
        rec.isOwn = "0";
        rec.code = code;
        rec.name = name;
        rec.dose = "1";
        
        return rec;
    }
}

///// filtering ///////////////////////////////////////
///////////////////////////////////////////////////////


var _codeNameArray;
function codeNameArray(){
    // コード名の配列を返す
    if (!_codeNameArray){
        _codeNameArray = [""];
    
        var array = codeArray();
        for (num in array){
            var code = array[num];
            _codeNameArray.push(codeName(code));
        }
        _codeNameArray.push("病名");
    }
    
    return _codeNameArray;
}

function changedCode(elm, row){
    // code が変更された
    var codeName = elm.value;
    if (codeName == "病名"){
        _conditions[row].code = _byoumei;　// row 位置のフィルター・オブジェクト

        get_menu(parent().owner(), "ProgressSection.disease", gotDiseaseMenu);
    } else {
        var code = codeForName(codeName);
        _conditions[row].code = code;　// row 位置のフィルター・オブジェクト
        
        if (code) getNameList(row, code);
    }
}
function changedName(elm, row){
    // name が変更された
    var codeName = document.getElementById("codePop" + row).value;

    if (codeName == "病名"){
        // 病名の場合は「入力時コメント」がつく
        _conditions[row].name = document.getElementById("namePop0").value;
        _conditions[row].comment = document.getElementById("commentF").value;
    } else {
        _conditions[row].name = elm.value;
    }
}

function removeCondition(row, label){
    // row, label の条件を削除し再表示
    console.log("removeCondition", row, label); //###
    if (row == 0){ // フィルターそのものを削除
        if (confirm("「" + label + "」のフィルターを削除")){
            // value が null なら key に相当するレコードを削除
            var args = new Object();
            args["key"] = label;
            args["value"] = null;
            
            NRCall("PUT_VIN_FILTER", args, savedConditions);
        }
    } else { // 子条件を削除
        if (confirm(label + " を削除")){
            _conditions.splice(row, 1);
            
            // --- children 各行を生成 -------------------
            var elm = document.getElementById("childrenArea");
            elm.innerHTML = "";
            _conditionRow = 1; // KEY 行の次の children 行から始める
            for (row in _conditions){
                if (row == 0) continue; // KEY 行はスキップ
                
                // コード名・診療行為名・入力時説明を生成
                var obj = _conditions[row];
                makeConditonRow(elm, obj.code + ":" + obj.name);
            }
        }
    }
}

function makeConditonRow(div, label){
    // コード名・診療行為名・入力時説明を生成
    // "60:子宮頸管粘液採取:コメント:1" のようなラベル名を元に条件設定行を生成
    var row = conditionRow(); // 現在の条件設定行の位置
    // フィルター・オブジェクトを生成
    var obj = new Object();
    if (label && (label != "...その他")){
        var array = label.split(":");
        obj.code = array[0];
        var cname = (obj.code * 1 == 1) ? "病名" : codeName(obj.code);
        obj.name = array[1];
        obj.comment = array[2];
        obj.freq = array[3];
    } else {
        obj.code = "0";
        var cname = "";
        obj.name = "";
        obj.comment = "";
        obj.freq = "0";
    }
    
    // 削除アイコン
    var dv = newDIV(div, "");
    var img = newIMAGE(dv, "", "./remove-field.png", "X");
    img.style.height = "13px";
    img.setAttribute("onclick", "removeCondition(" + row +",'" + label + "')");
    img.style.marginRight = "5px";

    // コード名
    var pu = newPopupMenu(dv, "codePop" + row, codeNameArray(), cname);
    pu.setAttribute("onchange", "changedCode(this,'" + row + "')");
    
    // 診療行為名
    var sp = newSPAN(dv, "nameArea" + row);
    var bt = newSPAN(sp, "");
    bt.innerHTML = (obj.name) ? obj.name : "";
    bt.setAttribute("onclick", "getNamePop('" + row + "')");
    bt.style.marginLeft = "5px";
    
    // 入力時説明
    if (obj.comment){
        var dv1 = newDIV(sp, ""); // nameArea に従属
        dv1.style.marginLeft = "20px";
        var sp = newSPAN(dv1, "");
        sp.innerHTML = "入力時説明 ";
        sp.style.verticalAlign = "top";
        var fd = newTEXTAREA(dv1, "commentF", 30, 3, obj.comment);
        fd.setAttribute("onchange", "changedName(this,'0')");
    }
    
    // フィルター・オブジェクトを _conditions に記憶
    _conditions[row] = obj;
    
    // 条件設定の対象行をインクリメント
    setConditionRow(row + 1);
}

function gotDiseaseMenu(answer){
    var obj = JSON.parse(answer);
    
    var menus = new Array();
    for (num in obj){
        var rec = obj[num];
        if (rec.menu.length)
            menus.push(rec.menu);
    }
    //alert("gotDiseaseMenu->"+encodeObject(menus)); //##
    
    // 病名選択ポップアップを表示
    var elm = document.getElementById("nameArea0");
    elm.innerHTML = "";
    
    var fobj = _conditions[0];
    var name = (fobj) ? fobj.name : "";
    
    var pu = newPopupMenu(elm, "namePop0", menus, name);
    pu.setAttribute("onchange", "changedName(this,'0')");
    
    // コメント入力欄
    var div = newDIV(elm, "");
    var sp = newSPAN(div, "");
    sp.innerHTML = "入力時説明 ";
    sp.style.verticalAlign = "top";
    var fd = newTEXTAREA(div, "commentF", 30, 3, fobj.comment);
    fd.setAttribute("onchange", "changedName(this,'0')");
}
function getNamePop(row){
    // row 行に namePop を表示
    var obj = _conditions[row];
    
    if (obj.code * 1 == 1){ // 病名の場合
        get_menu(parent().owner(), "ProgressSection.disease", gotDiseaseMenu);
    } else {
        getNameList(row, obj.code);
    }
}

function addCondition(){
    // 条件設定行を追加
    var elm = document.getElementById("childrenArea");
    
    // コード名・診療行為名・入力時説明を生成
    makeConditonRow(elm, "");
}

function freqPopChanged(elm, key){
    // 存在回数ポップアップが変更された
    var freq = freqForLabel(elm.value);
    console.log("=== freqPopChanged", freq, elm.value, "key(" + key + ")"); //##
    
    if (key == "...その他"){
        key = null;
        var obj = new Object();
        obj.children = [""];
    } else {
        var obj = filterForKey(key);
    }
    //console.log("obj", encodeObject(obj)); //##

    var div = elmFor("modePopArea");
    div.innerHTML = "";
    
    // 子供ポップアップ・確定ボタン 表示エリア
    var subAea = elmFor("subControlsArea");
    if (subAea){
        subAea.innerHTML = "";
        var childArea = newDIV(subAea, "childrenArea");
    }

    if (freq > 1){
        var pu = newPopupMenu(div, "modePop", ["算定しない"], "");
    } else if (freq == 1){
        var menus = [];
        for (label in _modeObj){
            // "算定しない" 以外をポップアップメニューに表示
            var mode = _modeObj[label];
            if (label != "算定しない") menus.push(label);
        }
        if (obj){
            var st = modeLabel(obj.mode);
            var pu = newPopupMenu(div, "modePop", menus, st);

            // --- children 行を生成 -------------------
            for (num in obj.children){
                var val = obj.children[num];
                
                // コード名・診療行為名・入力時説明を生成
                makeConditonRow(childArea, val);
            }
            
            // 追加アイコンを表示
            if (subAea){
                var img = newIMAGE(subAea, "", "./add-field.png", "+");
                img.style.height = "15px";
                img.setAttribute("onclick", "addCondition()");
            }
        }
    }

    // 確定ボタンを表示
    if (subAea){
        var div = newDIV(subAea, "");
        div.style.textAlign = "right";
        var bt = newDIV(div, "/fixButton");
        bt.innerHTML= "以上の条件でフィルター設定";
        bt.setAttribute("onclick", "saveConditions()");
        bt.style.padding = "8px 10px 3px 10px";
        bt.style.marginBottom = "5px";
    }


    function modeLabel(mode){
        // 例えば "remove" に対応する "以下とは共存できない" を返す
        for (label in _modeObj){
            var md = _modeObj[label];
            if (mode == md) return label;
        }
        return "";
    }
}

function setConditionPane(key){
    // 条件設定ペーンを表示
    initCondition();

    // --- main controls (code, name, freq, mode) を生成 -------------------
    var elm = document.getElementById("mainControlsArea");
    elm.innerHTML = "";
    elm.style.fontSize = "9pt";
    
    // listPop が空白なら条件設定は空白のまま終了
    if (key.length == 0) return;
    
    // --- コード名・診療行為名・入力時説明を生成 -----------------
    var div = newDIV(elm, "");
    makeConditonRow(div, key);

    // freqPop modePop 表示エリアを生成 ------- 上記 div から１段落下がる
    var div = newDIV(elm, "");
    div.style.marginLeft = "20px";
    div.style.fontSize = "9pt";
    
    // --- freqPop(回数/月) を生成 ------------
    var menus = [""];
    for (label in _freqObj){
        menus.push(label + "存在したなら");
    }
    var freq = 0;
    if (key != "...その他"){
        var array = key.split(":");
        var freq = (array.length > 3) ? array[3] : 1;
    }
    var menu = labelForFreq(freq);
    var pu = newPopupMenu(div, "freqPop", menus, menu);
    pu.setAttribute("onchange", "freqPopChanged(this,'" + key + "')"); // modePop を生成
    
    // --- modePop エリアを生成 -------------------
    var div = newDIV(elm, "modePopArea");
    div.style.margin = "0 0 10px 20px";
    
    // --- children, 確定ボタン 表示エリアを生成 -------------------
    var div = newDIV(elm, "subControlArea");
    div.style.margin = "0 0 10px 20px";

    // default の状態を表示
    freqPopChanged(pu, key);
}

function listSelected(menu){
    // listPop でフィルターのリストが選択された
    //console.log("=== listSelected", menu); //##

    var elm = elmFor("filterContentsArea");
    elm.innerHTML = "";

    // main control (code, name, freq, mode) を表示するエリア
    var div = newDIV(elm, "mainControlsArea");
    var key = menu.value;

    // 子ポップメニューや追加ボタンを表示するエリア
    var div = newDIV(elm, "subControlsArea");
    div.style.paddingLeft = "20px";
    div.style.fontSize = "9pt";

    // main controls (code, name, freq, mode) を生成
    setConditionPane(key);
}

function _showInfo(){
    // フィルター・オブジェクトの内容を確認のため表示
    var rec = makeFilterObj();
}

function openFilter(button){
    // フィルター設定パネルを開く
    var panel = document.getElementById("_floatPanel");
    if (panel.innerHTML.length){
        closeFloatPanel();
        return;
    }

    var pos = getPosition(button);
    var w = 500;
    var x = pos.x; // 表示するx座標
    var y = pos.y + 20; // 表示するy座標
    var panel = new FloatPanel("_floatPanel", x, y, w, "フィルター編集","openHelp('vinFilterHelp.html')");
    if (!panel) return;
    var elm = panel.contents;
	elm.style.opacity = "1.0"; // dom.js を上書き
	elm.style.backgroundColor = "#ffd"; // dom.js を上書き
	elm.style.padding = "5px";
	elm.style.marginTop = "5px";
	elm.style.borderRadius = "5px";
    
    // フィルターのリスト表示エリア
    var div = newDIV(elm, "filterListArea");
    div.style.marginBottom = "5px";
    div.style.fontSize = "9pt";

    // フィルターの内容表示エリア
    var div = newDIV(elm, "filterContentsArea");
    div.style.padding = "5px 0";

    // チェックボックスエリア
    var div = newDIV(elm, "/clearfix");
    div.style.fontSize = "9pt";
    div.style.marginTop = "10px";
    var dv = newDIV(div, "/left-side");
	dv.style.paddingLeft = "0px";
    var status = vinFilterEnabled(); // localStorage
    var cb = newCHECKBOX(dv, "", "フィルターを有効にする", status);
    cb.setAttribute("onchange", "setVinFilterEnabled(this)"); // localStorage
    var dv = newDIV(div, "/right-side");
	dv.innerHTML = fl_version();
    dv.style.fontSize = "9pt";
    dv.style.color = "#aaa";
    dv.style.paddingRight = "5px";

    // フィルターのリストを表示
    getFiter();
}

function fl_version(){
    return "Ver.180408";
}
