
function targetName(){
	var item = document.getElementById("tablePop").value;
	if (item == "主訴") 
		return "ProgressSection.subject";
	else if (item == "診療内容")
		return "ProgressSection.treatment";
	else if (item == "曜日")
		return "week";
	else
		return "";
}
function tableName(){
	var item = document.getElementById("tablePop").value;
	if (item == "主訴") 
		return "subjectTable.txt";
	else if (item == "診療内容")
		return "treatmentTable.txt";
	else
		return "";
}

var _sources;
function setSource(array){
	_sources = array;
}
function source(){
	return _sources;
}
function removeSourceAt(row){
	_sources.splice(row, 1);
}
function addSourceAtLast(){
	_sources.push("");
}
function setSourceAt(row){
	// 内容が変更された時に source() を更新
	var left = document.getElementById("left." + row).value;
	var right = document.getElementById("right." + row).value;
	var st = "'" + left + "','" + right + "'";

	// '*' があれば unique 処理、なければ replace 処理がサーバで行われる
	if (document.getElementById("check." + row).checked)
		st += ",'*'";
	
	_sources.splice(row, 1, st);
}

var _precision;
function setPrecision(status){
	_precision = status;
}
function precision(){
	return _precision;
}

function clickedPrecision(elm){
	// 高精度（低速度）処理　がチェックされた
	var status = (elm.checked) ? 1 : 0;
	setPrecision(status); 
}

function removeSource(row){
	// row 行目のレコードを削除
	var st = document.getElementById("left." + row).value;
	
	if (confirm("「" + st + "」の行を削除していいですか")){
		removeSourceAt(row);
		setPreference(source());
	}
}

function addSource(){
	// レコードを追加
	addSourceAtLast();
	setPreference(source());
}

function setPreference(array){
	// 設定値を表示
	setSource(array);
    //alert("setPreference->"+encodeObject(array)); //##
	
	var elm = document.getElementById("tableContentsArea");
	elm.innerHTML = "";
	var tbl = newTABLE(elm, "");

	if (document.getElementById("tablePop").value == "主訴"){
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "", "");
		tr.style.fontSize = "9pt";
		var status = precision();
		var cb = newCHECKBOX(td, "", "高精度（低速度）処理", status);
		cb.setAttribute("onchange", "clickedPrecision(this)");
		var td = newTD(tr, "", "");
	}
	
	var tr = newTR(tbl, "", "");
	tr.style.fontSize = "9pt";
	tr.style.textAlign = "center";
	var td = newTD(tr, "", "「変換対象行」中の以下の「文字列」を");
	var td = newTD(tr, "", "以下の「文字列」へ置換");

	td.setAttribute("colspan", "2");

	for (i in array){
		var left = "";
		var right = "";
		var status = 0;
		var st = array[i];
		if (st.length > 0){
			var ary = st.split("','");
			left = ary[0].substr(1);
			right = ary[1].substr(0, ary[1].length - 1);
			if (ary.length > 2){
				right = ary[1];
				if (ary[2].charAt(0) == '*') status = 1;
			}
		}
		
		var tr = newTR(tbl, "", "");
		var td = newTD(tr, "", "");
		var cb = newCHECKBOX(td, "check."+i, "", status);
		cb.setAttribute("onchange", "setSourceAt("+ i + ")");
		var fd = newFIELD(td, "left."+i, "", 50, left);
		fd.setAttribute("onchange", "setSourceAt("+ i + ")");
		var td = newTD(tr, "", "");
		var fd = newFIELD(td, "right."+i, "", 50, right);
		fd.setAttribute("onchange", "setSourceAt("+ i + ")");
		var img = newIMAGE(td, "/expandIcon", "./remove-field.png", "");
		img.setAttribute("onclick", "removeSource(" + i + ")");
		img.style.verticalAlign = "bottom";
		img.style.height = "14px";
        img.style.position = "relative";
        img.style.bottom = "5px";
        img.style.marginLeft = "5px";
	}
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "チェックを入れると「左辺の文字列」を含む対象行を「右辺の文字列のみ」に置換します ");
	tr.style.fontSize = "9pt";
	td.style.textAlign = "right";
	td.setAttribute("colspan", "2");
	var bt = newBUTTON(td, "", "追加");
	bt.setAttribute("onclick", "addSource()");
	var bt = newBUTTON(td, "", "確定");
	bt.setAttribute("onclick", "saveTable()");
}

function openPreference(){
	// 初期設定パネルを開く
    var panel = new FloatPanel("_floatPanel", 20, 100, 700, "初期設定パネル");
    var elm = panel.contents;
    elm.style.backgroundColor = "#ffe";
    elm.style.borderRadius = "10px";
	var tbl = newTABLE(elm, "");
    
	var tr = newTR(tbl, "", "");
	var td = newTD(tr, "", "");

	// ポップアップメニュー
    var div = newDIV(td, "");
    var sp = newSPAN(div, "");
	var array = ["","主訴","診療内容"];
	var pu = newPopupMenu(sp, "tablePop", array, "");
	pu.setAttribute("onchange", "getTable()");

    var sp = newSPAN(div, "");
    sp.style.paddingLeft = "10px";
    var im = newIMAGE(sp, "/expandIcon", "./zoom.png", "?");
    im.style.height = "15px";
    im.style.position = "relative";
    im.style.top = "3px";
    im.setAttribute("onclick", "putWindowSize()");

    // 変換用フィールド
    var div = newDIV(td, "tableContentsArea");
}
