
/////
///// 患者ごとの記述を司るクラス
/////

///// 以下は chart.js でしか使わないので dataCentar.js には収容しない

var _addPageDateTime;
function setAddPageDateTime(dateTime){
    _addPageDateTime = dateTime;
}
function addPageDateTime(){
    // ページ追加すべき日時を返す
    return _addPageDateTime;
}

var _isReserved;
function setIsReserved(status){
    _isReserved = status;
}
function isReserved(){
    // 予約ページであるか否かを返す
    return _isReserved;
}

function editorElementForTag(tag){
    // tag に相当する 入力欄 エレメントを返す
    var elm = window.top.noa.document.getElementById(tag + ".value");
    if (elm)
        return elm;
    else
        return window.top.tools.document.getElementById(tag + ".value");
}

function valueElementForTag(dateTime, tag){
    // dateTime, tag に相当する 値表示欄 エレメントを返す
    var elm = window.top.noa.document.getElementById(dateTime+"."+tag+".val");
    if (elm)
        return elm;
    else
        return window.top.tools.document.getElementById(dateTime+"."+tag+".val");
}



//////////////////////////////////////////////
///// マルチスレッド ////////////////////////////

function WKGetPage(owner, patientId, dateTime){
    // WK で始まる関数名は multi thread
    // Worker を使いマルチスレッドで 基本情報ページを更新
    // DB とのやりとりは getPageWorker.js で設定
    var obj = new Object();
    obj["owner"] = owner;
    obj["patientId"] = patientId;
    obj["dateTime"] = dateTime;
    var noaString = encodeObject(obj);
    var worker = new Worker('./getPageWorker.js');
    worker.postMessage(noaString); // ### worker に命令書 noaString を送る ###
    
    worker.onmessage = function (event) {
        // ### worker の処理したデータを受け取る ###
        var answer = event.data; // ### worker からの返答 ###

        openBasicPage(answer);
    }
}

///// マルチスレッド ////////////////////////////
//////////////////////////////////////////////

///////////////////////////////////////////////////////
///// PAGE ////////////////////////////////////////////

function openBasicPage(answer){
    // 基本情報ページを開く
    var array = answer.split("<SEPARATOR>");
    if (array.length > 1){
        var obj = JSON.parse(array[1]);
        //console.log("obj->", encodeObject(obj)); //##
        
        setAddressObj(obj.addressSection);
        setBasicObj(obj.basicSection);
        setMaritalObj(obj.maritalSection);
        setHealthInsuranceObj(obj.healthInsurance);
        setPublicInsuranceObj(obj.publicInsurance);
        setUniversalObj(obj.universalSection);
        
        // 注意事項を表示
        showCaution();
        
        // 「...のカルテを開きつつあります」のメッセージを消去
        document.getElementById("alertArea").innerHTML = "";
        
        // 基本情報を tools の base 領域に表示
        var tools = window.top.tools;
        
        tools.initBasicPage();
    } else { // ERROR
        alert("== openBasicPage->"+answer); //##
    }
}

function toggledInOrOut(answer){
    // 入院ステータスがページヘッダーやカレンダーに反映するよう画面再描画
    window.location.reload(true);
}
function toggleInOrOut(elm){
    // 入院・入院外を設定
    var status;
    if (elm.innerHTML == "入院"){
        elm.innerHTML = "　　";
        elm.setAttribute("class", "outPatient");
        status = 0;
    } else {
        elm.innerHTML = "入院";
        elm.setAttribute("class", "inPatient");
        status = 1;
    }
    
    // 最新ページの入院ステータスを記憶：put_page() で参照される
    setCurrentInPatient(status);
    
    // status を DB に格納する
    var hid = hospitalId();
    var pid = patientId();
    var dtime = currentDate();
    var container = new Array();
    container["ProgressSection.status"] = status;
    
    put_page(owner(), hid, pid, dtime, timeLimit(), container, toggledInOrOut);
}

function openPage(dateTime, isActive){
    // dateTime のページを生成
    var elm = document.getElementById(dateTime + ".page");
    elm.innerHTML = "";
    
    // PAGE を生成 ===============================================
    var patient = new Object();
    // ### 名前は受診日と連携させるため ProgressSection に読み込まれている ###
    var obj = valueForTag("ProgressSection.patientKanjiName", dateTime);
    patient.kanjiName = (obj && obj.value) ? obj.value : "";
    var obj = valueForTag("ProgressSection.patientKanaName", dateTime);
    patient.kanaName = (obj && obj.value) ? obj.value : "";
    patient.birthDate = birthDate();
    
    var page = new Page(elm, patient, dateTime, cellFontSize());
    
    if (isActive){
        elm.setAttribute("class","currentPage");
        
        // 他にアクティブなページがあればインアクティブにする
        if ((_activeDate) && (_activeDate != dateTime))
            openPage(_activeDate); // インアクティブにする
        _activeDate = dateTime;
        
        // Agent データ・オブジェクトを生成し記憶
        var agt = new Object();
        agt.patientId = patientId();
        agt.patientKanjiName = patientKanjiName();
        agt.entryDate = dateTime;
        // 複数施設・ユーザで使う場合、以下の再設定が必要
        agt.hospitalId = hospitalId();
        agt.hospitalName = hospitalName();
        agt.owner = owner();
        setAgent(agt);
        
        // 祝日リストを読み込んでおく
        var year = dateTime.substr(0, 4);
        getHolidays(year);
    } else {
        elm.setAttribute("class","page");
    }
    
    // 付箋添付エリア =============================================
    var div = page.postItArea;
    div.setAttribute("id", dateTime + ".postItArea");
    
    // ページヘッダー ==============================================
    page.header.setAttribute("class", "pageHeadLine");
    var headerId = dateTime+".line";
    page.header.setAttribute("id", headerId);
    page.header.setAttribute("onclick", "openPage('" + dateTime + "','true')");
    setInfoTip(headerId, "クリックで基本情報を表示"); // INFO
    // 入院・入院外
    page.inPatientArea.setAttribute("id", "inPatientArea");
    setInfoTip("inPatientArea", "入院・入院外モード切替え"); // INFO
    page.inPatientArea.setAttribute("onclick", "toggleInOrOut(this)");
    if (isInPatient(dateTime)){
        page.inPatientArea.innerHTML = "入院";
        page.inPatientArea.setAttribute("class", "inPatient");
    } else {
        page.inPatientArea.innerHTML = "　　";
        page.inPatientArea.setAttribute("class", "outPatient");
    }
    
    // 注意事項表示エリア ==========================================
    var div = newDIV(page.toolArea, dateTime + ".cautionArea");
    
    // 編集ボタン・アイコンギャラリー ================================
    if (isWritable() > 0){ // 編集ボタン・アイコンギャラリーを表示
        var div = newDIV(page.toolArea, "");
    }
    
    // 編集可/不可スライダーを表示
    div.setAttribute("class", "clearfix");
    var dvl = newDIV(div, dateTime + "readWriteMarder/left-side");
    dvl.style.paddingLeft = "0"; // left-side の margin を変更
    dvl.style.width = "200px";
    dvl.style.height = "18px"; // これがないと right-side と重なってしまう
    showReadWriteMarker(dvl, isActive, dateTime);
    // アイコンギャラリーを表示
    var dvr = newDIV(div, "/right-side");
    dvr.style.paddingRight = "0";
    dvr.style.marginLeft = dvl.style.width; // これがないと left-side と重なってしまう
    dvr.style.marginTop = "5px";
    dvr.style.height = "20px"; // これがないと left-side と重なってしまう
    showPageIcons(dvr, isActive);
    if (stealthMode()){
        dvr.setAttribute("class", "hidden-bar");
    }
    
    // BODY ====================================================
    var elm = page.body  
    var array = layoutForMode(_progress_);
    for (num in array){
        var cell = array[num];
        cell.editorIsOpen = false; // 中途でコケてゾンビ化した editorIsOpen を一掃
        if (cell.hitAndRun * 1) continue; // 非表示セルをスキップ
        
        openCell(elm, cell, dateTime, isActive);
    }
    
    if (isActive){
        // 本日以外のアクティブ・ページを開く場合に呼ばれる
        // polling 実行時のハート・ビートを表示するエリア
        var div = newDIV(elm, "heartBeatArea");
        div.innerHTML = noa_version();
        div.style.textAlign = "right";
        div.style.padding = "10px 20px 0 0";
        div.style.fontSize = "9pt";
        div.style.color = "#aaa";
        // 基本情報を読込中のメッセージ表示した後、基本情報を表示
        var elm = window.top.tools.base;
        if (elm){
            elm.innerHTML = "";
            var sp = newSPAN(elm, "alert");
            sp.innerHTML = "読込中...";
        }
        
        // 基本情報を取得し表示：マルチ・スレッドを使う
        setCurrentDate(dateTime);
        WKGetPage(owner(), patientId(), dateTime);
    }
}

function removedPage(answer){
    // ページ削除を画面に反映させる
    openChart(patientId(), null);
}
function removePage(dateTime){
    // dateTime のページを削除
    if (isWritable() == 0){
		alert("アクセス・コード: "+userCode()+" なのでページ削除権限がありません");
        return;
    } else if (isWritable() == 2) { // 自分のデータのみ編集可
        var ownerObj = valueForTag("ProgressSection.owner");
        if (owner() != ownerObj.value){
            alert(ownerObj.value+" のデータの編集権限がありません");
            return;
        }
	}
    
    if (confirm(dateTime + " のページを削除しますか")){
		setCurrentDate("");
        var args = new Object();
        args["owner"] = owner();
        args["hospitalId"] = hospitalId();
		args["patientId"] = patientId();
		args["entryDate"] = dateTime;
		args["timeLimit"] = timeLimit();

        NRCall("REMOVE_PAGE", args, removedPage);
	}
}
function removeTodayPage(){
    // レッド・マイナス・アイコンから起動される
    removePage(currentDate());
}

function addedPage(answer){
    // 新規ページを追加
    openChart(patientId(), null);
}
function addPage(dateTime){
    // dateTime の新規ページを追加
    if (!patientId()){
        alert("カルテが読込まれていません");
    } else if (isWritable() == 0){
		// アクセスコード４（参照・修正・削除許可）以外ならページ追加をしない
		alert("アクセス・コード: "+userCode()+" なので新規ページ追加権限がありません");
    } else if (isSameDate(currentDate(), dateTime)){
		// 同じ日付のページがすでに存在する
        if (secondsBetween(currentDate(), dateTime) < 60*60) return; // 前回記述から１時間以内なら何もしない
		if (confirm(dateTime + " と同じ日付のページ（ "+currentDate()+" ）はすでにあります。同日再診として追加しますか？")){
            add_page(dateTime);
		}
	} else {
		// dateTime のページが存在しなかった
		if (isSameDate(dateTime, today())){
			// dateTime が本日なら、新規ページを追加
            add_page(dateTime);
		} else {
			// dateTime が本日ではなかった
			if (confirm(dateTime + " は本日ではありません。追加しますか？")){
                add_page(dateTime);
			}
		}
	}

    
    function add_page(dateTime){
        // dateTime のページを追加
        setCurrentDate(dateTime);

        var templateTitle = newPageTemplate(); // localStorage.js
        if (templateTitle){
            // ページ・テンプレートを反映したページを追加
            addPageWithTemplate(templateTitle);
        } else {
            // 白紙のページを追加
            var hid = hospitalId();
            var pid = patientId();
            var container = new Array();
            container["ProgressSection.pageHeader"] = "";
            
            put_page(owner(), hid, pid, dateTime, timeLimit(), container, addedPage);
        }
    }
}

var _templateTitle;
function addPageWithTemplateDone(answer){
    // ページ・テンプレートを反映したページを追加
    var array = JSON.parse(answer);
    setTemplateMenu(array);
    
    //console.log("addPageWithTemplateDone", encodeObject(array)); //##
    
    addPageWithTemplate(_templateTitle);
}
function addPageWithTemplate(templateTitle){
    // ページ・テンプレートを反映したページを追加
    // すでにページ・テンプレートが記憶されていればサーバへ取りに行かない
    var obj = groupTemplateObjectForTitle(templateTitle);
    if (obj && obj.value){
        // obj.value に tag 毎にセットする値が入っている
        var hid = hospitalId();
        var dateTime = currentDate();
        var val = transferToCR(obj.value); // HTML 改行を全て "\n" に変換
        var container = decodeObject(val);
        
        put_page(owner(),hid,patientId(),dateTime,timeLimit(),container,addedPage);
    } else {
        _templateTitle = templateTitle;
        
        var args = new Object();
        args["owner"] = owner();
        NRCall("GET_MENU_TEMPLATE", args, addPageWithTemplateDone);
    }
}

function addTodayPage(){
    // グリーン・プラス・アイコンから起動される
    openAddPagePanel(todayAndTime());
}

///// PAGE ////////////////////////////////////////////
///////////////////////////////////////////////////////


function removeCheck(){
    // 無条件に編集不可のチェックをはずす
    var bid = "pageReadOnlyStatus";
    var bt = showOnOff(bid, " ", 0, "getOnOff");
}

function showOnOff(id, label, status, receiver){
    // on / off button 表示
    var div = elmFor(id);
    div.innerHTML = "";
    
    var btn = newDIV(div, "onOffButton/on-button");
    btn.innerHTML = "";
    setInfoTip("onOffButton", "編集可・不可へ切り替え"); // INFO
    if (status > 0){
        btn.style.backgroundColor = "#fbb";
        btn.style.padding = "0 0 0 12px";
       var action = "showOnOff('" + id +"','" + label + "','0','" + receiver + "')";
        eval(receiver + "(0)");
    } else {
        btn.style.backgroundColor = "#cff";
        btn.style.padding = "0 12px 0 0";
        var action = "showOnOff('" + id +"','" + label + "','1','" + receiver + "')";
        eval(receiver + "(1)");
    }
    btn.setAttribute("onclick", action);
    
    var bt = newDIV(btn, "/child-button");
    bt.innerHTML = label;
    bt.style.padding = "0 8px";
    bt.style.color = (status > 0) ? "#aaa" : "#555";
}
function showReadWriteMarker(elm, isActive, dateTime){
    // ページの読書状態を表すコントローラ表示
    elm.innerHTML = "";
    if (isActive){
        if (isSameDate(dateTime, today())){
            // 本日なら無条件に readOnly を否定
            setIsReadOnly(false, dateTime);
        } else {
            // 本日以外なら setIsReadOnly() の判断に任せる
            setIsReadOnly(isReadOnly(), dateTime);
            var bid = "pageReadOnlyStatus";
            var sp = newSPAN(elm, bid);
            
            if (isReadOnly())
                var bt = showOnOff(bid, " ", 1, "getOnOff");
            else
                var bt = showOnOff(bid, " ", 0, "getOnOff");
        }
    }
}

function showPageIcons(elm, isActive){
    // ページ・ヘッダーにアイコン・ギャラリーを表示・非表示
    if (isActive){
        var array = toolMenus();
        for (num in array){
            var cell = array[num];
            
            if (cell.menuType * 1 != _page) continue;
            if (cell.disabled * 1) continue;
            if (cell.subTitle * 1) continue;
            
            // メニュー項目を生成
            var sp = newSPAN(elm, cell.id);
            sp.style.marginLeft = "15px";
            sp.style.fontSize = "10pt";
            // cell.editor に infoTip に表示する内容が入っている
            setInfoTip(cell.id, cell.editor); // HELP
            
            if (cell.icon){
                // ICON があれば ICON を表示
                var img = newIMAGE(sp, "", cell.icon, "icon");
                img.style.height = "15px";
                var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
                img.setAttribute("onclick", action);
                img.setAttribute("class", "expandIcon");
            } else {
                // アンカー表示
                var a = newA(sp, cell.label, "#", "");
                if (cell.url){
                    var action = "kickMenuCell('"+cell.url+"','"+cell.window+"',this)";
                    a.setAttribute("onclick", action);
                }
            }
        }
    } else {
        elm.innerHTML = "";
    }
}

/////////////////////////////////////////////////////////
///// CAUTION ///////////////////////////////////////////

var _caution;
function setCaution(st){
    _caution = st;
}
function caution(){
    // 注意事項を返す
    return _caution;
}

function allergyString(){
    // アレルギー欄の文字列を返す
    var obj = valueForTag("BasicSection.allergy", currentDate());
    if (!obj) return null;
    var val = obj.value;
    if (trim(val).length == 0) return null;
    if (val == "なし") return null;
    
    return val;
}
function cautionString(){
    // 注意事項の文字列を返す
    var obj = valueForTag("ProgressSection.note", currentDate());
    
    if (!obj) return null;
    var val = obj.value;
    if (trim(val).length == 0) return null;
    
    return val;
}

function showCaution(){
    // アレルギー・注意事項を表示
    var obj = postItForDate(currentDate());
    var hasPostIt = (obj && (obj.type < 2)) ? true : false;
    closePostIt(); // 以前の付箋を一旦消しておく
    if (hasPostIt){
        var div = elmFor(currentDate() + ".postItArea");
        div.innerHTML = "";
        div.style.marginBottom = "10px";
        var bt = newDIV(div, "");
        var sp = newSPAN(bt, "postIt");
        
        // 付箋を表示
        sp.innerHTML = "付箋";
        var obj = postItForDate(currentDate());
        switch (obj.color * 1){ // 付箋色により表示
            case 1: sp.setAttribute("class", "postItTagBlue"); break;
            case 2: sp.setAttribute("class", "postItTagYellow"); break;
            case 3: sp.setAttribute("class", "postItTagRed"); break;
            default: sp.setAttribute("class", "postItTagGreen"); break;
        }
        
        // 付箋の位置を移動
        sp.style.left = (noCalendar() > 0) ? "0" : "-30px";

        sp.setAttribute("onclick", "showPostItForce()");
    }
    
    var div = elmFor(currentDate() + ".cautionArea");
    if (div) div.innerHTML = "";
    var allergy = (showAllergy()) ? allergyString() : null;
    var caution = cautionString();
    setCaution(caution); // 注意事項を記憶しておく
    if (allergy || caution){
        // ラベル
        var dv = newDIV(div, "/clearfix");
        var bt = newDIV(dv, "");
        bt.style.display = "inline";
        bt.style.float = "left";
        bt.style.width = "65px";
        bt.style.paddingLeft = "5px";
        bt.style.fontSize = "10pt";
        bt.innerHTML = "注意";
        // 内容表示エリア
        var ldiv = newDIV(dv, "");
        ldiv.style.display = "inline";
        ldiv.style.float = "left";
        ldiv.style.fontSize = "11pt";
        // アレルギー
        if (allergy){
            var adiv = newDIV(ldiv, "");
            adiv.innerHTML = allergy;
            adiv.style.color = "#f00";
        }
        // 注意内容
        if (caution){
            var cdiv = newDIV(ldiv, "cautionF");
            cdiv.innerHTML = caution;
            cdiv.style.paddingLeft = "5px";
            cdiv.style.fontSize = "10pt";
            cdiv.contentEditable = true; // TEXT を編集可能状態にする
            cdiv.setAttribute("onBlur", "saveCaution()");
        }
    }
}

function savedCaution(answer){
    //alert("savedCaution->"+answer); //##
    var obj = JSON.parse(answer);
    var tag = 'ProgressSection.note';
    var note = obj[tag];
    
    // 記憶したデータも更新しておく
    setValueForTag(tag, currentDate(), note);
    
    showCaution();
}
function saveCaution(){
    // 重要事項をサーバへ保存
    var cautionSt = elmFor("cautionF").innerText;
    
    if (cautionSt == caution()) return;
    
    if (confirm("注意事項が修正されています。サーバへ保存しますか")){
        // 編集内容をサーバへ保存
        var hid = hospitalId();
        var pid = patientId();
        var date = currentDate();
        var tag = 'ProgressSection.note';
        var container = new Object();
        container[tag] = cautionSt;
        
        put_page(owner(), hid, pid, date, timeLimit(), container, savedCaution);
    } else {
        // 編集前に戻す
        elmFor("cautionF").innerHTML = caution();
    }
}

function fixCaution(){
    // 注意事項をサーバへ保存
    var st = elmFor("inputF").value;
    if (st.length > 0){
        closeFloatPanel();
        
        // 編集内容をサーバへ保存
        var hid = hospitalId();
        var pid = patientId();
        var date = currentDate();
        var tag = 'ProgressSection.note';
        var container = new Object();
        container[tag] = st;
        put_page(owner(), hid, pid, date, timeLimit(), container, savedCaution);
    }
}
function showCautionEditor(){
    // 注意事項入力パネルを開く：TOOL MENU などから開く
    var w = 400;
	var x = 150; // 表示するx座標
	var y = 150; // 表示するy座標
    var action = "openHelp('./cautionHelp.html')";
    var panel = new FloatPanel("_floatPanel", x, y, w, "注意事項入力パネル", action);
    if (!panel) return;
    var elm = panel.contents;
    elm.style.padding = "8px";
    
    // 注意事項入力欄
    var div = newDIV(elm, "");
    var st = (cautionString()) ? cautionString() : "";
    var fd = newFIELD(div, "inputF", "", 50, st);
    fd.focus();
    fd.setAttribute("onchange", "fixCaution()");
    
    // 検索ボタン
    var bt = newSPAN(div, "/fixButton");
    bt.innerHTML = "確定";
    bt.setAttribute("onclick", "fixCaution()");
}

///// CAUTION ///////////////////////////////////////////
/////////////////////////////////////////////////////////


function makeCalendar(answer){
    // calendar を生成
    var array = JSON.parse(answer);
    openCalendar(array); // calndar.js
}

var _activeDate;
function openPages(answer){
    // サーバから得られた ProgressSection データで各ページを生成
    var obj = JSON.parse(answer);
    setPatientTable(obj.patientTable);
    setNameObj(obj.nameSection);
    setProgressObj(obj.progressSection);
    setFrontObj(obj.frontTable);
    setPostItObjects(obj.postIt);
    _activeDate = null; // 初期化して置かなければならない
    
    // ウインドー・タイトルに 名前 を表示
    setPatientName(patientKanjiName()); // 最新ページの name を記憶
    window.top.document.title = patientKanjiName();
    
    // 全てのページを表示
    var div = elmFor("contents");
    div.innerHTML = "";
    
    var hasRecord = false; // obj にレコードが存在するか否か
    var hasTodayPage = false;

    var array = history(); // ### 自分の記述した過去履歴だけを対象とする ###
    for (num in array){
        var dateTime = array[num];
        
        if (num == 0){
            // 最新ページの入院ステータスを記憶
            var status = (isInPatient(dateTime)) ? 1 : 0;
            setCurrentInPatient(status);
        }

        // 読み書きが自分のデータに限定されている場合の処理
        if (isLimited() == 1){
            var ownerObj = valueForTag("ProgressSection.owner", dateTime);
        }

        var dv = newDIV(div, dateTime + ".page");

        // ここで生成した dv にページを表示：最初のページのみアクティブで basicPage も表示
        var isActive = (num == 0) ? true : false;
        openPage(dateTime, isActive); 
        
        if (isSameDate(dateTime, today())) hasTodayPage = true;
        hasRecord = true;
    }
    
    // 最終受診日を currentDate() に設定
    if (array.length > 0) setCurrentDate(array[0]);
    
    // 基本情報を読込中のメッセージ表示
    var elm = window.top.tools.base;
    elm.innerHTML = "";
    var sp = newSPAN(elm, "alert");
    sp.innerHTML = "読込中...";
    
    if (! hasRecord){
       console.log("自分の所管するレコードがなかったので addPage()"); //###
        // カルテに１頁もない場合は自動的に頁追加
       addPage(todayAndTime());  // Ajax を起動するので openBasicPage() 実行しない
    } else if (addPageDateTime() && !hasTodayPage){
        console.log("待受リストや待受タグから黄色タグが開かれ、本日のページがないので addPage()"); //###
        // 待受リストや待受タグから黄色タグが開かれ、本日のページがない場合のみ
        if (isReserved())
            openAddReservedPagePanel(patientId(), addPageDateTime());
        else
            addPage(addPageDateTime()); 
    } else {
        // console.log("カレンダーを開く"); //###
        var args = new Object();
        args["patientId"] = patientId();
        args["dateTime"] = currentDate();
        NRCall("GET_BOOKING", args, makeCalendar);
    }
}


//////////////////////////////////////////////////////////////////////////
///// patient_id の Chart を開く：SHELL から使えるメソッド ////////////////////

function openChart(patient_id, addPageDate){
    // patient_id のカルテを開く：addPageDate があればページ追加
    // addPageDate が日付形式ならその日付ページを追加、そうでなければ本日のページを追加
    if (!patient_id || (patient_id.length < 8)){
        if (patientId())
            patient_id = patientId();
        else
            return;
    }
    
    // 「検索」「ページ追加なしの予約タグ」がこの型式
    setAddPageDateTime(null);
    setIsReserved(false);

    if (addPageDate != null){
        // addPageDate が日時フォーマットなら、その日時のページを追加
        // 日時フォーマットでなければ現在日時のページを追加
        switch (isDate(addPageDate)){
            case 0: // addPageDate が日付形式でなかった：「履歴」「待受」がこの型式
            case 1: // addPageDate が年月日だけだった
                setAddPageDateTime(todayAndTime()); // 現在日時のページを追加
                break;
            default: // addPageDate が年月日時分秒だった
                // 「ページ追加ありの予約タグ」がこの型式
                setIsReserved(true);
                setAddPageDateTime(addPageDate); // 予約日のページを追加
                break;
        }
    }

    // workArea の検索リストから起動されることがあるので workArea をクリア
    elmFor("workArea").innerHTML = "";
    elmFor("calendarArea").innerHTML = "";
    
    setPatientId(patient_id); // patientId を記憶
    
    var elm = elmFor("patientIdArea");
    elm.innerHTML = "";
    var sp = newSPAN(elm, "");
    sp.innerHTML = patient_id;
    sp.style.paddingRight = "10px";
    sp.style.fontSize = "15pt";

    // 作業中であることを示すメッセージ
    elmFor("contents").innerHTML = "";
    elmFor("alertArea").innerHTML = patient_id + " のカルテを開きつつあります...";
    
    // Ajax がカブらないようシリアルに実行
    get_pages(owner(), patient_id, openPages);
}

function enableReadWriteMarker(dateTime){
    // 編集不可スライダーを編集可にする
    // ### script で使われる ###
    if (!dateTime) dateTime = currentDate();
    
    // ステータスを編集可に設定
    setIsReadOnly(false, dateTime);
    
    // スライダーを編集可の表示にする
    var dv = elmFor(dateTime + "readWriteMarder");
    dv.innerHTML = "";
    var bid = "pageReadOnlyStatus";
    var sp = newSPAN(dv, bid);
    var bt = showOnOff(bid, " ", 0, "getOnOff");
}

