<?php
	
    require_once '../TCPDF/tcpdf.php';
    
    ////////////////////////////////
    // WRITE THIS FILE AS "S-JIS" //
    ////////////////////////////////
    
    function shohouFormat($x, $y, $w, $value, $pdf){
        // 処方内容を $value からテキスト形式に変換して記述
        $x += 8;
        $y += 5;
        $w -= 10;
        $h = 5;
        $pdf->SetFont('kozminproregular', '', 9);
        $pdf->SetXY($x, $y);
        $pdf->SetLeftMargin($x);
        
        $records = explode("<BR/>", $value);
        $count = count($records);
        $results = array();
        for ($i=0; $i < $count; $i++){
            $ln = trim($records[$i]);
            if (strlen($ln) == 0) continue;
            
            // 行頭に * があるものは後発品への変更不可
            if (strpos($ln, "*") === 0)
                $ln = "*　".substr($ln, 1);
            else
                $ln = "　　$ln";
            $pdf->MultiCell($w, $h, $ln, 0, 'L');
        }
    }
    
    function wareki($currentDate){
        if (strlen($currentDate) == 0) return "　　　　年　 月　 日";
        
        $ary = explode(" ", $currentDate);
        $array = explode("-", $ary[0]);
        $yy = $array[0] * 1;
        $mm = $array[1] * 1;
        $dd = $array[2] * 1;
        if ($yy > 2018){
            $yy -= 2018;
            $nengou = "令和".$yy;
        }
        else if ($yy > 1988) {
            $yy -= 1988;
            $nengou = "平成".$yy;
        }
        else if ($yy > 1925) {
            $yy -= 1925;
            $nengou = "昭和".$yy;
        }
        else if ($yy > 1911) {
            $yy -= 1911;
            $nengou = "大正".$yy;
        }
        else {
            $yy -= 1867;
            $nengou = "明治".$yy;
        }
        return $nengou."年".$mm."月".$dd."日";
    }
    
    function kikanDate($currentDate){
        $ary = explode(" ", $currentDate);
        $array = explode("-", $ary[0]);
        $yy = $array[0] * 1;
        $mm = $array[1] * 1;
        $dd = $array[2] * 1;
        $time = gmmktime(0,0,0,$mm,$dd,$yy);
        $date = getdate($time + 60*60*24*3);
        $heisei = $date[year] - 2018;
        return "令和".$heisei."年".$date[mon]."月".$date[mday]."日まで";
    }
    
    function insFrame($x, $y, $w, $h, $pdf, $labelWidth, $label, $value){
        $pdf->SetFont('kozminproregular', '', 6.5);
        $pdf->SetXY($x, $y);
        $pdf->Cell($labelWidth, $h, $label, 1, 0, 'L');
        
        $pdf->SetFont('kozminproregular', '', 9);
        $pdf->SetXY($x + $labelWidth, $y);
        $pdf->Cell($w - $labelWidth, $h, $value, 1, 0, 'C');
    }
    
    function stamp($x, $y, $pdf){
        $pdf->Rect($x, $y, 4, 4, '');
        $pdf->SetFont('kozminproregular', '', 6);
        $pdf->Text($x, $y+0.5, "印");
    }
    
    function checkBox($x, $y, $pdf, $checked){
        // チェックボックスを描く
        $pdf->Rect($x, $y, 3, 3, '');
        
        if ($checked * 1 > 0){
            $pdf->SetLineWidth(0.3);
            $pdf->Line($x+1, $y+0.5, $x+1, $y+2.5);
            $pdf->Line($x+1, $y+2.5, $x+2.5, $y+1);
            $pdf->SetLineWidth(0.2);
        }
    }
    
    
    
    $info = $_GET['info']; $info = stripslashes($info);
    $doctorName = $_GET['doctorName']; $doctorName = stripslashes($doctorName);
    $value = $_GET['value']; $value = stripslashes($value);
    
    // JSON 形式の文字列を連想配列に変換
    $infoObj = json_decode($info, true);
    
    // 電子処方箋から送られたパラメータを専用変数に展開
    $userName = $infoObj["loginName"];
    $currentDate = $infoObj['currentDate'];
    $name = $infoObj["kanjiName"];
    $furigana = $infoObj["furigana"];
    $sex = $infoObj["sex"];
    $hospitalName = $infoObj["hospitalName"];
    $hospitalAddress = $infoObj["hospitalAddress"];
    $hospitalPhone = $infoObj["hospitalPhone"];
	
    $todoufukenBangou = $infoObj["todoufukenBangou"];
    $tensuuhyouBangou = $infoObj["tensuuhyouBangou"];
    $iryoukikanCode = $infoObj["iryoukikanCode"];
	
    $birthDay = wareki($infoObj["birthDay"]);
    $koufubi = wareki($currentDate);
    $kikan = kikanDate($currentDate);
    $shubetsu = $infoObj["shubetsu"];
    $kubun = $infoObj["family"];
    
    // 公費負担がある場合は公費負担の負担率を優先して採用
    $rate = $infoObj["paymentRatio"];
    if ($rate * 1 < 10){ // 自費なら自費を使う
        // 自費以外なら健保の負担率を使う
        $kouhiRatio = trim($infoObj["kouhiFutanRatio"]);
        // 公費負担があるなら公費負担を優先して使う
        if (strlen($kouhiRatio) > 0)
            $rate = $kouhiRatio;
    }
    
    $hokenshaBangou = $infoObj["hokenshaBangou"];
    $kigou = $infoObj["kigou"];
    $bangou = $infoObj["bangou"];
    $kouhiFutanBangou = $infoObj["kouhiFutanBangou"];
    $jyukyuuBangou = $infoObj["jyukyuuBangou"];
    $doctorName = $doctorName;

    $inquiry = $infoObj["inquiry"];
    $info = $infoObj["info"];

    $prescription = $value;
    
    
    
    $pdf = new TCPDF('P', 'mm', array(180, 256)); // B5
    $topMargin = 0;
    $leftMargin = 26;
    $width = 125;
    $contentsHeight = 85; //65;
    $labelWidth = 17;
    $labelFontSize = 8;
    
    // default でヘッダー罫線がでることを防止: AddPage() より前に実行
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);

    $pdf->Open();
    $pdf->AddPage();
    
    
    // TITLE
    $y = $topMargin;
    $pdf->SetXY(0, $y);
    $pdf->SetFont('kozminproregular', 'B', $labelFontSize+3);
    $pdf->Cell($width-20, 5, "処　方　箋", 0, 0, 'C');
    $pdf->SetXY(50, $y);
    $pdf->SetFont('kozminproregular', 'B', $labelFontSize);
    $pdf->Cell($width, 5, "（この処方箋は、どの保険薬局でも有効です）", 0, 0, 'C');
    
    // Public Ins
    $y += 6; //8;
    $frameTopY = $y;
    $height1 = 7;
    insFrame($leftMargin, $y, $width/2-1, $height1, $pdf, $labelWidth, "公費負担番号", $kouhiFutanBangou);
    
    // Public Ins
    $y += $height1;
    insFrame($leftMargin, $y, $width/2-1, $height1, $pdf, $labelWidth, "受給者番号", $jyukyuuBangou);
    
    // ふりがな
    $height2 = 6;
    $y += $height2;
    $pdf->SetFont('kozminproregular', '', 7);
    $pdf->SetXY($leftMargin + $labelWidth, $y);
    $pdf->Cell($width/2 - $labelWidth, $height2+1, $furigana, 0, 0, 'C');
    
    // 氏名
    $height3 = 10;
    insFrame($leftMargin, $y+1, $width/2-1, $height3, $pdf, $labelWidth, "氏名", "");
    $pdf->SetXY($leftMargin + $labelWidth, $y);
    $pdf->Cell($width/2 - $labelWidth, $height2+10, $name, 0, 0, 'C');
    $y += 1;
    
    // 生年月日
    $y += $height3;
    $pdf->SetXY($leftMargin, $y);
    $pdf->SetFont('kozminproregular', '', $labelFontSize);
    $pdf->Cell($labelWidth, $height2, "生年月日", 1, 0, 'L');
    $pdf->SetXY($leftMargin+$labelWidth, $y);
    $pdf->SetFont('kozminproregular', '', $labelFontSize + 1);
    $pdf->Cell($width/2-$labelWidth*2-1, $height2, $birthDay, 1, 0, 'C');
    
    $pdf->SetXY($leftMargin+$labelWidth+$width/2-$labelWidth*2-1, $y);
    $pdf->Cell($labelWidth, $height2, $sex, 1, 0, 'C');
    
    // 保険区分
    $height4 = 9;
    $y += $height2;
    $pdf->SetXY($leftMargin, $y);
    $pdf->SetFont('kozminproregular', '', $labelFontSize);
    $pdf->Cell($labelWidth, $height2, "保険区分", 1, 0, 'L');
    $pdf->SetXY($leftMargin+$labelWidth, $y);
    $pdf->SetFont('kozminproregular', '', $labelFontSize + 1);
    if (strlen($kubun) > 0)
	$hokenShubetsu = $shubetsu."：".$kubun;
    else
	$hokenShubetsu = $shubetsu;
    $pdf->Cell($width/2-$labelWidth*2-1, $height2, $hokenShubetsu, 1, 0, 'C');
    
    // 患者負担割
    $x = $leftMargin+$labelWidth+$width/2-$labelWidth*2-1;
    $pdf->SetXY($x, $y);
    $pdf->SetFont('kozminproregular', '', $labelFontSize + 1);
    $pdf->Cell($labelWidth, $height2, "$rate 割", 1, 0, 'C');
    
    // 交付年月日
    $y += $height2;
    insFrame($leftMargin, $y, $width/2-1, $height2, $pdf, $labelWidth, "交付年月日", $koufubi);
    
    // 使用期間
    $y += $height2;
    $pdf->SetXY($leftMargin, $y);
    $pdf->SetFont('kozminproregular', '', $labelFontSize);
    $pdf->Cell($labelWidth, $height4, "使用期間", 1, 0, 'L');
    
    $pdf->SetLineWidth(0.2);
    $pdf->Rect($leftMargin, $y, $width/2-1, $height4, '');
    $pdf->SetXY($leftMargin+$labelWidth, $y);
    $pdf->SetFont('kozminproregular', '', $labelFontSize);
    $pdf->Cell($width/2-$labelWidth, $height4-3, $kikan, 0, 0, 'C');
    $pdf->SetXY($leftMargin+$labelWidth-1, $y+5);
    $pdf->SetFont('kozminproregular', '', $labelFontSize - 2);
    $pdf->Cell($width/2-$labelWidth, 3, "交付日を含め４日以内に薬局へお持ち下さい", 0, 0, 'C');
    
    // 保険者番号
    $y2 = $frameTopY;
    insFrame($leftMargin+$width/2, $y2, $width/2, $height1, $pdf, $labelWidth, "保険者番号", $hokenshaBangou);
    // 記号番号
    $x2 = $leftMargin+$width/2;
    $y2 += $height1;
    $w = $labelWidth + ($width/2 - $labelWidth) / 2;
    insFrame($x2, $y2, $w, $height1, $pdf, $labelWidth, "記号・番号", $kigou);
    $pdf->SetXY($x2+$w, $y2);
    $pdf->SetFont('kozminproregular', '', $labelFontSize + 1);
    $pdf->Cell($width/2-$w, $height1, $bangou, 1, 0, 'C');
    
    // ADDRESS
    $x2 = $leftMargin+$width/2+3;
    $y2 += $height1+1;
    $adWidth = 75;
    $adHeight = 6;
    $pdf->SetXY($x2, $y2);
    $pdf->SetFont('kozminproregular', '', $labelFontSize + 1);
    $pdf->Cell($adWidth, $adHeight, $hospitalAddress, 0, 0, 'L');
    $y2 += 7;
    $pdf->SetXY($x2, $y2);
    $pdf->Cell($adWidth, $adHeight, $hospitalName, 0, 0, 'L');
    $y2 += 4;
    $pdf->SetXY($x2, $y2);
    $pdf->Cell($adWidth, $adHeight, "電話：$hospitalPhone", 0, 0, 'L');
    $y2 += 7;
    $pdf->SetXY($x2, $y2);
    $pdf->Cell($adWidth, $adHeight, "保険医：$userName", 0, 0, 'L');
    
    // 印 マークを描く
    stamp($leftMargin+$width-5, $y2, $pdf);
    
    // 使用期間
    $y2 += 3 + $height2;
    $x2 = $leftMargin+$width/2;
    $pdf->SetXY($x2, $y2);
    $pdf->SetLineWidth(0.2);
    $pdf->Rect($x2, $y2, $width/2, $height4, '');
	
    $pdf->SetFont('kozminproregular', '', $labelFontSize - 2);
    $pdf->SetXY($x2, $y2);
    $pdf->Cell($adWidth, $adHeight, "都道府県番号", 0, 0, 'L');
    $pdf->SetXY($x2+15, $y2);
    $pdf->Cell($adWidth, $adHeight, "点数表番号", 0, 0, 'L');
    $pdf->SetXY($x2+35, $y2);
    $pdf->Cell($adWidth, $adHeight, "医療機関コード", 0, 0, 'L');
    
    $pdf->SetFont('kozminproregular', '', $labelFontSize + 3);
    $y2 += 4;
    $pdf->SetXY($x2, $y2);
    $pdf->Cell($adWidth, $adHeight, $todoufukenBangou, 0, 0, 'L');
    $pdf->SetXY($x2+15, $y2);
    $pdf->Cell($adWidth, $adHeight, $tensuuhyouBangou, 0, 0, 'L');
    $pdf->SetXY($x2+35, $y2);
    $pdf->Cell($adWidth, $adHeight, $iryoukikanCode, 0, 0, 'L');
	
    // 処方内容
    $pdf-> SetFillColor(100, 220, 180);
    $x = $leftMargin;
    $y += $height4;
    $pdf->SetLineWidth(0.2);
    $pdf->Rect($x, $y, $width, $contentsHeight, '');
    shohouFormat($x, $y, $width, $prescription, $pdf);
    // 変更不可の枠線
    $pdf->Rect($x, $y, 12, $contentsHeight, ''); 
    $pdf->SetXY($leftMargin, $y+2);
    $pdf->SetFont('kozminproregular', '', 7);
    $pdf->Cell(50, 0, "変更不可", 0, 0, 'L');
    $pdf->SetXY($leftMargin + 12, $y+2);
    $pdf->SetFont('kozminproregular', '', 7);
    $pdf->Cell(50, 0, "変更不可欄に ＊ のある薬剤は「後発品へ変更不可」です", 0, 0, 'L');
    
    // 備考
    $pdf-> SetFillColor(100, 220, 180);
    $y += $contentsHeight;
    $bikouHeight = 35;
    $pdf->Rect($leftMargin, $y, $width, $bikouHeight, '');
    
    $pdf->SetXY($leftMargin, $y+1);
    $pdf->SetFont('kozminproregular', '', $labelFontSize);
    $pdf->Cell(50, 4, "備考", 0, 0, 'L');
    
    // 後発医薬品への変更
    $x2 = $leftMargin+$width*45/110;
    $y2 = $y;
    $pdf->SetFont('kozminproregular', '', $labelFontSize);
    $pdf->SetXY($x2, $y2);
    $pdf->Cell($width/2+2, 6, "以下へ記名捺印があれば後発品へ変更不可の薬剤あり", 0, 0, 'L');
    // 印 マークを描く
    stamp($leftMargin+$width-5, $y2+8, $pdf);
    $pdf->SetXY($x2, $y2+5);
    $pdf->SetFont('kozminproregular', '', $labelFontSize + 1);
    $pdf->Cell($width/2+2, 6, "保険医署名： $doctorName", 0, 0, 'L');
    
    // 保険薬局への指示
    $x2 = $leftMargin;
    $y2 = $y + 10;
    $pdf->SetFont('kozminproregular', '', $labelFontSize);
    $pdf->SetXY($x2, $y2);
    $pdf->Cell($width/2+2, 6, "保険薬局が調剤時に残量を確認した場合の対応", 0, 0, 'L');
    $x2 = $leftMargin;
    checkBox($x2+2, $y2+6, $pdf, $inquiry);
    $x2 += 5;
    $pdf->SetXY($x2, $y2+5);
    $pdf->Cell($width/2+2, 6, "医療機関へ疑義照会した上で調剤", 0, 0, 'L');
    $x2 = $leftMargin + 60;
    checkBox($x2+2, $y2+6, $pdf, $info);
    $x2 += 5;
    $pdf->SetXY($x2, $y2+5);
    $pdf->Cell($width/2+2, 6, "医療機関へ情報提供", 0, 0, 'L');
    
    // 保険者番号
    $y2 = $y + $bikouHeight - $height1 * 2;
    
    $x1 = $leftMargin;
    $w = $width/2;
    $w1 = $width*2/11;
    insFrame($x1, $y2, $w, $height1, $pdf, $w1, "調剤年月日", $kouhiFutanBangou2);
    $pdf->SetXY($x1+$w1, $y2);
    $pdf->SetFont('kozminproregular', '', $labelFontSize - 2);
    $pdf->Cell($w-25, $height1, "令和　　 　年　　 　月　　 　日", 0, 0, 'C');
    $x2 = $leftMargin + $w;
    insFrame($x2, $y2, $w, $height1, $pdf, $w1, "公費負担者番号", $kouhiFutanBangou2);
    
    $y2 = $y + $bikouHeight - $height1;
    insFrame($x1, $y2, $w, $height1, $pdf, $w1, "保険薬局薬剤師氏名", $kouhiFutanBangou2);
    // 印 マークを描く
    stamp($x2-5, $y2+2, $pdf);
    insFrame($x2, $y2, $w, $height1, $pdf, $w1, "受給者番号", $jyukyuuBangou2);
    
    $pdf->Output();
    
?>
