#!/usr/bin/env ruby
# This software is a part of NOODLYBOX.
# This software is distributed under the terms of the new BSD License.
# Copyright (c) 2008, molelord
# All rights reserved.

if (ARGV.length < 1)
    print <<EOF
Usage : mimic.rb FOOBAR.vhd
EOF
    exit 1
end

all = []
found_dcm_sp = false

file = open(ARGV[0], "r")

while line = file.gets()
    if line =~ /DCM_SP/
        line.gsub!(/DCM_SP/, "MIMIC_DCM")
        found_dcm_sp = true
    end
    all.push(line)
end
file.close

if found_dcm_sp then
    file = open(ARGV[0], "w")
    all.each do |i|
        file.print i
        if i =~ /use UNISIM.Vcomponents.ALL;/
            i.sub!(/UNISIM.Vcomponents/, "work.MIMIC_DCM_PKG")
            file.print i
        end
    end
end
