// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2008, molelord
// All rights reserved.

// '_X' means 'Negative'.

`timescale 1 ns / 1 ns

module NOODLYBOX # (
    parameter CLOCK_PERIOD = 10,
    parameter WIDTH        = 32)
(
    output wire             CS_X,
    output wire             OE_X,
    output wire             WE_X,
    output wire             BS_X,
    output wire             RDWR,
    output wire [31:0]      A,
    inout  wire [WIDTH-1:0] D,
    input  wire             CLK,
    input  wire             RESET_X);

    // 'i_' means 'internal'.
    wire  [1:8*32] i_PHASE;
    wire        i_WAKEUP = 1;

    wire        i_CS_X = 1;
    wire        i_OE_X = 1;
    wire        i_WE_X = 1;
    wire        i_BS_X = 1;
    wire        i_RDWR = 1;
    wire [31:0] i_A    = {32{1'b0}};
    wire [31:0] i_D    = {32{1'b0}};
    wire        i_HIZ  = 1;

    assign CS_X  = i_CS_X;
    assign OE_X  = i_OE_X;
    assign WE_X  = i_WE_X;
    assign BS_X  = i_BS_X;
    assign RDWR  = i_RDWR;
    assign A     = i_A;
    assign D     = i_HIZ ? {WIDTH{1'bz}} : i_D[WIDTH-1:0];

endmodule
