-- This software is a part of NOODLYBOX.
-- This software is distributed under the terms of the new BSD License.
-- Copyright (c) 2008, molelord
-- All rights reserved.

library ieee;
use ieee.std_logic_1164.all;

-- '_X' means 'Negative'.

entity NOODLYBOX is
    generic (
        CLOCK_PERIOD : time    := 10 ns;
        WIDTH        : integer := 32);
    port (
        CS_X    : out   std_logic;
        OE_X    : out   std_logic;
        WE_X    : out   std_logic;
        BS_X    : out   std_logic;
        RDWR    : out   std_logic;
        A       : out   std_logic_vector(31 downto 0);
        D       : inout std_logic_vector(WIDTH-1 downto 0);
        CLK     : in    std_logic;
        RESET_X : in    std_logic);
end NOODLYBOX;

architecture SIM of NOODLYBOX is
    -- 'i_' means 'internal'.
    signal i_PHASE   : string(1 to 32);
    signal i_WAKEUP  : std_logic := '1';

    signal i_CS_X    : std_logic := '1';
    signal i_OE_X    : std_logic := '1';
    signal i_WE_X    : std_logic := '1';
    signal i_BS_X    : std_logic := '1';
    signal i_RDWR    : std_logic := '1';
    signal i_A       : std_logic_vector(31 downto 0) := (others=>'0');
    signal i_D       : std_logic_vector(31 downto 0) := (others=>'0');
    signal i_HIZ     : std_logic := '1';
begin
    CS_X  <= i_CS_X;
    OE_X  <= i_OE_X;
    WE_X  <= i_WE_X;
    BS_X  <= i_BS_X;
    RDWR  <= i_RDWR;
    A     <= i_A;
    D     <= i_D(D'range) when (i_HIZ = '0') else (others=>'Z');
end;
