project new samplefpga

project set family  spartan3e
project set device  xc3s500e
project set package fg320
project set speed   -5

set hdl [lindex $argv 0]

if {$hdl eq "vhdl"} {
    foreach {i} [glob -type f -- \
        ../pkg/ACCESS_SM_PKG.vhd \
        ../pkg/MAINDCM_PKG.vhd \
        ../pkg/MIMIC_DCM_PKG.vhd \
        $env(NOODLYBOX_HOME)/model/MIMIC_DCM.vhd \
        ../rtl/*.DIA \
        ../rtl/*.vhd \
        ../rtl/SAMPLEFPGA.ucf \
        ] {
        xfile add $i
    }
    project set top RTL SAMPLEFPGA
} else {
    foreach {i} [glob -type f -- \
        $env(NOODLYBOX_HOME)/model/MIMIC_DCM.v \
        ../rtl/*.DIA \
        ../rtl/*.v \
        ../rtl/SAMPLEFPGA.ucf \
        ] {
        xfile add $i
    }
    project set top SAMPLEFPGA
}

project set "Optimization Goal" Area
project set "Safe Implementation" Yes
project set "Pack I/O Registers into IOBs" Yes

#process run "Implement Design"
project close
