# コンフィグレーションでできること
# 変数の値を変える procを再定義する
# 新しい変数を追加する etc.

# シミュレータ上でのデバッグ出力をOn/Off
#set dbg 1

# OEおよびWEの幅を変更する
set     readBodyWidth  1
set     writeBodyWidth 1

# clkRise,Fall内で使うために、vネームスペースに新しい変数を追加
# TransParent Delay
namespace eval ::v { variable tpd "6 ns" }
namespace eval ::v { variable tpdmin "1.5 ns" }

# Fsmの持つprocの上書き
namespace eval ::Fsm {
    proc changeAtOpNop {} {
        simForce ${Fsm::noodlyboxPath}/i_CS_X 1 $v::tpd
    }

    # Read T1
    proc changeAtOpRead {addr} {
        simForce ${Fsm::noodlyboxPath}/i_A    $addr $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_CS_X 0 $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_BS_X 0 $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_RDWR 1 $v::tpd
        variable execAtNextRise endOfReadT1
    }
    proc endOfReadT1 {} {
        simForce ${Fsm::noodlyboxPath}/i_OE_X 0 $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_BS_X 1 $v::tpd
    }

    # Read Tw
    proc changeAtOpRead_body {} {
    }

    # Read T2
    proc changeAtOpRead_tail {} {
        variable execAtNextRise endOfReadT2

        # Because dataLatch is called at next Rise.
        variable syncRequired 1
    }
    proc endOfReadT2 {} {
        simForce ${Fsm::noodlyboxPath}/i_OE_X 1 $v::tpd
        dataLatch
    }

    # Write T1
    proc changeAtOpWrite {addr data} {
        simForce ${Fsm::noodlyboxPath}/i_A    $addr $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_CS_X 0 $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_BS_X 0 $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_RDWR 0 $v::tpd
        variable execAtNextFall activateWE
        variable execAtNextRise "endOfWriteT1 $data"
    }
    proc activateWE {} {
        simForce ${Fsm::noodlyboxPath}/i_WE_X 0 $v::tpd
    }
    proc endOfWriteT1 {data} {
        simForce ${Fsm::noodlyboxPath}/i_D    $data $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_HIZ  0 $v::tpd
        simForce ${Fsm::noodlyboxPath}/i_BS_X 1 $v::tpd
    }

    # Write Tw
    proc changeAtOpWrite_body {} {
    }

    # Write T2
    proc changeAtOpWrite_tail {} {
        variable execAtNextFall deactivateWE
        variable execAtNextRise endOfWriteT2
    }
    proc deactivateWE {} {
        simForce ${Fsm::noodlyboxPath}/i_WE_X 1 $v::tpd
    }
    proc endOfWriteT2 {} {
        simForce ${Fsm::noodlyboxPath}/i_HIZ  1 $v::tpdmin
    }
}
