`timescale 1 ns / 1 ns
//   00000000
//   5      1
//   5      1
//   5      1
//   66666666
//   4      2
//   4      2
//   4      2
//   33333333 7

module HEXON7SEG (
    input  wire [3:0] D,
    input  wire       EN,
    output reg  [7:0] SEG);

always @(*) begin
    if (EN == 1'b1) begin
        case (D) //            .6543210
             0: SEG      <= 8'b00111111;
             1: SEG      <= 8'b00000110;
             2: SEG      <= 8'b01011011;
             3: SEG      <= 8'b01001111;
             4: SEG      <= 8'b01100110;
             5: SEG      <= 8'b01101101;
             6: SEG      <= 8'b01111101;
             7: SEG      <= 8'b00100111;
             8: SEG      <= 8'b01111111;
             9: SEG      <= 8'b01101111;
            10: SEG      <= 8'b01110111;
            11: SEG      <= 8'b01111100;
            12: SEG      <= 8'b00111001;
            13: SEG      <= 8'b01011110;
            14: SEG      <= 8'b01111001;
            default: SEG <= 8'b01110001;
        endcase
    end
    else begin
        SEG <= 8'b00000000;
    end
end

endmodule
