// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <cassert>      // assert()

#include "cMpu.h"       // Mpu
#include "inlineutil.h" // negative_logic()

// ユーザプログラムの初期化処理
void userstartup(nbox::MpuIf *mpu);

namespace nbox {
    // 静的メンバ変数の実体
    const uint32_t Mpu::RESET_X = 1<<0;

    Mpu::Mpu(int mpu_id) : MpuIf(), mpu_id(mpu_id)
    {
        // 信号はすべて'x'に初期化
        this->a.aval     = 0xffffffff;
        this->a.bval     = 0xffffffff;
        this->dout.aval  = 0xffffffff;
        this->dout.bval  = 0xffffffff;
        this->ctrlo.aval = 0xffffffff;
        this->ctrlo.bval = 0xffffffff;
    }

    Mpu::~Mpu()
    {
    }

    int Mpu::getId() const
    {
        return this->mpu_id;
    }

    // リセットならば出力信号を'x'でない状態にして、trueを返す
    // リセットでないなら出力信号は何も変えずに、単にfalseを返す
    bool Mpu::reset()
    {
        bool active = negative_logic(this->ctrli.aval & RESET_X);
        if (active) {
            this->a.aval     = 0x00000000U;
            this->a.bval     = 0x00000000U;
            this->dout.aval  = 0x00000000U;
            this->dout.bval  = 0x00000000U;

            // ctrloに含まれる信号はほとんどが負論理のはずなので、
            // とりあえず'1'にする。もし、派生クラスで'1'ではまずい
            // 信号があるならば、派生クラス::reset()にてオーバライドする。
            this->ctrlo.aval = 0xffffffffU;
            this->ctrlo.bval = 0x00000000U;

            return true;
        }
        return false;
    }

    // TODO ユーザプログラムの初期化処理を呼び出す
    // この呼び出しがあるために、ユーザプログラムがリンク対象に含まれて
    // いない場合はリンクエラーになるので、将来的にNOODLYBOXをdllとして
    // 提供するようなことがあれば再考する必要がある。
    void Mpu::startup()
    {
        ::userstartup(this);

        // プログラム終了後少しだけシミュレーションが続行していたほうが、
        // 波形が見やすくなるため
        nop(1); 
     }

    bool Mpu::readSuccess() const
    {
        return read_success;
    }

} // namespace nbox
