// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <list>    // list
#include <cstdlib> // abort()

#include "cMpuFactory.h" // MpuFactory

namespace nbox {
    typedef Mpu *(*ptrToFunc)(int mpu_id, const char *mpu_name);

    // コンストラクタで作られるリストへのポインタを保持する
    static std::list<ptrToFunc> *funcList;

    MpuFactory::MpuFactory()
    {
        static std::list<ptrToFunc> list;
        funcList = &list;
    }

    MpuFactory::~MpuFactory()
    {
    }

    void MpuFactory::addCreator(
        Mpu *(func)(int mpu_id, const char *mpu_name))
    {
        funcList->push_back(func);
    }

    // mpu_nameを作ることができたならば、それへのポインタを返却する
    // 作ることができなかったならばabortする
    Mpu *MpuFactory::create(int mpu_id, const char *mpu_name)
    {
        Mpu *mpu = 0;
        std::list<ptrToFunc>::iterator p(funcList->begin());

        while (p != funcList->end()) {
            mpu = (*p)(mpu_id, mpu_name);
            if (mpu) break;
            p++;
        }

        if (mpu == 0) {
            abort();
        }
        return mpu;
    }

    // 初回に呼び出されたときにオブジェクトを作るので、
    // 静的オブジェクトのコンストラクタから呼ばれても大丈夫
    MpuFactory *MpuFactory::getInstance()
    {
        static MpuFactory instance;
        return &instance;
    }

} // namespace nbox
