// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include <iostream>          // cerr
#include "cServerSidePipe.h" // ServerSidePipe

#define TIME_OUT 120 * 1000


namespace nbox {
    static bool debug = false;

    ServerSidePipe::ServerSidePipe(const char *pipe_name, size_t bufsize)
        : NamedPipe()
    {
	/** 
	  * コンストラクタ。
	　* パイプを作り、クライアントの接続を待つ。 
	  */

		hPipe = CreateNamedPipe(
			pipe_name,                // パイプ名
			PIPE_ACCESS_DUPLEX,       // 双方向
			PIPE_WAIT                 // ブロッキング・モード
			| PIPE_READMODE_BYTE      // バイト・モード
			| PIPE_TYPE_BYTE,
			PIPE_UNLIMITED_INSTANCES, // インスタンス数の制限なし
			bufsize,                  // 出力バッファ・サイズ
			bufsize,                  // 入力バッファ・サイズ
			TIME_OUT,                 // タイムアウト
			NULL);                    // セキュリティ属性なし

		if(hPipe == INVALID_HANDLE_VALUE){
			int eno = GetLastError();
			if(eno == 123){
				std::cerr << "Pipename format is wrong" << std::endl;
				ExitProcess(eno);
			} else {
				err_exit("CreateNamedPipe");
			}
		}
		if(debug) 
			std::cerr << "% Pipe has successfully created" << std::endl;

		// クライアントの接続待ち
		int ret = ConnectNamedPipe(hPipe, NULL);
		if(!ret) err_close_exit("ConnectNamedPipe");
		if(debug) std::cerr << "% Client has connected" << std::endl;
	}

    ServerSidePipe::~ServerSidePipe()
    {
        CloseHandle(hPipe);
    }

} // namespace nbox
