#ifndef CSH7751_H_
#define CSH7751_H_
// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2009, molelord
// All rights reserved.

#include "cMpu.h" // Mpu

namespace nbox {

    class Sh7751 : virtual public Mpu {
    private:
        // read, write\bhƁAst???, ex???, changeAt???\bhƂ̊Ԃ
        // 邽߂̏
        struct Pack {
            uint32_t addr;
            uint32_t data;
            uint32_t count;
        } pack;
        void (Sh7751::*state)();
        enum SubState{
            FIRST,
            NOPTAIL,
            READBODY,
            READTAIL,
            WRITEBODY,
            WRITETAIL,
        } subState;
        void (Sh7751::*execAtFall)();
        void (Sh7751::*execAtRise)();

        // c_waitClk()^[OɁÃNbNオ܂
        // ҂Kv邩ǂ
        // Readɂf[^oX̎荞݃^C~OT2̏I
        // Ƃ̂dlȂ̂ŁÃtOKvɂȂ
        bool need_next_rising;
    public:
        static const uint32_t CS_X;
        static const uint32_t OE_X;
        static const uint32_t WE_X;
        static const uint32_t HIZ;
        static const uint32_t BS_X;
        static const uint32_t RDWR;
    protected:
        Sh7751(int mpu_id);
    private:
        // private`ɂāARs[Ƒ֎~
        Sh7751(const Sh7751 &obj);
        Sh7751 &operator=(const Sh7751 &rhs);
    public:
        virtual ~Sh7751();
        virtual bool reflect(
            svLogicVecVal       *a,
            svLogicVecVal       *dout,
            const svLogicVecVal *ctrli,
            svLogicVecVal       *ctrlo,
            int                  clk);

        virtual void reflect_din(
            const svLogicVecVal *din);

        virtual void       nop(uint32_t clocks);
        virtual uint8_t  readB(uint32_t addr);
        virtual uint16_t readH(uint32_t addr);
        virtual uint32_t readW(uint32_t addr);
        virtual void    writeB(uint32_t addr, uint8_t  data);
        virtual void    writeH(uint32_t addr, uint16_t data);
        virtual void    writeW(uint32_t addr, uint32_t data);

    private:
        uint32_t readGeneric(uint32_t addr, int bits);

        // M(w肷Ȃ|ŋ؂)^ƁA
        // activate()ł̓ANeBuɂAdeactivate()ł̓fBANeBuɂ
        // Ăяoł͐__͍lȂĂ悢
        virtual void activate(uint32_t x, bool act = true);
        virtual void deactivate(uint32_t x);

        // stŎn܂郁\bh́Astateɑ
        void stFetch();
        void stNop();
        void stRead();
        void stWrite();

        // exŎn܂郁\bh́AexecAtFall, execAtRiseɑ
        void exEmpty();
        void exEndOfReadT1();
        void exEndOfReadT2();
        void exActivateWE();
        void exDeactivateWE();
        void exEndOfWriteT1();
        void exEndOfWriteT2();

    public:
        static Mpu *create(int mpu_id, const char *mpu_name);
    };
 
} // namespace nbox

#endif
