// This software is a part of NOODLYBOX.
// This software is distributed under the terms of the new BSD License.
// Copyright (c) 2008, molelord
// All rights reserved.

// Simple PLL model
//
//  The lock time of this model is too faster than real device.
//  It is a good point, but it is a bad point too.
//  Should be careful to it for using this model.

`timescale 1 ps / 1 ps

module MIMIC_PLL # (
        parameter MULTIPLY = 2, // can accept integer more than 1.
        parameter DIVIDE   = 1) // can accept integer more than 1.
    (
        input  wire INCLK,
        output reg  OUTCLK,
        output reg  OUTCLK_X,
        output reg  LOCKED);

    time NEWTIME     = 0;
    time OLDTIME     = 0;
    time INCLK_STEP  = 0;
    time OUTCLK_STEP = 0;
    event TICK;

    always @(posedge INCLK) begin
        NEWTIME     = $time;
        INCLK_STEP  = NEWTIME - OLDTIME;
        OUTCLK_STEP = INCLK_STEP * DIVIDE / MULTIPLY;
        OLDTIME     = NEWTIME;
    end

    always begin : A
        time NEXTTIME;
        integer i;
        integer j;

        LOCKED   <= 1'b0;
        OUTCLK   <= 1'b0;
        OUTCLK_X <= 1'b1;

        // Five clocks are necessary till OUTCLK_STEP is calculated.
        repeat (5) begin
            @(posedge INCLK);
        end

        forever begin
            OUTCLK <= 1'b1; OUTCLK_X <= 1'b0;
            #(OUTCLK_STEP/2);
            OUTCLK <= 1'b0; OUTCLK_X <= 1'b1;

            for (i = 2; i <= MULTIPLY; i = i + 1) begin
                #(OUTCLK_STEP/2);
                OUTCLK <= 1'b1; OUTCLK_X <= 1'b0;
                #(OUTCLK_STEP/2);
                OUTCLK <= 1'b0; OUTCLK_X <= 1'b1;
            end

            LOCKED <= 1'b1;

            // Next transition occurs at next rising edge of input clock.
            j = 1;
            NEXTTIME = NEWTIME + INCLK_STEP * j - $time;
            while (NEXTTIME < OUTCLK_STEP/2) begin
                j = j + 1;
                NEXTTIME = NEWTIME + INCLK_STEP * j - $time;
            end

            #(NEXTTIME);
        end
    end

endmodule
