#include <stdio.h>
#include <stdlib.h> // EXIT_FAILURE
#include "noodlybox.h"
#include "samplefpga.h"

static const char * const logname = "accessfpga.log";

// C++風味 C言語プログラム
int main(void)
{
    int i;
    u32 tmp;
    FILE *fp;
    Simulator *sim   = Simulator_instance();
    Processor *cpu   = Processor_instance();
    Samplefpga *fpga = Samplefpga_instance();

    fp = fopen(logname, "w");
    if (fp == NULL) {
        exit(EXIT_FAILURE);
    }

    // コンフィグレーション
    sim->config("../sh4config.tcl");
    sim->config("../sh4config_for_accessfpga.tcl");
    sim->endOfConfig();

    // 処理開始
    cpu->nop(10);

    // FPGAのレジスタをアクセス
    for (i = 0; i < 100; i++) {
        fpga->setFREERUN(i);
        fpga->setGPOUT(i*10);
    }

    cpu->sleep(512, "ns");

    for (i = 0; i < 100; i++) {
        tmp = fpga->getFREERUN();
        fprintf(fp, "getFREERUN : 0x%04x\n", tmp);
    }

    fpga->setGPOUT(0x5678);

    tmp = fpga->getGPOUT();
    fprintf(fp, "getGPOUT : 0x%04x\n", tmp);

    sim->endOfSimulation();
    fclose(fp);
    return 0;
}
