proc isSystemVerilog {filename} {
    # Search "DPI-C"
    set iChannel [open $filename]
    set found 0
    while {1} {
        set rc [gets $iChannel line]
        if {$rc == -1} {
            break
        }
        # Ignore any comments
        regsub "//.*" $line "" line

        if {[regexp "\"DPI-C\"" $line]} {
            set found 1
        }
    }
    close $iChannel
    return $found
}

proc create_iseproj {hdl} {
    global env
    project new samplefpga

    project set family  spartan3e
    project set device  xc3s500e
    project set package fg320
    project set speed   -5

    if {$hdl eq "vhdl"} {
        foreach {i} [glob -type f -- \
            ../pkg/ACCESS_SM_PKG.vhd \
            ../pkg/MAINDCM_PKG.vhd \
            ../pkg/MIMIC_DCM_PKG.vhd \
            $env(NOODLYBOX_HOME)/model/MIMIC_DCM.vhd \
            ../rtl/*.DIA \
            ../rtl/*.vhd \
            ../rtl/SAMPLEFPGA.ucf \
            ] {
            xfile add $i
        }
        project set top RTL SAMPLEFPGA
    } else {
        foreach {i} [glob -type f -- \
            $env(NOODLYBOX_HOME)/model/MIMIC_DCM.v \
            ../rtl/*.DIA \
            ../rtl/*.v \
            ../rtl/SAMPLEFPGA.ucf \
            ] {
            xfile add $i
        }
        project set top SAMPLEFPGA
    }

    project set "Optimization Goal" Area
    project set "Safe Implementation" Yes
    project set "Pack I/O Registers into IOBs" Yes

    #process run "Implement Design"
    project close
}

proc gatherFiles {hdl command command_sv} {
    global env

    if {$hdl eq "vhdl"} {
        foreach {i} [glob -type f -- \
            ../pkg/*.vhd \
            $env(NOODLYBOX_HOME)/model/*.vhd \
            ../model/*.vhd \
            ../rtl/*.vhd \
            ] {
            eval $command
        }
    } else {
        foreach {i} [glob -type f -- \
            $env(NOODLYBOX_HOME)/model/*.v \
            ../model/*.v \
            ../rtl/*.v \
            ] {
            if {[isSystemVerilog $i]} {
                eval $command_sv
            } else {
                eval $command
            }
        }
    }
}

proc create_isesimproj {hdl} {
    puts stdout "-- A projeft file for \"fuse\"."
    set command {puts stdout "$hdl work $i"}
    set command_sv {puts stdout ""}
    gatherFiles $hdl $command $command_sv
}

proc create_msimproj {hdl} {
    project new . noodlybox
    set command {project addfile $i}
    set command_sv {project addfile $i systemverilog "Top Level"}
    gatherFiles $hdl $command $command_sv

    project calculateorder
    project close
    exit -force
}

# main ----
if [catch {
    set proj [lindex $argv 0]
    set hdl  [lindex $argv 1]

    if       {$proj eq "ise"} {
        create_iseproj $hdl
    } elseif {$proj eq "isesim"} {
        create_isesimproj $hdl
    } elseif {$proj eq "msim"} {
        create_msimproj $hdl
    }
} errorKind ] {
    # Exception trap
    puts stderr $errorInfo
    error $errorKind
}
