// tMIMIC_PLL.v
// 簡易PLLモデル のテストベンチ
//
// MIMIC_PLLに、入力クロックに対してエッジが揃った出力クロックを出す能力が
// あることを確かめるために、
//  1. 入力クロックで更新されるカウンタの値 を 出力クロックドメイン に渡す
//  2. 出力クロックで更新されるカウンタの値 を 入力クロックドメイン に渡す
// を行う。
// もし双方のエッジにデルタ遅延などでずれがある場合は、送り側の値が即座に
// 相手側に伝わってしまう。期待値は、1と2の両方で、送り側の値の変化が
// ワンテンポ遅れて相手に伝わること。

`timescale 1 ns / 1 ns

module tMIMIC_PLL;

    localparam STEP = 10;

    reg   INCLK  = 1'b0;
    wire  OUTCLK;
    wire  LOCKED;

    reg  [3:0] R_SEND_FROM_I = 4'h0;
    reg  [3:0] R_RECEIVE_BY_O;

    reg  [3:0] R_SEND_FROM_O = 4'h0;
    reg  [3:0] R_RECEIVE_BY_I;

    always begin
        #(STEP/2);
        INCLK <= ~INCLK;
    end

    MIMIC_PLL # (
        .MULTIPLY (3), // ここを変えると倍率が変わる
        .DIVIDE   (4)) // ここを変えると分周が変わる
    DUT (
        .INCLK  (INCLK),
        .OUTCLK (OUTCLK),
        .OUTCLK_X(/*open*/),
        .LOCKED (LOCKED));

    // クロックドメインを超えたデータのやり取り 入力クロック→?倍速クロック
    always @(posedge INCLK) begin
        R_SEND_FROM_I <= R_SEND_FROM_I + 1;
    end
    always @(posedge OUTCLK) begin
        R_RECEIVE_BY_O <= R_SEND_FROM_I;
    end


    // クロックドメインを超えたデータのやり取り ?倍速クロック→入力クロック
    always @(posedge OUTCLK) begin
        R_SEND_FROM_O <= R_SEND_FROM_O + 1;
    end
    always @(posedge INCLK) begin
        R_RECEIVE_BY_I <= R_SEND_FROM_O;
    end

endmodule
