// NOODLYBOXで検証する対象のサンプル

`timescale 1 ns / 1 ns

module SAMPLEFPGA (
    input  wire        CS_X,
    input  wire        BS_X,
    input  wire        RDWR,
    input  wire  [7:0] A,
    inout  wire [15:0] D,
    output wire [15:0] GPOUT,
    input  wire        CLK,
    input  wire        RESET_X);

    // Addresses
    localparam A_FREERUN = 8'h00;
    localparam A_GPOUT   = 8'h02;

    localparam A_WIDTH =  7;
    localparam D_WIDTH = 16;

    // Registers
    reg   [A_WIDTH-1:0] R_ADDR;
    reg   [D_WIDTH-1:0] R_FREERUN;
    reg   [D_WIDTH-1:0] R_GPOUT;

    wire                MAINCLK;

    wire                ADDR_VALID;
    wire                WE;
    wire                OE;
    reg   [D_WIDTH-1:0] MUX;

    MAINDCM uMAINDCM (
        .CLKIN_IN        (CLK),
        .CLKIN_IBUFG_OUT (/*open*/),
        .CLK0_OUT        (MAINCLK));

    access_sm uACCESS_SM (
        .CLK        (MAINCLK),
        .RESET_X    (RESET_X),
        .CS_X       (CS_X),
        .BS_X       (BS_X),
        .RDWR       (RDWR),
        .ADDR_VALID (ADDR_VALID),
        .WE         (WE),
        .OE         (OE));

    // ADDR holder
    always @(posedge MAINCLK, negedge RESET_X) begin
        if (RESET_X == 1'b0) begin
            R_ADDR <= {A_WIDTH{1'b0}};
        end
        else begin
            if (ADDR_VALID == 1'b1) begin
                R_ADDR <= A;
            end
        end
    end

    always @(posedge MAINCLK, negedge RESET_X) begin
        if (RESET_X == 1'b0) begin
            R_FREERUN <= {D_WIDTH{1'b0}};
        end
        else begin
            R_FREERUN <= R_FREERUN + 1;
            if (WE == 1'b1 && R_ADDR == A_FREERUN) begin
                R_FREERUN <= D;
            end
        end
    end

    always @(posedge MAINCLK, negedge RESET_X) begin
        if (RESET_X == 1'b0) begin
            R_GPOUT <= {D_WIDTH{1'b0}};
        end
        else begin
            if (WE == 1'b1 && R_ADDR == A_GPOUT) begin
                R_GPOUT <= D;
            end
        end
    end
    assign GPOUT = R_GPOUT;

    always @(*) begin
        case (R_ADDR)
            A_FREERUN: MUX <= R_FREERUN;
            A_GPOUT:   MUX <= R_GPOUT;
            default:   MUX <= {D_WIDTH{1'bx}};
        endcase
    end
    assign D = (OE == 1'b1) ? MUX : {D_WIDTH{1'bz}};

endmodule
