-- NOODLYBOXで検証する対象のサンプル
library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_unsigned.all; -- operator '+'
use work.ACCESS_SM_PKG.all;
use work.MAINDCM_PKG.all;

entity SAMPLEFPGA is
    port (
        CS_X    : in    std_logic;
        BS_X    : in    std_logic;
        RDWR    : in    std_logic;
        A       : in    std_logic_vector(7 downto 0);
        D       : inout std_logic_vector(15 downto 0);
        GPOUT   : out   std_logic_vector(15 downto 0);
        CLK     : in    std_logic;
        RESET_X : in    std_logic);
end;

architecture RTL of SAMPLEFPGA is

    -- Addresses
    constant A_FREERUN : std_logic_vector(7 downto 0) := X"00";
    constant A_GPOUT   : std_logic_vector(7 downto 0) := X"02";

    -- Registers
    signal R_ADDR      : std_logic_vector(A'left downto 0);
    signal R_FREERUN   : std_logic_vector(D'left downto 0);
    signal R_GPOUT     : std_logic_vector(D'left downto 0);

    signal MAINCLK     : std_logic;

    signal ADDR_VALID  : std_logic;
    signal WE          : std_logic;
    signal OE          : std_logic;
    signal MUX         : std_logic_vector(D'left downto 0);

begin
    UMAINDCM : MAINDCM port map (
        CLKIN_IN        => CLK,
        --CLKIN_IBUFG_OUT =>
        CLK0_OUT        => MAINCLK
    );

    UACCESS : ACCESS_SM port map (
        CLK        => MAINCLK,
        RESET_X    => RESET_X,
        CS_X       => CS_X,
        BS_X       => BS_X,
        RDWR       => RDWR,
        ADDR_VALID => ADDR_VALID,
        WE         => WE,
        OE         => OE);

    -- ADDR holder
    process (MAINCLK, RESET_X) begin
        if (RESET_X = '0') then
            R_ADDR <= (others=>'0');
        elsif (MAINCLK'event and MAINCLK = '1') then
            if (ADDR_VALID = '1') then
                R_ADDR <= A;
            end if;
        end if;
    end process;

    process (MAINCLK, RESET_X) begin
        if (RESET_X = '0') then
            R_FREERUN <= (others=>'0');
        elsif (MAINCLK'event and MAINCLK = '1') then
            R_FREERUN <= R_FREERUN + 1;
            if (WE = '1' and R_ADDR = A_FREERUN) then
                R_FREERUN <= D;
            end if;
        end if;
    end process;

    process (MAINCLK, RESET_X) begin
        if (RESET_X = '0') then
            R_GPOUT <= (others=>'0');
        elsif (MAINCLK'event and MAINCLK = '1') then
            if (WE= '1'  and R_ADDR = A_GPOUT) then
                R_GPOUT <= D;
            end if;
        end if;
    end process;
    GPOUT <= R_GPOUT;

    process (R_ADDR, R_FREERUN, R_GPOUT) begin
        case R_ADDR is
            when A_FREERUN => MUX <= R_FREERUN;
            when A_GPOUT   => MUX <= R_GPOUT;
            when others    => MUX <= (others=>'X');
        end case;
    end process;
    D <= MUX when OE = '1' else (others=>'Z');

end RTL;
