# ModelSIM上でLED Panelを出すスクリプト

# incr Tclを使用可能にする
package require Itcl

# この記述で、Tkのウィンドウが表示される
load tk84

# 8連LEDと7セグLEDのクラスを使用可能にする
source ../../tcl/led.tcl

quit -sim
project compileoutofdate

# 読み込むモジュールは、シミュレーションの対象に合わせて書き換えが必要
vsim -t ns work.tCOUNTER

# 波形の表示
add wave sim:/tCOUNTER/*

# ウィンドウタイトルが"tk"のままだとカッコ悪いので、名前を変える
wm title . "LED Panel"

# スクリプトを再読み込みしても問題を起こさないように、
# キャンバスが作成済みなら、削除してから再作成する
if {[info command .c_ledpanel] ne ""} {
    destroy .c_ledpanel
}
# キャンバスの大きさはお好みで
pack [canvas .c_ledpanel -width 200 -height 150 -bg black]

# LEDの表示
#        obj名   x  y タグ名 色       縁取り           監視対象の信号
Led      led0   10 20 led0   "red"    "dark red"       /tCOUNTER/i_COUNT

# 7セグメントLEDの表示
#        obj名   x  y タグ名 色       縁取り           監視対象の信号
SevenSeg seg_N 110 50 seg_N  "green"  "dark green"     /tCOUNTER/i_HEX_1
SevenSeg segN_  50 50 segN_  "yellow" "dark goldenrod" /tCOUNTER/i_HEX_10

#run -all
