# This software is a part of NOODLYBOX.
# This software is distributed under the terms of the new BSD License.
# Copyright (c) 2009, 2011 molelord
# All rights reserved.

proc get_result_from_log {} {
    set result   {}
    set exp      {^# }
    set iChannel [open "isim.log" "r"]
    while {[gets $iChannel line] != -1} {
        if {[regexp -- $exp $line]} {
            set result {}
        } else {
            lappend result $line
        }
    }
    close $iChannel
    return $result
}

# Usage : gather_wave [blackbox_instance1 blackbox_instance2 ...]
proc gather_wave {args} {

    # ISE Simulator's command.
    show child -r

    set result [get_result_from_log]
    set hier [list]
    set ignore_level -1

    foreach i $result {
        regexp "^( +)(?:VHDL|Verilog)" $i dummy level
        set level [expr [string length $level] / 4 - 1]

        if {$ignore_level != -1 && $level > $ignore_level} {
            continue
        } else {
            set ignore_level -1
            set internal 0
            set instance 0

            if {[regexp "^ +(?:VHDL|Verilog) Internal Block: \{(.+)\}" $i dummy match]} {
                set internal 1
            } elseif {[regexp "^ +(?:VHDL|Verilog) Instance: \{(.+)\}" $i dummy match]} {
                set instance 1
            }
            if {$internal || $instance} {
                set len [llength $hier]
                if {$level + 1 <= $len} {
                    set hier [lreplace $hier $level $level $match]
                } else {
                    lappend hier "$match"
                }
                #puts stdout $level

                set path ""
                foreach j [lrange $hier 0 $level] {
                    append path "/$j"
                }

                foreach j $args {
                    if {[regexp -nocase -- $j $path]} {
                        set ignore_level $level
                        break
                    }
                }

                if {$ignore_level == -1 && $instance} {
                    set gid [group add $path]
                    if { [catch {
                        wave add $path -radix hex -into $gid
                    } fid] } {
                        # do nothing
                    }
                }
            }
        }
    }

}

proc dump_pblaz {instance_name} {
    divider add "PicoBlaze"

    wave add $instance_name/pc -radix hex
    wave add $instance_name/instruction -radix hex
    wave add $instance_name/port_id -radix hex
    wave add $instance_name/write_strobe
    wave add $instance_name/out_port -radix hex
    wave add $instance_name/read_strobe
    wave add $instance_name/in_port -radix hex
    wave add $instance_name/interrupt
    wave add $instance_name/interrupt_ack

    # Dump s0-sF registers
    for {set reg 0} {$reg < 16} {incr reg} {
        set name [format "s%X" $reg]
        set vbusid [virtualbus add $name -radix hex]
        wave add -into $vbusid \
        $instance_name/\\reg_loop(7)\\/register_bit/mem\[$reg\] \
        $instance_name/\\reg_loop(6)\\/register_bit/mem\[$reg\] \
        $instance_name/\\reg_loop(5)\\/register_bit/mem\[$reg\] \
        $instance_name/\\reg_loop(4)\\/register_bit/mem\[$reg\] \
        $instance_name/\\reg_loop(3)\\/register_bit/mem\[$reg\] \
        $instance_name/\\reg_loop(2)\\/register_bit/mem\[$reg\] \
        $instance_name/\\reg_loop(1)\\/register_bit/mem\[$reg\] \
        $instance_name/\\reg_loop(0)\\/register_bit/mem\[$reg\] \
    }

    wave add $instance_name/zero_flag
    wave add $instance_name/carry_flag

    # Dump the scratch pad
    for {set sc 0} {$sc < 64} {incr sc} {
        set name [format "scratchpad%02X" $sc]
        set vbusid [virtualbus add $name -radix hex]
        wave add -into $vbusid \
        $instance_name/\\store_loop(7)\\/memory_bit/mem\[$sc\] \
        $instance_name/\\store_loop(6)\\/memory_bit/mem\[$sc\] \
        $instance_name/\\store_loop(5)\\/memory_bit/mem\[$sc\] \
        $instance_name/\\store_loop(4)\\/memory_bit/mem\[$sc\] \
        $instance_name/\\store_loop(3)\\/memory_bit/mem\[$sc\] \
        $instance_name/\\store_loop(2)\\/memory_bit/mem\[$sc\] \
        $instance_name/\\store_loop(1)\\/memory_bit/mem\[$sc\] \
        $instance_name/\\store_loop(0)\\/memory_bit/mem\[$sc\]
    }
}
