#ifndef TIMER_H_
#define TIMER_H_

namespace system {
	class TimerController;
	class Task;
}

namespace system {
	/*
	 * ^C}[
	 */
	class Timer {
		// 萔
		static const dword FLAG_FREE = 0;
		static const dword FLAG_ALLOC = 1;
		static const dword FLAG_ACTIVE = 2;
		
		Timer* next_timer_;
		dword timeout_;
		
		dword flags_;
		bool auto_close_;
		
		//std::queue<Message>* fifo_;
		Task* task_;
		int fifo_data_;
		
	public:
		explicit Timer();
		
		// gp}[Nt
		void use() { flags_ = FLAG_ALLOC; }
		
		// gp}[Nt
		void release() { flags_ = FLAG_FREE; }
		
		// ^C}gpǂ
		bool used() const { return flags_ >= FLAG_ALLOC; }
		
		// ^C}쓮ǂ
		bool active() const { return flags_ == FLAG_ACTIVE; }
		
		// ^CAEgݒ肷
		void set_time(dword timeout) {
			timeout_ = timeout;
			flags_ = FLAG_ACTIVE;
		}
		
		// ^CAEg擾
		dword get_time() { return timeout_; }
		
		// ^CAEgm点
		void timeout() { flags_ = FLAG_ALLOC; }
		
		// ̃^C}[ݒ肷
		void set_nexttimer(Timer* tim) { next_timer_ = tim; }
		
		// ̃^C}[擾
		Timer* get_nexttimer() { return next_timer_; }
		
		// N[YLɂ
		void enable_autoclose() { auto_close_ = true; }
		
		// N[Y𖳌ɂ
		void disable_autoclose() { auto_close_ = false; }
		
		// N[YLǂ
		bool autoclose() { return auto_close_; }
		
		// fifoobt@ݒ
		void set_task(Task* task, int data);
		
		// fifoɑf[^ݒ
		void set_data(int data) { fifo_data_ = data; }
		
		// bZ[Wfifoobt@ɑ
		void send_message();
	};

	/*
	 * ^C}[Rg[[
	 */
	class TimerController {
		static const int MAX_TIMERS = 1024;
		dword count_; // 32rbg^C}[JE^
		Timer* timers0_; // ^C}[̎
		Timer* timer_top_; // ^C}[̐擪
		dword next_timeout_; // Ƀ^CAEg鎞
	public:
		explicit TimerController();
		~TimerController();
		
		// i߂
		void countup() { count_++; }
		
		// 擾
		dword get_count() { return count_; }
		
		// ^CAEg擾
		dword get_timeout() { return next_timeout_; }
		
		// 擪^C}[ݒ
		void set_timer_top(Timer* tim);
		
		// 擪^C}[擾
		Timer* get_timer_top() { return timer_top_; }
		
		// ^C}[𐶐
		Timer* alloc();
		
		// ^C}[
		void free(Timer* tim);
		
		// ^CAEgݒ肷
		void set_time(Timer* tim, dword timeout);
	};
	
	void timer_settime(Timer* timer, dword timeout);
}


#endif /*TIMER_H_*/
