// $Id: inf_tau.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_TAU_INF_H
#define NSIM_TAU_INF_H

namespace nsim
{

template <typename I, typename T>
class inf_tau
{
public:
    I inf;
    T tau;

    inf_tau(I const& inf = I(), T const& tau = T()) :
        inf(inf), tau(tau) {}

    double dt(double x, double y) const
    {
        return (inf(x) - y)/tau(x);
    }
    double dx(double x, double y) const
    {
        double taux(tau(x));
        return (inf.dx(x)*taux - (inf(x) - y)*tau.dx(x))/(taux*taux);
    }
    double dy(double x, double y) const
    {
        return -1.0/tau(x);
    }
};

}

#endif

