// $Id: numeric_jacob.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_NUMERIC_JACOB_H
#define NSIM_NUMERIC_JACOB_H

namespace nsim
{

template <typename Model>
class numeric_jacob : public Model
{
    template <typename V, typename M>
        void jacob(double t, V const& x, M& j, double eps = 1e-10) const
        {
            typedef boost::numeric::ublas::vector<double> vector_type;
            typedef boost::numeric::ublas::matrix<double> matrix_type;
            static vector_type xx;
            static vector_type f0;
            static vector_type f1;
            static matrix_type j;
            xx = x;
            f0.resize(x.size());
            f1.resize(x.size());
            j.resize(x.size(), x.size());

            deriv(t, xx, f0);
            for (size_type i(0); i < x.size(); ++i) {
                double xi(xx[i]);
                xx[i] += eps; 
                deriv(t, xx, f1);
                j.column(i).assign((f1 - f0)/eps);
                xx[i] = xi;
            }
        }
};

}

#endif
