// $Id: polygonal.h 26 2004-07-03 06:22:39Z takekawa $
// Copyright (C) 2004  Takashi Takekawa
// This file is part of the Nsim Library.

// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// long with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307 USA.

#ifndef NSIM_POLYGONAL_H
#define NSIM_POLYGONAL_H

#include <map>

namespace nsim
{

struct polygonal : public std::map<double, double>
{
    void set(double x)
    {
        clear();
        operator[](0) = x;
    }

    double operator()(double t) const
    {
        if (empty())
            return 0;
        const_iterator itr(upper_bound(t));
        if (itr == begin()) {
            return itr->second;
        } else if (itr == end()) {
            return (--itr)->second;
        } else {
            double const t1(itr->first), g1(itr->second);
            --itr;
            double const t0(itr->first), g0(itr->second);
            return ((t1-t)*g0 + (t-t0)*g1)/(t1-t0);
        }
    }
};

}

#endif
