/*
 * Decompiled with CFR 0.152.
 */
package twitter.action;

import java.awt.TrayIcon;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import twitter.action.TweetGetter;
import twitter.manage.TweetManager;
import twitter.manage.TweetNotifyManager;
import twitter4j.Status;
import twitter4j.TwitterException;

public class TweetMentionGetter
implements TweetGetter {
    private TweetManager tweetManager;
    private TweetNotifyManager notifyManager = null;
    private boolean isFirstTime = true;

    public TweetMentionGetter(TweetManager tweetManager) {
        this.tweetManager = tweetManager;
    }

    public TweetMentionGetter(TweetManager tweetManager, TrayIcon trayIcon) {
        this.tweetManager = tweetManager;
        this.notifyManager = new TweetNotifyManager(trayIcon);
    }

    @Override
    public List<Status> getTweetData(int num) {
        List<Status> status = null;
        try {
            status = this.tweetManager.getMentions(num);
            if (this.notifyManager != null && !this.isFirstTime) {
                this.notifyManager.showNotifyMessage(status);
            }
            this.isFirstTime = false;
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetMentionGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return status;
    }

    @Override
    public List<Status> getNewTweetData() {
        List<Status> status = null;
        try {
            status = this.tweetManager.getNewMentionData();
            if (this.notifyManager != null && !this.isFirstTime) {
                this.notifyManager.showNotifyMessage(status);
            }
            this.isFirstTime = false;
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetMentionGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return status;
    }
}

