/*
 * Decompiled with CFR 0.152.
 */
package twitter.hashtag;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import twitter.manage.TweetManager;
import twitter.util.MultiSortedMap;
import twitter4j.Status;

public class HashtagSearcher {
    private TweetManager tweetManager;
    private static final String HASHTAG_PATTERN = "#[0-9A-Za-z_]+";
    private static final int MAX_SEARCH_NUM = 100;

    public HashtagSearcher(TweetManager tweetManager) {
        this.tweetManager = tweetManager;
    }

    public MultiSortedMap<Integer, String> getDescendantHashtagCount(String searchWord) {
        MultiSortedMap<Integer, String> counter = null;
        Map<String, Integer> searchWordCounter = this.calcSearchedHashtagCount(searchWord);
        if (searchWordCounter != null) {
            counter = new MultiSortedMap<Integer, String>(new Comparator<Integer>(){

                @Override
                public int compare(Integer t, Integer t1) {
                    return t1.compareTo(t);
                }
            });
            Set<String> keyset = searchWordCounter.keySet();
            for (String key : keyset) {
                Integer val = searchWordCounter.get(key);
                counter.add(val, key);
            }
        }
        return counter;
    }

    public Map<String, Integer> calcSearchedHashtagCount(String searchWord) {
        List<Status> searchResult = this.tweetManager.getSearchResult(100, searchWord);
        if (searchResult == null || searchResult.size() == 0) {
            return null;
        }
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        for (Status s : searchResult) {
            String message = s.getText();
            if (message == null) continue;
            Map<String, Integer> oneTweet = this.getHashtagCount(message);
            Set<String> keyset = oneTweet.keySet();
            for (String key : keyset) {
                Integer count = (Integer)counter.get(key);
                if (count == null) {
                    count = new Integer(0);
                }
                count = count + oneTweet.get(key);
                counter.put(key, count);
            }
        }
        if (counter.size() == 0) {
            return null;
        }
        return counter;
    }

    public Map<String, Integer> getHashtagCount(String message) {
        Pattern userPtn = Pattern.compile(HASHTAG_PATTERN);
        Matcher matcher = userPtn.matcher(message);
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        while (matcher.find()) {
            String str = matcher.group(0);
            Integer val = (Integer)counter.get(str);
            if (val == null) {
                val = new Integer(0);
            }
            val = val + 1;
            counter.put(str, val);
        }
        return counter;
    }
}

