/*
 * Decompiled with CFR 0.152.
 */
package twitter.manage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import twitter.log.TwitterLogManager;
import twitter.manage.SimpleStatus;
import twitter.manage.SimpleUser;
import twitter4j.Annotations;
import twitter4j.DirectMessage;
import twitter4j.GeoLocation;
import twitter4j.HashtagEntity;
import twitter4j.IDs;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.Tweet;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;
import twitter4j.URLEntity;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserMentionEntity;
import twitter4j.auth.AccessToken;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;

public class TweetManager {
    private Twitter twitter = null;
    private static final String CONSUMER_KEY = "tbo5erit2M2ZzN6n8tEYcA";
    private static final String CONSUMER_SECRET = "tODurbdySLYU1pKjtB3MQTDRBGy562dHzVf7d62mm8";
    private String accessToken = "";
    private String secretToken = "";
    private static final String PROPERTIES_DIRECTORY = "properties";
    private static final String TWEET_INFO_FILENAME = "previnfo.properties";
    private static final String ACCOUNT_INFORMATION_FILENAME = "account.properties";
    private final int MAX_TWEET_NUM = 99;
    private long sinceTweetID = 0L;
    private long sinceMentionID = 0L;
    private long sinceSendDirectMessageID = 0L;
    private long sinceDirectMessageID = 0L;
    private Properties property = null;
    private Properties accountProperty = null;
    private TwitterLogManager logManager = null;
    private Map<String, List<Long>> followingUserIDList = new HashMap<String, List<Long>>();
    private Map<String, List<Long>> followerUserIDList = new HashMap<String, List<Long>>();

    public TweetManager() {
        this.logManager = new TwitterLogManager();
    }

    public void loadProperties() throws FileNotFoundException, IOException {
        if (this.property == null) {
            this.property = new Properties();
        }
        this.property.load(new FileInputStream("./properties/previnfo.properties"));
        String sti = this.property.getProperty("sinceTweetID");
        try {
            this.sinceTweetID = Long.parseLong(sti);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
    }

    public void saveProperties() throws IOException {
        File logDir = new File("./properties");
        if (!logDir.exists() && !logDir.mkdir()) {
            throw new IOException("properties\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        if (this.property == null) {
            this.property = new Properties();
        }
        this.property.setProperty("sinceTweetID", String.valueOf(this.sinceTweetID));
        this.property.store(new FileOutputStream("./properties/previnfo.properties"), null);
    }

    public void loadAccountProperties() throws FileNotFoundException, IOException {
        if (this.accountProperty == null) {
            this.accountProperty = new Properties();
        }
        this.accountProperty.load(new FileInputStream("./properties/account.properties"));
        this.accessToken = this.accountProperty.getProperty("accessToken");
        this.secretToken = this.accountProperty.getProperty("secretToken");
    }

    public void saveAccountProperties() throws IOException {
        File logDir = new File("./properties");
        if (!logDir.exists() && !logDir.mkdir()) {
            throw new IOException("properties\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3092\u4f5c\u6210\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\uff0e");
        }
        if (this.accountProperty == null) {
            this.accountProperty = new Properties();
        }
        this.accountProperty.setProperty("accessToken", this.accessToken);
        this.accountProperty.setProperty("secretToken", this.secretToken);
        this.accountProperty.store(new FileOutputStream("./properties/account.properties"), null);
    }

    public List<Status> getDirectMessages(int num) throws TwitterException {
        ResponseList directMessages = this.twitter.getDirectMessages(new Paging(1, num));
        ArrayList<Status> messageList = new ArrayList<Status>();
        if (directMessages != null && directMessages.size() > 0) {
            this.sinceDirectMessageID = ((DirectMessage)directMessages.get(0)).getId();
            for (DirectMessage message : directMessages) {
                User user = message.getSender();
                DirectMessageUserStatus status = new DirectMessageUserStatus(message, user);
                messageList.add(0, status);
            }
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public List<Status> getSendDirectMessages(int num) throws TwitterException {
        ResponseList directMessages = this.twitter.getSentDirectMessages(new Paging(1, num));
        ArrayList<Status> messageList = new ArrayList<Status>();
        if (directMessages != null && directMessages.size() > 0) {
            this.sinceSendDirectMessageID = ((DirectMessage)directMessages.get(0)).getId();
            for (DirectMessage message : directMessages) {
                User user = message.getRecipient();
                DirectMessageUserStatus status = new DirectMessageUserStatus(message, user);
                messageList.add(0, status);
            }
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public List<Status> getMentions(int num) throws TwitterException {
        ResponseList statuses = this.twitter.getMentions(new Paging(1, num));
        ArrayList<Status> tweetList = new ArrayList<Status>();
        if (statuses != null && statuses.size() > 0) {
            this.sinceMentionID = ((Status)statuses.get(0)).getId();
            Collections.reverse(statuses);
            tweetList.addAll((Collection<Status>)statuses);
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tweetList;
    }

    public List<Status> getNewDirectMessages() throws TwitterException {
        if (this.sinceDirectMessageID == 0L) {
            return this.getDirectMessages(99);
        }
        ResponseList directMessages = this.twitter.getDirectMessages(new Paging(this.sinceDirectMessageID));
        if (directMessages.size() >= 20) {
            Object ndata = this.twitter.getDirectMessages(new Paging(1, 99));
            ndata = ndata.subList(21, ndata.size());
            Iterator iterator = ndata.iterator();
            while (iterator.hasNext()) {
                DirectMessage s = (DirectMessage)iterator.next();
                if (s.getId() <= this.sinceDirectMessageID) break;
                directMessages.add(s);
            }
        }
        ArrayList<Status> messageList = new ArrayList<Status>();
        if (directMessages != null && directMessages.size() > 0) {
            this.sinceDirectMessageID = ((DirectMessage)directMessages.get(0)).getId();
            for (DirectMessage message : directMessages) {
                Status status = message.getSender().getStatus();
                messageList.add(0, status);
            }
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public List<Status> getNewSendDirectMessages() throws TwitterException {
        if (this.sinceSendDirectMessageID == 0L) {
            return this.getSendDirectMessages(99);
        }
        ResponseList directMessages = this.twitter.getDirectMessages(new Paging(this.sinceSendDirectMessageID));
        if (directMessages.size() >= 20) {
            Object ndata = this.twitter.getSentDirectMessages(new Paging(1, 99));
            ndata = ndata.subList(21, ndata.size());
            Iterator iterator = ndata.iterator();
            while (iterator.hasNext()) {
                DirectMessage s = (DirectMessage)iterator.next();
                if (s.getId() <= this.sinceSendDirectMessageID) break;
                directMessages.add(s);
            }
        }
        ArrayList<Status> messageList = new ArrayList<Status>();
        if (directMessages != null && directMessages.size() > 0) {
            this.sinceSendDirectMessageID = ((DirectMessage)directMessages.get(0)).getId();
            for (DirectMessage message : directMessages) {
                Status status = message.getRecipient().getStatus();
                messageList.add(0, status);
            }
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return messageList;
    }

    public List<Status> getNewMentionData() throws TwitterException {
        if (this.sinceMentionID == 0L) {
            return this.getMentions(99);
        }
        ResponseList statuses = this.twitter.getMentions(new Paging(this.sinceMentionID));
        if (statuses.size() >= 20) {
            Object ndata = this.twitter.getMentions(new Paging(1, 99));
            ndata = ndata.subList(21, ndata.size());
            Iterator iterator = ndata.iterator();
            while (iterator.hasNext()) {
                Status s = (Status)iterator.next();
                if (s.getId() <= this.sinceMentionID) break;
                statuses.add(s);
            }
        }
        ArrayList<Status> tweetList = new ArrayList<Status>();
        if (statuses != null && statuses.size() > 0) {
            this.sinceMentionID = ((Status)statuses.get(0)).getId();
            Collections.reverse(statuses);
            tweetList.addAll((Collection<Status>)statuses);
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tweetList;
    }

    public List<Status> getNewTimelineData() throws TwitterException {
        if (this.sinceTweetID == 0L) {
            return this.getTimeline(99);
        }
        ResponseList statuses = this.twitter.getHomeTimeline(new Paging(this.sinceTweetID));
        if (statuses.size() >= 20) {
            Object ndata = this.twitter.getHomeTimeline(new Paging(1, 99));
            ndata = ndata.subList(21, ndata.size());
            Iterator iterator = ndata.iterator();
            while (iterator.hasNext()) {
                Status s = (Status)iterator.next();
                if (s.getId() <= this.sinceTweetID) break;
                statuses.add(s);
            }
        }
        ArrayList<Status> tweetList = new ArrayList<Status>();
        if (statuses != null && statuses.size() > 0) {
            this.sinceTweetID = ((Status)statuses.get(0)).getId();
            Collections.reverse(statuses);
            tweetList.addAll((Collection<Status>)statuses);
        }
        try {
            this.logManager.add(tweetList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tweetList;
    }

    public List<Status> getTimeline(int num) throws TwitterException {
        ResponseList statuses = this.twitter.getHomeTimeline(new Paging(1, num));
        ArrayList<Status> tweetList = new ArrayList<Status>();
        if (statuses != null && statuses.size() > 0) {
            this.sinceTweetID = ((Status)statuses.get(0)).getId();
            Collections.reverse(statuses);
            tweetList.addAll((Collection<Status>)statuses);
        }
        try {
            this.logManager.add(tweetList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.saveProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tweetList;
    }

    public List<Status> getNewSearchResult(long sinceID, String searchWord) {
        if (sinceID == 0L) {
            return this.getSearchResult(99, searchWord);
        }
        Query query = new Query(searchWord);
        query.setRpp(99);
        query.setPage(1);
        query.setSinceId(sinceID);
        QueryResult queryResult = null;
        try {
            queryResult = this.twitter.search(query);
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, "Twitter search\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            ex.printStackTrace();
        }
        ArrayList<Status> tweetList = new ArrayList<Status>();
        if (queryResult != null) {
            for (Tweet tweet : queryResult.getTweets()) {
                SimpleUser user = new SimpleUser();
                user.setName(tweet.getFromUser());
                user.setScreenName(tweet.getFromUser());
                user.setId(tweet.getFromUserId());
                try {
                    user.setProfileImageURL(new URL(tweet.getProfileImageUrl()));
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                SimpleStatus status = new SimpleStatus();
                status.setCreatedAt(tweet.getCreatedAt());
                status.setId(tweet.getId());
                status.setSource(tweet.getSource());
                status.setText(tweet.getText());
                status.setUser(user);
                tweetList.add(status);
            }
        }
        Collections.reverse(tweetList);
        return tweetList;
    }

    public List<Status> getSearchResult(int num, String searchWord) {
        Query query = new Query(searchWord);
        query.setRpp(num);
        query.setPage(1);
        QueryResult queryResult = null;
        try {
            queryResult = this.twitter.search(query);
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, "Twitter search\u306b\u5931\u6557\u3057\u307e\u3057\u305f", ex);
            ex.printStackTrace();
        }
        ArrayList<Status> tweetList = new ArrayList<Status>();
        if (queryResult != null) {
            for (Tweet tweet : queryResult.getTweets()) {
                SimpleUser user = new SimpleUser();
                user.setName(tweet.getFromUser());
                user.setScreenName(tweet.getFromUser());
                user.setId(tweet.getFromUserId());
                try {
                    user.setProfileImageURL(new URL(tweet.getProfileImageUrl()));
                }
                catch (MalformedURLException ex) {
                    Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, null, ex);
                }
                SimpleStatus status = new SimpleStatus();
                status.setCreatedAt(tweet.getCreatedAt());
                status.setId(tweet.getId());
                status.setSource(tweet.getSource());
                status.setText(tweet.getText());
                status.setUser(user);
                tweetList.add(status);
            }
        }
        Collections.reverse(tweetList);
        return tweetList;
    }

    public List<Status> getFavoritesTweet(String screenName) throws TwitterException {
        ResponseList statuses = null;
        statuses = screenName == null ? this.twitter.getFavorites() : this.twitter.getFavorites(screenName);
        Collections.reverse(statuses);
        return statuses;
    }

    public List<Status> getUserTimeline(int num, long userID) throws TwitterException {
        ResponseList statuses = this.twitter.getUserTimeline(userID, new Paging(1, num));
        if (statuses != null && statuses.size() > 0) {
            Collections.reverse(statuses);
        }
        return statuses;
    }

    public List<Status> getUserTimeline(int num, String screenName) throws TwitterException {
        ResponseList statuses = this.twitter.getUserTimeline(screenName, new Paging(1, num));
        if (statuses != null && statuses.size() > 0) {
            Collections.reverse(statuses);
        }
        return statuses;
    }

    public List<UserList> getUserLists(String userScreenName) {
        ArrayList<UserList> userlist = new ArrayList<UserList>();
        long cursor = -1L;
        try {
            while (true) {
                PagableResponseList list = this.twitter.getUserLists(userScreenName, cursor);
                userlist.addAll((Collection<UserList>)list);
                if (list.hasNext()) {
                    cursor = list.getNextCursor();
                    continue;
                }
                break;
            }
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return userlist;
    }

    public List<UserList> getUserListSubscriptions(String userScreenName) {
        ArrayList<UserList> userlist = new ArrayList<UserList>();
        long cursor = -1L;
        try {
            while (true) {
                PagableResponseList list = this.twitter.getUserListSubscriptions(userScreenName, cursor);
                userlist.addAll((Collection<UserList>)list);
                if (list.hasNext()) {
                    cursor = list.getNextCursor();
                    continue;
                }
                break;
            }
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return userlist;
    }

    public List<UserList> getUserListMemberships(String userScreenName) {
        ArrayList<UserList> userlist = new ArrayList<UserList>();
        long cursor = -1L;
        try {
            while (true) {
                PagableResponseList list = this.twitter.getUserListMemberships(userScreenName, cursor);
                userlist.addAll((Collection<UserList>)list);
                if (list.hasNext()) {
                    cursor = list.getNextCursor();
                    continue;
                }
                break;
            }
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        return userlist;
    }

    public List<Status> getUserListStatuses(String userScreenName, int listID, int num) {
        ResponseList tweetList = null;
        try {
            tweetList = this.twitter.getUserListStatuses(userScreenName, listID, new Paging(1, num));
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (tweetList != null && tweetList.size() > 0) {
            Collections.reverse(tweetList);
        }
        return tweetList;
    }

    public List<Status> getNewUserListStatuses(String userScreenName, int listID, long sinceID) {
        if (sinceID == 0L) {
            return this.getUserListStatuses(userScreenName, listID, 99);
        }
        ResponseList tweetList = null;
        try {
            tweetList = this.twitter.getUserListStatuses(userScreenName, listID, new Paging(sinceID));
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (tweetList != null && tweetList.size() > 0) {
            Collections.reverse(tweetList);
        }
        return tweetList;
    }

    public List<Status> getNewUserTimeline(long userID, long sinceID) throws TwitterException {
        if (sinceID == 0L) {
            return this.getUserTimeline(99, userID);
        }
        ResponseList statuses = this.twitter.getUserTimeline(userID, new Paging(sinceID));
        if (statuses != null && statuses.size() > 0) {
            Collections.reverse(statuses);
        }
        return statuses;
    }

    public List<Status> getNewUserTimeline(String screenName, long sinceID) throws TwitterException {
        if (sinceID == 0L) {
            return this.getUserTimeline(99, screenName);
        }
        ResponseList statuses = this.twitter.getUserTimeline(screenName, new Paging(sinceID));
        if (statuses != null && statuses.size() > 0) {
            Collections.reverse(statuses);
        }
        return statuses;
    }

    public void loginTwitter() throws FileNotFoundException, IOException {
        this.twitter = new TwitterFactory().getInstance();
        this.loadAccountProperties();
        this.twitter.setOAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET);
        AccessToken ac = new AccessToken(this.accessToken, this.secretToken);
        this.twitter.setOAuthAccessToken(ac);
        try {
            this.loadProperties();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Configuration getTwitterConfiguration() {
        ConfigurationBuilder confbuilder = new ConfigurationBuilder();
        confbuilder.setOAuthConsumerKey(CONSUMER_KEY);
        confbuilder.setOAuthConsumerSecret(CONSUMER_SECRET);
        return confbuilder.build();
    }

    public void getAccessToken(String username, String password) throws TwitterException {
        Configuration conf = this.getTwitterConfiguration();
        this.twitter = new TwitterFactory(conf).getInstance();
        AccessToken oAuthAccessToken = this.twitter.getOAuthAccessToken(username, password);
        this.accessToken = oAuthAccessToken.getToken();
        this.secretToken = oAuthAccessToken.getTokenSecret();
        try {
            this.saveAccountProperties();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void tweet(String message) throws TwitterException {
        Status status = this.twitter.updateStatus(message);
    }

    public void replyTweet(String message, long replyToStatusID) throws TwitterException {
        StatusUpdate updateMsg = new StatusUpdate(message);
        updateMsg.setInReplyToStatusId(replyToStatusID);
        Status status = this.twitter.updateStatus(updateMsg);
    }

    public void sendDirectMessage(String screenName, String text) throws TwitterException {
        this.twitter.sendDirectMessage(screenName, text);
    }

    public void retweet(long statusID) throws TwitterException {
        this.twitter.retweetStatus(statusID);
    }

    public void createFavorite(long statusID) throws TwitterException {
        this.twitter.createFavorite(statusID);
    }

    public void destroyFavorite(long statusID) throws TwitterException {
        this.twitter.destroyFavorite(statusID);
    }

    public RateLimitStatus getRateLimitStatus() throws TwitterException {
        return this.twitter.getRateLimitStatus();
    }

    public String getScreenName() {
        try {
            if (this.twitter != null) {
                return this.twitter.getScreenName();
            }
        }
        catch (TwitterException twitterException) {
            // empty catch block
        }
        return null;
    }

    public List<User> getFollowingUser(String screenName, int page) {
        if (!this.followingUserIDList.containsKey(screenName)) {
            List<Long> following = this.getFollowingUserID(screenName);
            this.followingUserIDList.put(screenName, following);
        }
        List<Long> getFollowingUserIds = null;
        List<Long> followingList = this.followingUserIDList.get(screenName);
        if (followingList != null && followingList.size() > 0) {
            if (followingList.size() < page * 100) {
                return null;
            }
            int to = page * 100 + 99;
            if (followingList.size() < to) {
                to -= to - followingList.size();
            }
            getFollowingUserIds = followingList.subList(page * 100, to);
        }
        ArrayList<User> result = new ArrayList<User>();
        int getDataSize = getFollowingUserIds.size();
        if (getDataSize > 0) {
            long[] ids = new long[getDataSize];
            int i = 0;
            while (i < ids.length) {
                ids[i] = (Long)getFollowingUserIds.get(i);
                ++i;
            }
            try {
                ResponseList users = this.twitter.lookupUsers(ids);
                for (User u : users) {
                    result.add(u);
                }
            }
            catch (TwitterException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<User> getFollowerUser(String screenName, int page) {
        if (!this.followerUserIDList.containsKey(screenName)) {
            List<Long> follower = this.getFollowerUserID(screenName);
            this.followerUserIDList.put(screenName, follower);
        }
        List<Long> getFollowerUserIds = null;
        List<Long> followerList = this.followerUserIDList.get(screenName);
        if (followerList != null && followerList.size() > 0) {
            if (followerList.size() < page * 100) {
                return null;
            }
            int to = page * 100 + 99;
            if (followerList.size() < to) {
                to -= to - followerList.size();
            }
            getFollowerUserIds = followerList.subList(page * 100, to);
        }
        ArrayList<User> result = new ArrayList<User>();
        int getDataSize = getFollowerUserIds.size();
        if (getDataSize > 0) {
            long[] ids = new long[getDataSize];
            int i = 0;
            while (i < ids.length) {
                ids[i] = (Long)getFollowerUserIds.get(i);
                ++i;
            }
            try {
                ResponseList users = this.twitter.lookupUsers(ids);
                for (User u : users) {
                    result.add(u);
                }
            }
            catch (TwitterException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public List<Long> getFollowingUserID(String screenName) {
        long cursor = -1L;
        IDs ids = null;
        long[] friendIds = null;
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            do {
                if ((friendIds = (ids = this.twitter.getFriendsIDs(screenName, cursor)).getIDs()).length <= 0) continue;
                long[] lArray = friendIds;
                int n = friendIds.length;
                int n2 = 0;
                while (n2 < n) {
                    long id = lArray[n2];
                    result.add(id);
                    ++n2;
                }
            } while ((cursor = ids.getNextCursor()) != 0L);
        }
        catch (TwitterException e) {
            e.printStackTrace();
        }
        return result;
    }

    public List<Long> getFollowerUserID(String screenName) {
        long cursor = -1L;
        IDs ids = null;
        long[] friendIds = null;
        ArrayList<Long> result = new ArrayList<Long>();
        try {
            do {
                if ((friendIds = (ids = this.twitter.getFollowersIDs(screenName, cursor)).getIDs()).length <= 0) continue;
                long[] lArray = friendIds;
                int n = friendIds.length;
                int n2 = 0;
                while (n2 < n) {
                    long id = lArray[n2];
                    result.add(id);
                    ++n2;
                }
            } while ((cursor = ids.getNextCursor()) != 0L);
        }
        catch (TwitterException e) {
            e.printStackTrace();
        }
        return result;
    }

    private class DirectMessageUserStatus
    implements Status {
        private static final long serialVersionUID = 1L;
        private DirectMessage message = null;
        private User user = null;

        public DirectMessageUserStatus(DirectMessage directMessage, User user) {
            this.message = directMessage;
            this.user = user;
        }

        public String[] getContributors() {
            return null;
        }

        public Date getCreatedAt() {
            return this.message.getCreatedAt();
        }

        public GeoLocation getGeoLocation() {
            return null;
        }

        public long getId() {
            return this.user.getId();
        }

        public String getInReplyToScreenName() {
            return ((SimpleUser)this.user).getStatusInReplyToScreenName();
        }

        public long getInReplyToStatusId() {
            return ((SimpleUser)this.user).getStatusInReplyToUserId();
        }

        public long getInReplyToUserId() {
            return 0L;
        }

        public Place getPlace() {
            return null;
        }

        public RateLimitStatus getRateLimitStatus() {
            return this.user.getRateLimitStatus();
        }

        public Status getRetweetedStatus() {
            return null;
        }

        public String getSource() {
            return "Unknown";
        }

        public String getText() {
            return this.message.getText();
        }

        public User getUser() {
            return this.user;
        }

        public boolean isFavorited() {
            return ((SimpleUser)this.user).isStatusFavorited();
        }

        public boolean isRetweet() {
            return false;
        }

        public boolean isTruncated() {
            return false;
        }

        public int compareTo(Status t) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public Annotations getAnnotations() {
            return null;
        }

        public HashtagEntity[] getHashtagEntities() {
            return null;
        }

        public long getRetweetCount() {
            return 0L;
        }

        public URLEntity[] getURLEntities() {
            return null;
        }

        public UserMentionEntity[] getUserMentionEntities() {
            return null;
        }

        public boolean isRetweetedByMe() {
            return false;
        }
    }
}

