/*
 * Decompiled with CFR 0.152.
 */
package twitter.action;

import java.awt.TrayIcon;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import twitter.action.TweetGetter;
import twitter.action.TweetMentionGetter;
import twitter.manage.TweetManager;
import twitter.manage.TweetNotifyManager;
import twitter4j.Status;
import twitter4j.TwitterException;

public class TweetDirectMessageGetter
implements TweetGetter {
    private TweetManager tweetManager;
    private TweetNotifyManager notifyManager = null;
    private boolean isFirstTime = true;

    public TweetDirectMessageGetter(TweetManager tweetManager) {
        this.tweetManager = tweetManager;
    }

    public TweetDirectMessageGetter(TweetManager tweetManager, TrayIcon trayIcon) {
        this.tweetManager = tweetManager;
        this.notifyManager = new TweetNotifyManager(trayIcon, "\u3042\u306a\u305f\u5b9b\u306e\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8");
    }

    @Override
    public List<Status> getTweetData(int num) {
        List<Status> status = null;
        try {
            status = this.tweetManager.getDirectMessages(num);
            if (this.notifyManager != null && !this.isFirstTime) {
                this.notifyManager.showNotifyMessage(status);
            }
            this.isFirstTime = false;
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetMentionGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return status;
    }

    @Override
    public List<Status> getNewTweetData() {
        List<Status> status = null;
        try {
            status = this.tweetManager.getNewDirectMessages();
            if (this.notifyManager != null && !this.isFirstTime) {
                this.notifyManager.showNotifyMessage(status);
            }
            this.isFirstTime = false;
        }
        catch (TwitterException ex) {
            Logger.getLogger(TweetMentionGetter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return status;
    }
}

