/*
 * Decompiled with CFR 0.152.
 */
package twitter.gui.form;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import twitter.action.list.UserListGetter;
import twitter.gui.action.TweetMainAction;
import twitter.gui.component.TweetListTableModel;
import twitter4j.UserList;

public class UserListDialog
extends JDialog {
    private TweetMainAction mainAction = null;
    private UserListGetter userListGetter = null;
    private String listUserName = null;
    private TweetListTableModel listTableModel = new TweetListTableModel();
    private static final int iconSize = 50;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JTextArea jTextArea1;
    private JLabel userImageLabel;

    public UserListDialog(Frame parent, boolean modal, TweetMainAction mainAction, UserListGetter userListGetter, String listUserName) {
        super(parent, modal);
        this.initComponents();
        this.mainAction = mainAction;
        this.listUserName = listUserName;
        this.userListGetter = userListGetter;
        final String username = listUserName;
        new Thread(){

            @Override
            public void run() {
                UserListDialog.this.addUserListToTable(username);
            }
        }.start();
    }

    public void addUserListToTable(String username) {
        this.listTableModel.clearStatus();
        this.setTableEnvironment();
        if (this.userListGetter != null) {
            List<UserList> list = this.userListGetter.getUserLists(username);
            for (UserList u : list) {
                this.listTableModel.insertUserList(u);
            }
        }
    }

    public void setTableEnvironment() {
        TableColumnModel columnModel = this.jTable1.getColumnModel();
        TableColumn column = columnModel.getColumn(0);
        column.setMinWidth(50);
        column.setMaxWidth(50);
        this.jTable1.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                UserListDialog.this.jTable1.clearSelection();
                Point p = e.getPoint();
                int col = UserListDialog.this.jTable1.columnAtPoint(p);
                int row = UserListDialog.this.jTable1.rowAtPoint(p);
                UserListDialog.this.jTable1.changeSelection(row, col, false, false);
                UserListDialog.this.setDetailInformation(UserListDialog.this.jTable1);
            }
        });
        this.jTable1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent ke) {
                UserListDialog.this.setDetailInformation(UserListDialog.this.jTable1);
            }
        });
    }

    public void setDetailInformation(JTable table) {
        UserList userList = this.getTweetTableInformation(table, this.listTableModel);
        if (userList == null) {
            return;
        }
        String listName = userList.getName();
        String userName = userList.getUser().getName();
        int subscriber = userList.getSubscriberCount();
        int memberCount = userList.getMemberCount();
        String description = userList.getDescription();
        if (listName != null) {
            this.jLabel5.setText(listName);
        }
        if (userName != null) {
            this.jLabel6.setText(userName);
        }
        if (description != null) {
            this.jTextArea1.setText(description);
        }
        this.jLabel7.setText(String.valueOf(memberCount));
        this.jLabel8.setText(String.valueOf(subscriber));
        this.userImageLabel.setIcon(new ImageIcon(userList.getUser().getProfileImageURL()));
    }

    public UserList getTweetTableInformation(JTable table, TableModel model) {
        int index = table.convertRowIndexToModel(table.getSelectedRow());
        UserList info = null;
        if (model instanceof TweetListTableModel && index >= 0) {
            info = ((TweetListTableModel)model).getUserList(index);
        }
        return info;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.userImageLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.jTable1.setModel(this.listTableModel);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jButton1.setText("OK");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("\u30ad\u30e3\u30f3\u30bb\u30eb");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UserListDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("\u30ea\u30b9\u30c8\u540d");
        this.jLabel2.setText("\u30ea\u30b9\u30c8\u6240\u6709\u8005");
        this.jLabel3.setText("\u30d5\u30a9\u30ed\u30fc\u4e2d");
        this.jLabel4.setText("\u30ea\u30b9\u30c8\u3092\u30d5\u30a9\u30ed\u30fc");
        this.userImageLabel.setBackground(Color.black);
        this.userImageLabel.setOpaque(true);
        this.jLabel5.setText("NULL");
        this.jLabel6.setText("NULL");
        this.jLabel7.setText("0");
        this.jLabel8.setText("0");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.userImageLabel, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, 196, -2).addComponent(this.jLabel6, -2, 127, -2).addComponent(this.jLabel7, -2, 127, -2).addComponent(this.jLabel8, -2, 116, -2)).addGap(6, 6, 6).addComponent(this.jScrollPane2, -1, 388, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel4);
        jPanel1Layout.linkSize(0, this.jLabel5, this.jLabel6, this.jLabel7, this.jLabel8);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 98, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4)).addComponent(this.userImageLabel, -2, 48, -2)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 762, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(542, Short.MAX_VALUE).addComponent(this.jButton1, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton2, -2, 102, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 349, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        UserList info = this.getTweetTableInformation(this.jTable1, this.listTableModel);
        if (info == null) {
            JOptionPane.showMessageDialog(null, "\u30ea\u30b9\u30c8\u3092\u9078\u629e\u3057\u3066\u304f\u3060\u3055\u3044", "Error", 0);
            return;
        }
        String listName = info.getName();
        String userName = info.getUser().getScreenName();
        int id = info.getId();
        String fullName = info.getFullName();
        if (listName == null || userName == null || fullName == null) {
            JOptionPane.showMessageDialog(null, "\u9078\u629e\u3067\u304d\u306a\u3044\u30ea\u30b9\u30c8\u3067\u3059", "Error", 0);
            return;
        }
        this.mainAction.actionAddListTab(userName, id, fullName, this.mainAction.getGetTimelinePeriod());
        this.dispose();
    }
}

