#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <assert.h>
#include <wchar.h>
#include <iconv.h>
#include <errno.h>

#include "env.h"
#include "utils/nt_std_t.h"
#include "utils/file.h"
#include "utils/base64.h"
#include "net/nt_http.h"
#include "_2ch/model_2ch.h"
#include "_2ch/_2ch.h"

char *URL_2CH_BOARDMENU = "http://menu.2ch.net/bbsmenu.html";
nt_2ch_model_tp app_2ch_modelp;


#define S_SIZE  (1024*2)


BOOL nt_2ch_model_init(){
	app_2ch_modelp = nt_2ch_model_alloc();
	return (NULL != app_2ch_modelp);
}

BOOL nt_init_board_menu()
{
	char	*outp;
	char	*url = URL_2CH_BOARDMENU;
	iconv_t	icd;
	FILE	*fp_src;
	char	s_src[S_SIZE],	s_dst[S_SIZE*sizeof(wchar_t)];
	char	*p_src,	*p_dst;
	size_t	n_src,	n_dst;

	memset(s_src, '\0', S_SIZE);
	memset(s_dst, '\0', S_SIZE*sizeof(wchar_t));

	if(!nt_make_sha1_path(LOG_PATH, url, &outp)){
		return	FALSE;
	}


	if(!nt_http_get(url, outp, NULL)){
		free(outp);
		return FALSE;
	}

	fp_src	=	fopen(outp, "r");
	if(!fp_src){
		free(outp);
		return FALSE;
	}
	icd	=	iconv_open("wchar_t", "cp932");
	if(((iconv_t)-1) == icd){
		free(outp);
		return FALSE;
	}
	while(1){
		if(feof(fp_src))
			break;
		s_src[0] = '\0';
		fgets(s_src, S_SIZE, fp_src);
		p_src = s_src;
		p_dst = s_dst;

		n_src	=	strlen(s_src);
		n_dst	=	S_SIZE-1;
		while(0	<	n_src){
			size_t sz = iconv(icd, &p_src, &n_src, &p_dst, &n_dst);
			if(sz == -1){
				fprintf(stderr, "errno: %d %s\n", errno, s_src);
				break;
			}
		}
		//*p_dst	=	'\0';
		*((wchar_t*)p_dst) = L'\0';
		parse_board_menu(app_2ch_modelp, (const wchar_t*)s_dst);
	}

	if(fp_src)
		fclose(fp_src);
	iconv_close(icd);

	free(outp);
	
	return TRUE;
}


BOOL nt_read_thread(nt_2ch_model_tp modelp)
{
	wchar_t url[1024];
	wchar_t referer[1024];
	wchar_t buf[1024];
	char	*outp;
	wchar_t *file_name, *cptr;
	wchar_t *server_name, *board_name;
	nt_board_tp boardp;
	nt_thread_tp threadp;
	int len;
	iconv_t icd;
	FILE	*fp_src;
	char	s_src[S_SIZE*sizeof(wchar_t)];
	char	s_dst[S_SIZE*sizeof(wchar_t)];
	char	*p_src,	*p_dst;
	size_t	n_src,	n_dst;

	memset(s_src, '\0', sizeof(s_src));
	memset(s_dst, '\0', sizeof(s_dst));


	if(!modelp->selected_categoryp)
		return FALSE;
	if(!modelp->selected_boardp)
		return FALSE;
	if(!modelp->selected_threadp)
		return FALSE;

	boardp = modelp->selected_boardp;
	threadp = modelp->selected_threadp;
	file_name = threadp->file_name;

	wcscpy(url, boardp->address);
	len = wcslen(url);
	if(len <= 0)
		return FALSE;
	if(url[len-1] != L'/'){
		url[len] = L'/';
		len++;
		url[len] = L'\0';
	}
	wcscat(url, L"dat/");
	wcscat(url, file_name);

	if(!nt_parse_server_name_and_board_name(boardp->address,
		buf, sizeof(buf), &server_name, &board_name)){
		return FALSE;
	}

	wcscpy(referer, L"http://");
	wcscat(referer, server_name);
	wcscat(referer, L"/test/read.cgi/");
	wcscat(referer, board_name);
	wcscat(referer, L"/");
	wcscat(referer, file_name);
	cptr = wcsstr(referer, L".dat");
	if(cptr){
		*cptr = L'/';
		cptr++;
		*cptr = L'\0';
	}else{
		cptr = wcsstr(referer, L".cgi");
		if(cptr){
			*cptr = L'/';
			cptr++;
			*cptr = L'\0';
		}
	}
	len = wcstombs(s_src, url, sizeof(s_src)-1);
	if(len <= 0)
		return FALSE;
	len = wcstombs(s_dst, referer, sizeof(s_dst)-1);
	if(len <= 0)
		return FALSE;
	if(!nt_make_sha1_path(LOG_PATH, s_src, &outp)){
		return	FALSE;
	}

	if(!nt_http_get(s_src, outp, s_dst)){
		free(outp);
		return FALSE;
	}
	fp_src = fopen(outp, "r");
	if(!fp_src){
		free(outp);
		return FALSE;
	}
	icd	=	iconv_open("wchar_t", "cp932");
	if(((iconv_t)-1) == icd){
		fclose(fp_src);
		free(outp);
		return FALSE;
	}
	threadp->num_res = 0;
	while(1){
		if(feof(fp_src))
			break;
		s_src[0] = '\0';
		fgets(s_src, S_SIZE, fp_src);
		p_src = s_src;
		p_dst = s_dst;

		n_src	=	strlen(s_src);
		n_dst	=	sizeof(s_dst)-1;
		while(0	< n_src){
			size_t sz = iconv(icd, &p_src, &n_src, &p_dst, &n_dst);
			if(sz == -1){
				//fprintf(stderr, "errno: %d %s\n", errno, s_src);
				break;
			}
		}
		*((wchar_t*)p_dst) = L'\0';
		parse_thread(threadp, (const wchar_t*)s_dst);
	}

	fclose(fp_src);
	iconv_close(icd);
	free(outp);
	return TRUE;
}

BOOL nt_read_board(nt_2ch_model_tp modelp)
{
	wchar_t *address;
	char data[256+1];
	iconv_t icd;
	char *outp;
	int len;
	FILE	*fp_src;
	char	s_src[S_SIZE],	s_dst[S_SIZE*sizeof(wchar_t)];
	char	*p_src,	*p_dst;
	size_t	n_src,	n_dst;
	nt_board_tp boardp;

	memset(data, 0, sizeof(data));
	memset(s_src, '\0', S_SIZE);
	memset(s_dst, '\0', S_SIZE*sizeof(wchar_t));

	if(!modelp->selected_categoryp)
		return FALSE;
	if(!modelp->selected_boardp)
		return FALSE;

	boardp = modelp->selected_boardp;
	nt_board_children_free(boardp);
	address = boardp->address;
	assert(address);

	len = wcstombs(data, address, sizeof(data)-1);
	if(len <= 0)
		return FALSE;

	if(data[len-1] != '/')
		strcat(data, "/");
	strcat(data, "subject.txt");


	if(!nt_make_sha1_path(LOG_PATH, data, &outp)){
		return	FALSE;
	}

	if(!nt_http_get(data, outp, URL_2CH_BOARDMENU)){
		free(outp);
		return FALSE;
	}

	fp_src = fopen(outp, "r");
	if(!fp_src){
		free(outp);
		return FALSE;
	}
	icd	=	iconv_open("wchar_t", "cp932");
	if(((iconv_t)-1) == icd){
		fclose(fp_src);
		free(outp);
		return FALSE;
	}
	while(1){
		if(feof(fp_src))
			break;
		s_src[0] = '\0';
		fgets(s_src, S_SIZE, fp_src);
		p_src = s_src;
		p_dst = s_dst;

		n_src	=	strlen(s_src);
		n_dst	=	S_SIZE-1;
		while(0	<	n_src){
			size_t sz = iconv(icd, &p_src, &n_src, &p_dst, &n_dst);
			if(sz == -1){
				fprintf(stderr, "errno: %d %s\n", errno, s_src);
				break;
			}
		}
		*((wchar_t*)p_dst) = L'\0';
		parse_board(boardp, (const wchar_t*)s_dst);
	}

	fclose(fp_src);
	iconv_close(icd);

	free(outp);
	return TRUE;
}

