#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define _GNU_SOURCE
#include <getopt.h>

#include "env.h"

char LOG_PATH[1024];
int FORCE_REFRESH = 0;

char *app_name = "ntch";
char *version_name = "1.0";

struct option longopts[] = {
	{"refresh-screen", 0, NULL, 'r'},
	{"version", 0, NULL, 'v'},
	{"out-path", 1, NULL, 'o'}
};

extern int set_option(int argc, char* argv[])
{
	int opt ,len;

	strcpy(LOG_PATH, "./log");
	while((opt = getopt_long(
			argc, argv, "vro:", longopts, NULL)) != -1){

		switch(opt){
		case 'r':
			printf("screen refresh: on\n");
			FORCE_REFRESH = 1; 
			break;
		case 'v':
			printf("%s (NTCH) 2channel browser version - %s\n", 
				app_name , version_name);
			return 1;
		case 'o':
			printf("output path: %s\n", optarg);
			len = strlen(optarg);
			if(len == 0)
				break;
			strcpy(LOG_PATH, optarg);
			if(LOG_PATH[len-1] != '/'){
				LOG_PATH[len] = '\0';
				len++;
			}
			strcpy(LOG_PATH+len, "log");
			break;
		default:
			break;
		}
	}
	/*for(; optind < argc; optind++){
		fprintf(stderr, "Unrecognized argument %s\n",
					argv[optind]);
	}*/
	return 0;
}

