#ifndef _NT_HTTP_H_
#define _NT_HTTP_H_

#define SSL_FLAG 1
#define SET_FLAG(a,b) ((a)->flag  |= (b))
#define CLR_FLAG(a,b) ((a)->flag  &= ~(b))
#define IS_SET_FLAG(a,b) ((a)->flag & (b))

#define HTTP_RESPONCE_HEADER_BUFFER_LEN  256

#define USER_AGENT "Monazilla/1.00 (monaweb/1.00) NeetchanLinux"

#define CONTENT_TYPE_ZIP 1
#define CONTENT_TYPE_TEXT 2 

typedef struct tag_nt_http_header_t *nt_http_header_tp;
typedef struct tag_nt_http_header_t {
	int port;
	char *host;
	char *param;
	char *last_modified;
	size_t fsize;
	unsigned int flag;
}nt_http_header_t;


typedef struct tag_nt_http_response_header_t 
	*nt_http_response_header_tp;
typedef struct tag_nt_http_response_header_t {
	char	*status_text;
	int		status_code;
	char	*last_modified;
	int 	content_length;
	int 	flags;
}nt_http_response_header_t;

extern BOOL nt_http_get(const char *url, const char *out_path,
		const char *referer);
extern int nt_http_parse_response_header(int readfd,
		nt_http_response_header_tp responsep);
extern nt_http_response_header_tp nt_http_alloc_response_header();
extern void nt_http_free_response_header(
		nt_http_response_header_tp responsep);
extern BOOL nt_http_save_response_header(const char *out_path,
		nt_http_response_header_tp responsep);
extern BOOL nt_parse_server_name_and_board_name(const wchar_t *url,
	wchar_t *buf, size_t buf_size, wchar_t **server_name,
	wchar_t **board_name);
#endif /* _NT_HTTP_H_ */
