#ifndef _NT_STD_T_H_
#define _NT_STD_T_H_ 

#ifndef NULL
#define NULL ((void*)0)
#endif
#define TRUE 1
#define FALSE 0

typedef int BOOL;
typedef void (*nt_memfree_tp)(void* ptr);

typedef struct tag_nt_link_t *nt_link_tp;
typedef struct tag_nt_link_t{
	void * data;
	nt_link_tp prev;
	nt_link_tp next;
} nt_link_t;

typedef struct tag_nt_stack_t *nt_stack_tp;
typedef struct tag_nt_stack_t{
	int cursor;
	nt_link_tp linkp;
	nt_link_tp unlinkedp;
} nt_stack_t;

extern void* nt_stack_push(nt_stack_tp stackp, void* data);
extern void* nt_stack_pop(nt_stack_tp stackp);
extern void* nt_stack_cursor_next();
extern void* nt_stack_add_last(nt_stack_tp stackp, void* data);

extern nt_stack_tp nt_stack_alloc();
extern void nt_stack_free(nt_stack_tp ptr, nt_memfree_tp free_func);

extern nt_link_tp nt_link_add_data(nt_link_tp link, void *data);
extern nt_link_tp nt_link_remove(nt_link_tp src, nt_link_tp target);
extern nt_link_tp nt_link_remove_by_data(nt_link_tp link, void *data);
extern void* nt_link_get(nt_link_tp link);
extern nt_link_tp nt_link_find(nt_link_tp link, void *data);
extern nt_link_tp nt_link_next(nt_link_tp link);
extern int nt_link_num(nt_link_tp linkp);
extern void* nt_link_get_by_index(nt_link_tp linkp, int index);

typedef struct tag_nt_key_value_t *nt_key_value_tp;
typedef struct tag_nt_key_value_t{
	char *key;
	char *value;
}nt_key_value_t;

extern nt_key_value_tp nt_kay_vlalue_alloc(char *key, char *value);

#endif /* _NT_STD_T_H_ */
