#include	<sys/types.h> 
#include	<sys/socket.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<arpa/inet.h>
#include	<string.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<openssl/sha.h>
#include	<wchar.h>
#include	<assert.h>

#include	"env.h"
#include	"utils/nt_std_t.h"
#include	"utils/text.h"
#include	"utils/db.h"
#include	"net/nt_socket.h"
#include	"net/nt_http.h"


BOOL nt_parse_server_name_and_board_name(const wchar_t *url,
    wchar_t *buf, size_t buf_size, wchar_t **server_name,
	wchar_t **board_name)
{
	wchar_t *cptr1, *cptr2, *cptr3;
	int i, len;

	assert(url);

	len = wcslen(url);
	if(len >= buf_size-1)
		return FALSE;
	wcscpy(buf, url);
	
	cptr1 = wcsstr(buf, L"http://");
	if(NULL == cptr1)
		return FALSE;
	cptr1 += 7;
	
	cptr2 = wcschr(cptr1, L'/');
	if(NULL == cptr2)
		return FALSE;
	*cptr2 = L'\0';
	cptr2++;	
	cptr3 = wcschr(cptr2, L'/');
	if(cptr3 != NULL)
		*cptr3 = L'\0';

	len = wcslen(cptr2);
	for(i = len - 1; i >= 0; i--){
		if(cptr2[i] != L' ')
			break;
		cptr2[i] = L'\0';
	}
	*server_name = cptr1;
	*board_name = cptr2;
	return TRUE;
}
