#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
#include <wchar.h>
#include <ncursesw/ncurses.h>

#include	"env.h"
#include	"utils/nt_std_t.h"
#include	"_2ch/_2ch.h"
#include	"_2ch/model_2ch.h"
#include	"ui/disp.h"
#include	"ui/disp_string.h"

typedef struct tag_ctx_threadlist_t *ctx_threadlist_tp;
typedef struct tag_ctx_threadlist_t
{
	int thread_num;
	int cursor_pos;
	int scroll_pos;

} ctx_threadlist_t;


static ctx_threadlist_tp init_context(nt_2ch_model_tp modelp);

int disp_threadlist(nt_window_tp wp, nt_2ch_model_tp modelp)
{
	ctx_threadlist_tp ctxp;
	nt_board_tp boardp;
	nt_thread_tp threadp;
	nt_link_tp clistp;
	int i, rows, nwrite, len, ch;
	int btm_cur, num, wlines;
	wchar_t buf[16];
	attr_t attr;

	ctxp = (ctx_threadlist_tp)wp->data;
	if(!ctxp){
		ctxp = init_context(modelp);
		if(!ctxp)
			return DISP_STATE_ERROR;
		wp->data = ctxp;
	}
	ch = wp->key;

	boardp = modelp->selected_boardp;

	switch(ch){
	case NT_KEY_CLOSE:
		return DISP_STATE_BOARDMENU;
	case NT_KEY_BOTTOM:
		ctxp->cursor_pos = ctxp->thread_num - 1;

		wlines = ctxp->thread_num * 2;
		wlines -= wp->lines;
		if(wlines < 0){
			ctxp->scroll_pos = 0;
			break;
		}
		ctxp->scroll_pos = wlines;
		//ctxp->scroll_pos += wlines%2;
		break;
	case NT_KEY_COMMAND1:
		assert(wp->cmd_param);
		num = atoi(wp->cmd_param);
		if(0 == num)
			break;
		num--;
		wlines = ctxp->thread_num - num;
		if(wlines <= 0)
			break;

		wlines *= 2;
		ctxp->cursor_pos = num;
		if(wp->lines < wlines){
			ctxp->scroll_pos = num * 2;
		}else{
			ctxp->scroll_pos =
				ctxp->thread_num * 2 - wp->lines;
		}
		break;
	case NT_KEY_UP:
		ctxp->cursor_pos--;
		if(ctxp->cursor_pos < 0)
			ctxp->cursor_pos = 0;
		if(ctxp->scroll_pos > (ctxp->cursor_pos*2)){
			ctxp->scroll_pos = ctxp->cursor_pos*2;
		}
		break;
	case NT_KEY_DOWN:
		ctxp->cursor_pos++;
		if(ctxp->cursor_pos >= ctxp->thread_num)
			ctxp->cursor_pos = ctxp->thread_num - 1;
		btm_cur = ctxp->cursor_pos * 2 + 1;
		if(btm_cur >= (ctxp->scroll_pos + wp->lines)){
			ctxp->scroll_pos = btm_cur;
			ctxp->scroll_pos -= wp->lines;
			ctxp->scroll_pos++;
		}
		break;
	case NT_KEY_PAGEUP:
		if(wp->lines >= ctxp->thread_num*2){
			ctxp->scroll_pos = 0;
			break;
		}
		ctxp->scroll_pos -= wp->lines;
		if(ctxp->scroll_pos < 0){
			ctxp->cursor_pos *= 2;
			ctxp->cursor_pos -= ctxp->scroll_pos + wp->lines;
			ctxp->scroll_pos =  0;
			//ctxp->cursor_pos += ctxp->scroll_pos;
			ctxp->cursor_pos /= 2;
		}else{
			ctxp->cursor_pos -= wp->lines / 2;
			if(ctxp->cursor_pos * 2 < ctxp->scroll_pos)
				ctxp->cursor_pos = ctxp->scroll_pos / 2;
			if(ctxp->cursor_pos * 2 >= ctxp->scroll_pos + wp->lines){
				ctxp->cursor_pos = (ctxp->scroll_pos + wp->lines) / 2;
				ctxp->cursor_pos -= (ctxp->scroll_pos + wp->lines) % 2;
			}
		}
		break;
	case NT_KEY_PAGEDOWN:
		if(wp->lines >= ctxp->thread_num*2){
			ctxp->scroll_pos = 0;
			break;
		}
		ctxp->scroll_pos += wp->lines;
		if(ctxp->scroll_pos + wp->lines > ctxp->thread_num*2){
			ctxp->cursor_pos *= 2;
			ctxp->cursor_pos -= ctxp->scroll_pos - wp->lines;
			ctxp->scroll_pos =  (ctxp->thread_num * 2) - wp->lines;
			ctxp->cursor_pos += ctxp->scroll_pos;
			ctxp->cursor_pos /= 2;
		}else{
			ctxp->cursor_pos += wp->lines / 2;
			if(ctxp->cursor_pos * 2 < ctxp->scroll_pos)
				ctxp->cursor_pos = ctxp->scroll_pos / 2;
			if(ctxp->cursor_pos * 2 >= ctxp->scroll_pos + wp->lines){
				ctxp->cursor_pos = (ctxp->scroll_pos + wp->lines) / 2;
				ctxp->cursor_pos -= (ctxp->scroll_pos + wp->lines) % 2;
			}
		}
		break;
	case NT_KEY_SELECT:
		threadp = nt_link_get_by_index(boardp->threadlistp,
				ctxp->cursor_pos);
		if(!threadp)
			break;
		nt_set_selected_thread(modelp, threadp);
		if(nt_read_thread(modelp))
			return DISP_STATE_RESLIST;
		break;
	}

	clistp = boardp->threadlistp;
	rows = 0;
	for(i = 0; i < ctxp->thread_num; i++){
		if(rows >= (wp->lines+ctxp->scroll_pos))
			break;
		if(ctxp->cursor_pos == i)
			attr = WA_BOLD;
		else
			attr = 0;
		threadp = (nt_thread_tp)clistp->data;
		len = wcslen(threadp->name);
		if(rows >= ctxp->scroll_pos){
			wmove(wp->wp, rows - ctxp->scroll_pos, 0);
			if(-1 == swprintf(buf, sizeof(buf)-1, L"%5d.", i+1))
				continue;

			nt_add_wstr(wp->wp, buf, attr);
			nwrite = nt_add_wnstr(wp->wp, threadp->name, attr, 
						wp->cols - 5); 
		}else{
			nwrite = nt_get_wc_count_within_colmns(
					threadp->name, wp->cols - 5);
		}
		rows++;
		if(rows >= (wp->lines+ctxp->scroll_pos))
			break;
		if(rows >= ctxp->scroll_pos){
			wmove(wp->wp, rows - ctxp->scroll_pos, 0);
			nt_add_wnch(wp->wp, L' ', WA_UNDERLINE | attr, wp->cols);
			wmove(wp->wp, rows - ctxp->scroll_pos, 5);
			if(nwrite < len){
				nwrite = nt_add_wnstr(wp->wp, 
					threadp->name + nwrite, 
					WA_UNDERLINE | attr, wp->cols - 5); 
			}
		}
		rows++;
		clistp = clistp->next;
	}/* end for */
	
	return DISP_STATE_THREADTITLE; 
}

static ctx_threadlist_tp init_context(nt_2ch_model_tp modelp)
{
	ctx_threadlist_tp ctxp;
	nt_board_tp boardp;
	ctxp = (ctx_threadlist_tp)calloc(1,sizeof(nt_2ch_model_t));

	if(!ctxp)
		return NULL;

	boardp = modelp->selected_boardp;
	ctxp->thread_num = nt_link_num(boardp->threadlistp);

	return ctxp;
}

void free_threadlist_ctx(void *ptr)
{
	ctx_threadlist_tp ctxp;
	if(!ptr)
		return;
	 ctxp = (ctx_threadlist_tp)ptr;
	 free(ctxp);
}



