#include <stdio.h>
#include <stdlib.h>
#include <wchar.h>
#include <string.h>
#include <assert.h>

#include "utils/nt_std_t.h"
#include "utils/text.h"

BOOL nt_w_str_move(wchar_t *buf, size_t buf_len, 
					int move_index, int offset)
{
	int str_len, tmp, i;
	assert(buf);

	str_len = wcslen(buf);

	if(0 > move_index || str_len <= move_index)
		return FALSE;

	tmp = str_len + offset;
	if(tmp >= buf_len)
		return FALSE;

	if(offset == 0){
	// Do nothing.
		return TRUE;
	}else if(offset < 0){
	// Move the block to forward.
		if(move_index + offset < 0)
			return FALSE;
		//str_len += offset;
		for(i = move_index; i < str_len; i++){
			buf[i+offset] = buf[i];
		}
		buf[str_len+offset] =  L'\0';
	}else{/* if(offset > 0) */
	// Move the block to backward.
		if(str_len + offset >= buf_len)
			return FALSE;
		for(i = str_len - 1; i >= move_index; i--){
			buf[i + offset] = buf[i];
		}
		buf[str_len + offset] = L'\0';
		buf[move_index] = L'\0';
	}
	return TRUE;
}

wchar_t *nt_w_trim(const wchar_t *source)
{
	assert(source != NULL);
	int len = wcslen(source);
	int i, j, status;
	wchar_t *cptr;

	for(i=0; i<len; i++){
		switch(source[i]){
		case L' ':
		case L'\t':
		case L'\r':
		case L'\n':
			status = 1;
			break;
		default:
			status = 0;
			break;
		}
		if(status == 0)
			break;
	}/* end for */
	if(i == len){
		cptr = malloc(sizeof(wchar_t));
		if(cptr != NULL)
			cptr[0] = L'\0';
		return cptr;
	}
	for(j = len - 1; j > i; j--){
		switch(source[j]){
		case L' ':
		case L'\t':
		case L'\r':
		case L'\n':
			status = 1;
			break;
		default:
			status = 0;
			break;
		}
		if(status == 0)
			break;
	}/* end for */
	assert(i <= j);
	len = j - i + 1;
	cptr = malloc(sizeof(wchar_t)*(len + 1));
	if(cptr != NULL){
		memcpy(cptr, source+i, len*sizeof(wchar_t));
		cptr[len] = '\0';
	}
	return cptr;
}

wchar_t *nt_w_trim_quotes(const wchar_t *source)
{
	assert(source != NULL);
	int len = wcslen(source);
	int i, j, status = 0;
	wchar_t *cptr;
	BOOL dquote = FALSE;
	BOOL squote = FALSE;

	for(i=0; i<len; i++){
		switch(source[i]){
		case L' ':
		case L'\t':
		case L'\r':
		case L'\n':
			if(status == 2){
				status = 0;
				break;
			}
			status = 1;
			break;
		case '\"':
			dquote = TRUE;
			status = 2;
			break;
		case '\'':
			squote = TRUE;
			status = 2;
			break;
		default:
			status = 0;
			break;
		}
		if(status == 0)
			break;
	}/* end for */
	if(i == len){
		cptr = malloc(sizeof(wchar_t));
		if(cptr != NULL)
			cptr[0] = L'\0';
		return cptr;
	}
	for(j = len - 1; j > i; j--){
		switch(source[j]){
		case L' ':
		case L'\t':
		case L'\r':
		case L'\n':
			if(status == 2)
				status = 0;
			else
				status = 1;
			break;
		case '\"':
			if(!dquote)
				status = 0;
			else
				status = 2;
			break;
		case '\'':
			if(!squote)
				status = 0;
			else
				status = 2;
			break;
		default:
			status = 0;
			break;
		}
		if(status == 0)
			break;
	}/* end for */
	len = j - i + 1;
	if(i < j){
		cptr = malloc(sizeof(wchar_t)*(len + 1));
		if(cptr != NULL){
			memcpy(cptr, source+i, len*sizeof(wchar_t));
			cptr[len] = L'\0';
		}
	}else{
		cptr = malloc(sizeof(wchar_t));
		if(cptr != NULL){
			cptr[0] = L'\0';
		}
	}
	return cptr;
}

char *nt_trim(const char *source)
{
	assert(source != NULL);
	int len = strlen(source);
	int i, j, status;
	char *cptr;

	for(i=0; i<len; i++){
		switch(source[i]){
		case ' ':
		case '\t':
		case '\r':
		case '\n':
			status = 1;
			break;
		default:
			status = 0;
			break;
		}
		if(status == 0)
			break;
	}/* end for */
	if(i == len){
		cptr = malloc(1);
		if(cptr != NULL)
			cptr[0] = '\0';
		return cptr;
	}
	for(j = len - 1; j > i; j--){
		switch(source[j]){
		case ' ':
		case '\t':
		case '\r':
		case '\n':
			status = 1;
			break;
		default:
			status = 0;
			break;
		}
		if(status == 0)
			break;
	}/* end for */
	assert(i < j);
	len = j - i + 1;
	cptr = malloc(len + 1);
	if(cptr != NULL){
		memcpy(cptr, source+i, len);
		cptr[len] = '\0';
	}
	return cptr;
}
