/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <pwd.h>

#define _GNU_SOURCE
#include <getopt.h>

#include "env.h"
#include "utils/nt_std_t.h"
#include "utils/file.h"
#include "utils/text.h"

char LOG_PATH[1024];
char USR_PATH[1024];
char USR_COOKIE_PATH[1024];
char USR_LOG_DB_PATH[1024];
char USR_FAVORITE_BOARD_FILE_PATH[1024];
char USR_FAVORITE_GRP_FILE_PATH[1024];
char USR_FAVORITE_THREAD_FILE_PATH[1024];
char EDITOR_CMD[1024]; 
int FORCE_REFRESH = 0; 
int THREAD_SORT_TYPE = NT_THREAD_SORT_BY_READ; 
int INIT_DISP_STATE = NT_INTI_DISP_BOARDMENU; 
int NT_MAINLOOP_POOLING_INTERVAL;
int NT_PTHREAD_POOL_SIZE;
int NT_PTHREAD_POOL_QUEUE_SIZE;

static char *app_name = PACKAGE_NAME;
static char *version_name = PACKAGE_VERSION;
static char *def_editor_cmd = "vi";

char *MARU_ID;
char *MARU_PW;

struct option longopts[] = {
	{"refresh-screen", 0, NULL, 'r'},
	{"version", 0, NULL, 'v'},
	{"help", 0, NULL, 'h'},
	{"editor", 1, NULL, 'e'},
	{"out-path", 1, NULL, 'o'}
};

extern void print_help();
extern BOOL read_resource(const char *path);

int set_option(int argc, char* argv[])
{
	int opt ,len;
	uid_t uid;
	struct passwd *pw;
	char buf[256];

	MARU_ID = NULL;
	MARU_PW = NULL;
	
	NT_MAINLOOP_POOLING_INTERVAL = 1000;
	NT_PTHREAD_POOL_SIZE = 5;
	NT_PTHREAD_POOL_QUEUE_SIZE = 20;

	uid = getuid();
	pw = getpwuid(uid);
	if(!pw){
		perror("Could not find user info.(home dir)\n");
		return -1;
	}
	sprintf(USR_PATH, "%s/.ntch", pw->pw_dir);
	sprintf(USR_COOKIE_PATH, "%s/cookie", USR_PATH);
	sprintf(USR_LOG_DB_PATH, "%s/usr_log.sqlite3", USR_PATH);
	sprintf(USR_FAVORITE_BOARD_FILE_PATH, "%s/fb.txt", USR_PATH);
	sprintf(USR_FAVORITE_GRP_FILE_PATH, "%s/ftab.txt", USR_PATH);
	sprintf(USR_FAVORITE_THREAD_FILE_PATH, "%s/ft.txt", USR_PATH);

	sprintf(buf, "%s/.ntchrc", pw->pw_dir);
	if(!read_resource(buf)){
		fputs(
			"Could not read user's resource file. \n\tuse default.\n", 
			stderr);
	}

	strcpy(LOG_PATH, "./log");
	strcpy(EDITOR_CMD, def_editor_cmd); 

	if(!nt_mkdir(USR_PATH)){
		return -1;
	}

	while((opt = getopt_long(
			argc, argv, "hvro:", longopts, NULL)) != -1){

		switch(opt){
		case 'r':
			printf("screen refresh: on\n");
			FORCE_REFRESH = 1; 
			break;
		case 'v':
			printf("%s (NTCH) 2channel browser version - %s\n", 
				app_name , version_name);
			return 1;
		case 'h':
			print_help();
			return 1;
		case 'o':
			printf("output path: %s\n", optarg);
			len = strlen(optarg);
			if(len == 0)
				break;
			strcpy(LOG_PATH, optarg);
			if(LOG_PATH[len-1] != '/'){
				LOG_PATH[len++] = '/';
			}
			strcpy(LOG_PATH+len, "log");
			break;
		default:
			break;
		}
	}
	/*for(; optind < argc; optind++){
		fprintf(stderr, "Unrecognized argument %s\n",
					argv[optind]);
	}*/
	return 0;
}


extern BOOL read_resource(const char *path)
{
	FILE *fp;
	char *cptr, *key, *val;
	char *sort_type, *init_disp;
	char buf[128];

	fp = fopen(path, "r");
	if(!fp)
		return FALSE;
	
	while(fgets(buf, sizeof(buf), fp)){
		cptr = strchr(buf, '=');
		if(!cptr)
			continue;

		*cptr = '\0';
		key = strstr(buf, "maru-id");
		if(key){
			val = cptr+1;
			MARU_ID = nt_trim(val);
			continue;
		}
		key = strstr(buf, "maru-pw");
		if(key){
			val = cptr+1;
			MARU_PW = nt_trim(val);
			continue;
		}
		key = strstr(buf, "sort");
		if(key){
			val = cptr+1;
			sort_type = nt_trim(val);
			if(!sort_type)
				break;
			if(0 == strcmp(sort_type, "number")){
				THREAD_SORT_TYPE = NT_THREAD_SORT_BY_NUMBER;
			}else if(0 == strcmp(sort_type, "read")){
				THREAD_SORT_TYPE = NT_THREAD_SORT_BY_READ;
			}else if(0 == strcmp(sort_type, "unread")){
				THREAD_SORT_TYPE = NT_THREAD_SORT_BY_UNREAD;
			}
			free(sort_type);
			continue;
		}
		key = strstr(buf, "show");
		if(key){
			val = cptr+1;
			init_disp = nt_trim(val);
			if(!init_disp)
				break;
			if(0 == strcmp(init_disp, "favorite")){
				INIT_DISP_STATE = NT_INTI_DISP_FAVORITE;
			}
			free(init_disp);
			continue;
		}
	}
	fclose(fp);
	return TRUE;
}
