/* Copyright 2013 Akira Ohta (akohta001@gmail.com)
    This file is part of ntch.

    The ntch is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    The ntch is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with ntch.  If not, see <http://www.gnu.org/licenses/>.
    
*/
#ifndef _USR_DB_T_H_ 
#define _USR_DB_T_H_

typedef struct tag_nt_usr_db_handle{
	int chk_sum;
}nt_usr_db_handle_t, *nt_usr_db_handle;

typedef struct tag_nt_usr_db_thread_data_t *nt_usr_db_thread_data_tp;
typedef struct tag_nt_usr_db_thread_data_t{
     int read_count;
	 wchar_t *dat_name;
}nt_usr_db_thread_data_t;

extern void nt_usr_db_thread_data_free(void *ptr);
extern int nt_usr_db_get_read_count_by_dat_name(
    nt_link_tp thread_data_list, const wchar_t *dat_name);


extern nt_usr_db_handle nt_usr_db_init_lib(const char *db_path);
extern void nt_usr_db_finish_lib(nt_usr_db_handle db_handle);
extern BOOL nt_usr_db_open(nt_usr_db_handle db_handle);
extern void nt_usr_db_close(nt_usr_db_handle db_handle);
extern int nt_usr_db_update_read_count(nt_usr_db_handle db_handle,
     const wchar_t *board_name, const wchar_t *dat_name, int prev_read, 
     const char *date_time);
extern nt_link_tp nt_usr_db_query_read_count_list(nt_usr_db_handle db_handle,
	const wchar_t *board_name);
extern BOOL nt_usr_db_delete_board_log(nt_usr_db_handle db_handle,
    const wchar_t *board_name);
extern BOOL nt_usr_db_delete_thread_log(nt_usr_db_handle db_handle,
    const wchar_t *board_name, const wchar_t *dat_name,
	nt_link_tp *thread_data_list);
extern char* nt_usr_db_board_last_query(nt_usr_db_handle db_handle,
	const wchar_t *board_name);


#endif /* __USR_DB_T_H_ */
